/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the information for an Amazon CloudFront streaming distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamingDistributionSummary implements
        ToCopyableBuilder<StreamingDistributionSummary.Builder, StreamingDistributionSummary> {
    private final String id;

    private final String arn;

    private final String status;

    private final Instant lastModifiedTime;

    private final String domainName;

    private final S3Origin s3Origin;

    private final Aliases aliases;

    private final TrustedSigners trustedSigners;

    private final String comment;

    private final String priceClass;

    private final Boolean enabled;

    private StreamingDistributionSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.domainName = builder.domainName;
        this.s3Origin = builder.s3Origin;
        this.aliases = builder.aliases;
        this.trustedSigners = builder.trustedSigners;
        this.comment = builder.comment;
        this.priceClass = builder.priceClass;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The identifier for the distribution, for example, <code>EDFDVBD632BHDS5</code>.
     * </p>
     * 
     * @return The identifier for the distribution, for example, <code>EDFDVBD632BHDS5</code>.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) for the streaming distribution. For example:
     * <code>arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5</code>, where
     * <code>123456789012</code> is your AWS account ID.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) for the streaming distribution. For example:
     *         <code>arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5</code>, where
     *         <code>123456789012</code> is your AWS account ID.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * Indicates the current status of the distribution. When the status is <code>Deployed</code>, the distribution's
     * information is fully propagated throughout the Amazon CloudFront system.
     * </p>
     * 
     * @return Indicates the current status of the distribution. When the status is <code>Deployed</code>, the
     *         distribution's information is fully propagated throughout the Amazon CloudFront system.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The date and time the distribution was last modified.
     * </p>
     * 
     * @return The date and time the distribution was last modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The domain name corresponding to the distribution, for example, <code>d111111abcdef8.cloudfront.net</code>.
     * </p>
     * 
     * @return The domain name corresponding to the distribution, for example,
     *         <code>d111111abcdef8.cloudfront.net</code>.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your
     * media files for distribution.
     * </p>
     * 
     * @return A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get
     *         your media files for distribution.
     */
    public S3Origin s3Origin() {
        return s3Origin;
    }

    /**
     * <p>
     * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming
     * distribution.
     * </p>
     * 
     * @return A complex type that contains information about CNAMEs (alternate domain names), if any, for this
     *         streaming distribution.
     */
    public Aliases aliases() {
        return aliases;
    }

    /**
     * <p>
     * A complex type that specifies the AWS accounts, if any, that you want to allow to create signed URLs for private
     * content. If you want to require signed URLs in requests for objects in the target origin that match the
     * <code>PathPattern</code> for this cache behavior, specify <code>true</code> for <code>Enabled</code>, and specify
     * the applicable values for <code>Quantity</code> and <code>Items</code>.If you don't want to require signed URLs
     * in requests for objects that match <code>PathPattern</code>, specify <code>false</code> for <code>Enabled</code>
     * and <code>0</code> for <code>Quantity</code>. Omit <code>Items</code>. To add, change, or remove one or more
     * trusted signers, change <code>Enabled</code> to <code>true</code> (if it's currently <code>false</code>), change
     * <code>Quantity</code> as applicable, and specify all of the trusted signers that you want to include in the
     * updated distribution.
     * </p>
     * 
     * @return A complex type that specifies the AWS accounts, if any, that you want to allow to create signed URLs for
     *         private content. If you want to require signed URLs in requests for objects in the target origin that
     *         match the <code>PathPattern</code> for this cache behavior, specify <code>true</code> for
     *         <code>Enabled</code>, and specify the applicable values for <code>Quantity</code> and <code>Items</code>
     *         .If you don't want to require signed URLs in requests for objects that match <code>PathPattern</code>,
     *         specify <code>false</code> for <code>Enabled</code> and <code>0</code> for <code>Quantity</code>. Omit
     *         <code>Items</code>. To add, change, or remove one or more trusted signers, change <code>Enabled</code> to
     *         <code>true</code> (if it's currently <code>false</code>), change <code>Quantity</code> as applicable, and
     *         specify all of the trusted signers that you want to include in the updated distribution.
     */
    public TrustedSigners trustedSigners() {
        return trustedSigners;
    }

    /**
     * <p>
     * The comment originally specified when this distribution was created.
     * </p>
     * 
     * @return The comment originally specified when this distribution was created.
     */
    public String comment() {
        return comment;
    }

    /**
     * Returns the value of the PriceClass property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceClass} will
     * return {@link PriceClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceClassAsString}.
     * </p>
     * 
     * @return The value of the PriceClass property for this object.
     * @see PriceClass
     */
    public PriceClass priceClass() {
        return PriceClass.fromValue(priceClass);
    }

    /**
     * Returns the value of the PriceClass property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceClass} will
     * return {@link PriceClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceClassAsString}.
     * </p>
     * 
     * @return The value of the PriceClass property for this object.
     * @see PriceClass
     */
    public String priceClassAsString() {
        return priceClass;
    }

    /**
     * <p>
     * Whether the distribution is enabled to accept end user requests for content.
     * </p>
     * 
     * @return Whether the distribution is enabled to accept end user requests for content.
     */
    public Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(s3Origin());
        hashCode = 31 * hashCode + Objects.hashCode(aliases());
        hashCode = 31 * hashCode + Objects.hashCode(trustedSigners());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(priceClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingDistributionSummary)) {
            return false;
        }
        StreamingDistributionSummary other = (StreamingDistributionSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(status(), other.status())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(domainName(), other.domainName()) && Objects.equals(s3Origin(), other.s3Origin())
                && Objects.equals(aliases(), other.aliases()) && Objects.equals(trustedSigners(), other.trustedSigners())
                && Objects.equals(comment(), other.comment()) && Objects.equals(priceClassAsString(), other.priceClassAsString())
                && Objects.equals(enabled(), other.enabled());
    }

    @Override
    public String toString() {
        return ToString.builder("StreamingDistributionSummary").add("Id", id()).add("ARN", arn()).add("Status", status())
                .add("LastModifiedTime", lastModifiedTime()).add("DomainName", domainName()).add("S3Origin", s3Origin())
                .add("Aliases", aliases()).add("TrustedSigners", trustedSigners()).add("Comment", comment())
                .add("PriceClass", priceClassAsString()).add("Enabled", enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "S3Origin":
            return Optional.ofNullable(clazz.cast(s3Origin()));
        case "Aliases":
            return Optional.ofNullable(clazz.cast(aliases()));
        case "TrustedSigners":
            return Optional.ofNullable(clazz.cast(trustedSigners()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "PriceClass":
            return Optional.ofNullable(clazz.cast(priceClassAsString()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, StreamingDistributionSummary> {
        /**
         * <p>
         * The identifier for the distribution, for example, <code>EDFDVBD632BHDS5</code>.
         * </p>
         * 
         * @param id
         *        The identifier for the distribution, for example, <code>EDFDVBD632BHDS5</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN (Amazon Resource Name) for the streaming distribution. For example:
         * <code>arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5</code>, where
         * <code>123456789012</code> is your AWS account ID.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) for the streaming distribution. For example:
         *        <code>arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5</code>, where
         *        <code>123456789012</code> is your AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Indicates the current status of the distribution. When the status is <code>Deployed</code>, the
         * distribution's information is fully propagated throughout the Amazon CloudFront system.
         * </p>
         * 
         * @param status
         *        Indicates the current status of the distribution. When the status is <code>Deployed</code>, the
         *        distribution's information is fully propagated throughout the Amazon CloudFront system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time the distribution was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time the distribution was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The domain name corresponding to the distribution, for example, <code>d111111abcdef8.cloudfront.net</code>.
         * </p>
         * 
         * @param domainName
         *        The domain name corresponding to the distribution, for example,
         *        <code>d111111abcdef8.cloudfront.net</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get
         * your media files for distribution.
         * </p>
         * 
         * @param s3Origin
         *        A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to
         *        get your media files for distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Origin(S3Origin s3Origin);

        /**
         * <p>
         * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get
         * your media files for distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Origin.Builder} avoiding the need to create
         * one manually via {@link S3Origin#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Origin.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Origin(S3Origin)}.
         * 
         * @param s3Origin
         *        a consumer that will call methods on {@link S3Origin.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Origin(S3Origin)
         */
        default Builder s3Origin(Consumer<S3Origin.Builder> s3Origin) {
            return s3Origin(S3Origin.builder().applyMutation(s3Origin).build());
        }

        /**
         * <p>
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming
         * distribution.
         * </p>
         * 
         * @param aliases
         *        A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         *        streaming distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(Aliases aliases);

        /**
         * <p>
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming
         * distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link Aliases.Builder} avoiding the need to create one
         * manually via {@link Aliases#builder()}.
         *
         * When the {@link Consumer} completes, {@link Aliases.Builder#build()} is called immediately and its result is
         * passed to {@link #aliases(Aliases)}.
         * 
         * @param aliases
         *        a consumer that will call methods on {@link Aliases.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aliases(Aliases)
         */
        default Builder aliases(Consumer<Aliases.Builder> aliases) {
            return aliases(Aliases.builder().applyMutation(aliases).build());
        }

        /**
         * <p>
         * A complex type that specifies the AWS accounts, if any, that you want to allow to create signed URLs for
         * private content. If you want to require signed URLs in requests for objects in the target origin that match
         * the <code>PathPattern</code> for this cache behavior, specify <code>true</code> for <code>Enabled</code>, and
         * specify the applicable values for <code>Quantity</code> and <code>Items</code>.If you don't want to require
         * signed URLs in requests for objects that match <code>PathPattern</code>, specify <code>false</code> for
         * <code>Enabled</code> and <code>0</code> for <code>Quantity</code>. Omit <code>Items</code>. To add, change,
         * or remove one or more trusted signers, change <code>Enabled</code> to <code>true</code> (if it's currently
         * <code>false</code>), change <code>Quantity</code> as applicable, and specify all of the trusted signers that
         * you want to include in the updated distribution.
         * </p>
         * 
         * @param trustedSigners
         *        A complex type that specifies the AWS accounts, if any, that you want to allow to create signed URLs
         *        for private content. If you want to require signed URLs in requests for objects in the target origin
         *        that match the <code>PathPattern</code> for this cache behavior, specify <code>true</code> for
         *        <code>Enabled</code>, and specify the applicable values for <code>Quantity</code> and
         *        <code>Items</code>.If you don't want to require signed URLs in requests for objects that match
         *        <code>PathPattern</code>, specify <code>false</code> for <code>Enabled</code> and <code>0</code> for
         *        <code>Quantity</code>. Omit <code>Items</code>. To add, change, or remove one or more trusted signers,
         *        change <code>Enabled</code> to <code>true</code> (if it's currently <code>false</code>), change
         *        <code>Quantity</code> as applicable, and specify all of the trusted signers that you want to include
         *        in the updated distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedSigners(TrustedSigners trustedSigners);

        /**
         * <p>
         * A complex type that specifies the AWS accounts, if any, that you want to allow to create signed URLs for
         * private content. If you want to require signed URLs in requests for objects in the target origin that match
         * the <code>PathPattern</code> for this cache behavior, specify <code>true</code> for <code>Enabled</code>, and
         * specify the applicable values for <code>Quantity</code> and <code>Items</code>.If you don't want to require
         * signed URLs in requests for objects that match <code>PathPattern</code>, specify <code>false</code> for
         * <code>Enabled</code> and <code>0</code> for <code>Quantity</code>. Omit <code>Items</code>. To add, change,
         * or remove one or more trusted signers, change <code>Enabled</code> to <code>true</code> (if it's currently
         * <code>false</code>), change <code>Quantity</code> as applicable, and specify all of the trusted signers that
         * you want to include in the updated distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link TrustedSigners.Builder} avoiding the need to
         * create one manually via {@link TrustedSigners#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrustedSigners.Builder#build()} is called immediately and its
         * result is passed to {@link #trustedSigners(TrustedSigners)}.
         * 
         * @param trustedSigners
         *        a consumer that will call methods on {@link TrustedSigners.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustedSigners(TrustedSigners)
         */
        default Builder trustedSigners(Consumer<TrustedSigners.Builder> trustedSigners) {
            return trustedSigners(TrustedSigners.builder().applyMutation(trustedSigners).build());
        }

        /**
         * <p>
         * The comment originally specified when this distribution was created.
         * </p>
         * 
         * @param comment
         *        The comment originally specified when this distribution was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * Sets the value of the PriceClass property for this object.
         *
         * @param priceClass
         *        The new value for the PriceClass property for this object.
         * @see PriceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(String priceClass);

        /**
         * Sets the value of the PriceClass property for this object.
         *
         * @param priceClass
         *        The new value for the PriceClass property for this object.
         * @see PriceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(PriceClass priceClass);

        /**
         * <p>
         * Whether the distribution is enabled to accept end user requests for content.
         * </p>
         * 
         * @param enabled
         *        Whether the distribution is enabled to accept end user requests for content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String status;

        private Instant lastModifiedTime;

        private String domainName;

        private S3Origin s3Origin;

        private Aliases aliases;

        private TrustedSigners trustedSigners;

        private String comment;

        private String priceClass;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingDistributionSummary model) {
            id(model.id);
            arn(model.arn);
            status(model.status);
            lastModifiedTime(model.lastModifiedTime);
            domainName(model.domainName);
            s3Origin(model.s3Origin);
            aliases(model.aliases);
            trustedSigners(model.trustedSigners);
            comment(model.comment);
            priceClass(model.priceClass);
            enabled(model.enabled);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getARN() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final S3Origin.Builder getS3Origin() {
            return s3Origin != null ? s3Origin.toBuilder() : null;
        }

        @Override
        public final Builder s3Origin(S3Origin s3Origin) {
            this.s3Origin = s3Origin;
            return this;
        }

        public final void setS3Origin(S3Origin.BuilderImpl s3Origin) {
            this.s3Origin = s3Origin != null ? s3Origin.build() : null;
        }

        public final Aliases.Builder getAliases() {
            return aliases != null ? aliases.toBuilder() : null;
        }

        @Override
        public final Builder aliases(Aliases aliases) {
            this.aliases = aliases;
            return this;
        }

        public final void setAliases(Aliases.BuilderImpl aliases) {
            this.aliases = aliases != null ? aliases.build() : null;
        }

        public final TrustedSigners.Builder getTrustedSigners() {
            return trustedSigners != null ? trustedSigners.toBuilder() : null;
        }

        @Override
        public final Builder trustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
            return this;
        }

        public final void setTrustedSigners(TrustedSigners.BuilderImpl trustedSigners) {
            this.trustedSigners = trustedSigners != null ? trustedSigners.build() : null;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final String getPriceClass() {
            return priceClass;
        }

        @Override
        public final Builder priceClass(String priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        @Override
        public final Builder priceClass(PriceClass priceClass) {
            this.priceClass(priceClass.toString());
            return this;
        }

        public final void setPriceClass(String priceClass) {
            this.priceClass = priceClass;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public StreamingDistributionSummary build() {
            return new StreamingDistributionSummary(this);
        }
    }
}
