/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDistributionsResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListDistributionsResponse.Builder, ListDistributionsResponse> {
    private final DistributionList distributionList;

    private ListDistributionsResponse(BuilderImpl builder) {
        super(builder);
        this.distributionList = builder.distributionList;
    }

    /**
     * <p>
     * The <code>DistributionList</code> type.
     * </p>
     * 
     * @return The <code>DistributionList</code> type.
     */
    public DistributionList distributionList() {
        return distributionList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(distributionList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionsResponse)) {
            return false;
        }
        ListDistributionsResponse other = (ListDistributionsResponse) obj;
        return Objects.equals(distributionList(), other.distributionList());
    }

    @Override
    public String toString() {
        return ToString.builder("ListDistributionsResponse").add("DistributionList", distributionList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistributionList":
            return Optional.ofNullable(clazz.cast(distributionList()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFrontResponse.Builder, CopyableBuilder<Builder, ListDistributionsResponse> {
        /**
         * <p>
         * The <code>DistributionList</code> type.
         * </p>
         * 
         * @param distributionList
         *        The <code>DistributionList</code> type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionList(DistributionList distributionList);

        /**
         * <p>
         * The <code>DistributionList</code> type.
         * </p>
         * This is a convenience that creates an instance of the {@link DistributionList.Builder} avoiding the need to
         * create one manually via {@link DistributionList#builder()}.
         *
         * When the {@link Consumer} completes, {@link DistributionList.Builder#build()} is called immediately and its
         * result is passed to {@link #distributionList(DistributionList)}.
         * 
         * @param distributionList
         *        a consumer that will call methods on {@link DistributionList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distributionList(DistributionList)
         */
        default Builder distributionList(Consumer<DistributionList.Builder> distributionList) {
            return distributionList(DistributionList.builder().applyMutation(distributionList).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private DistributionList distributionList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionsResponse model) {
            super(model);
            distributionList(model.distributionList);
        }

        public final DistributionList.Builder getDistributionList() {
            return distributionList != null ? distributionList.toBuilder() : null;
        }

        @Override
        public final Builder distributionList(DistributionList distributionList) {
            this.distributionList = distributionList;
            return this;
        }

        public final void setDistributionList(DistributionList.BuilderImpl distributionList) {
            this.distributionList = distributionList != null ? distributionList.build() : null;
        }

        @Override
        public ListDistributionsResponse build() {
            return new ListDistributionsResponse(this);
        }
    }
}
