/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCloudFrontOriginAccessIdentityConfigResponse extends CloudFrontResponse
        implements
        ToCopyableBuilder<GetCloudFrontOriginAccessIdentityConfigResponse.Builder, GetCloudFrontOriginAccessIdentityConfigResponse> {
    private final CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

    private final String eTag;

    private GetCloudFrontOriginAccessIdentityConfigResponse(BuilderImpl builder) {
        super(builder);
        this.cloudFrontOriginAccessIdentityConfig = builder.cloudFrontOriginAccessIdentityConfig;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The origin access identity's configuration information.
     * </p>
     * 
     * @return The origin access identity's configuration information.
     */
    public CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig() {
        return cloudFrontOriginAccessIdentityConfig;
    }

    /**
     * <p>
     * The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.
     */
    public String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudFrontOriginAccessIdentityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCloudFrontOriginAccessIdentityConfigResponse)) {
            return false;
        }
        GetCloudFrontOriginAccessIdentityConfigResponse other = (GetCloudFrontOriginAccessIdentityConfigResponse) obj;
        return Objects.equals(cloudFrontOriginAccessIdentityConfig(), other.cloudFrontOriginAccessIdentityConfig())
                && Objects.equals(eTag(), other.eTag());
    }

    @Override
    public String toString() {
        return ToString.builder("GetCloudFrontOriginAccessIdentityConfigResponse")
                .add("CloudFrontOriginAccessIdentityConfig", cloudFrontOriginAccessIdentityConfig()).add("ETag", eTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudFrontOriginAccessIdentityConfig":
            return Optional.ofNullable(clazz.cast(cloudFrontOriginAccessIdentityConfig()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFrontResponse.Builder,
            CopyableBuilder<Builder, GetCloudFrontOriginAccessIdentityConfigResponse> {
        /**
         * <p>
         * The origin access identity's configuration information.
         * </p>
         * 
         * @param cloudFrontOriginAccessIdentityConfig
         *        The origin access identity's configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig);

        /**
         * <p>
         * The origin access identity's configuration information.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudFrontOriginAccessIdentityConfig.Builder}
         * avoiding the need to create one manually via {@link CloudFrontOriginAccessIdentityConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudFrontOriginAccessIdentityConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig)}.
         * 
         * @param cloudFrontOriginAccessIdentityConfig
         *        a consumer that will call methods on {@link CloudFrontOriginAccessIdentityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig)
         */
        default Builder cloudFrontOriginAccessIdentityConfig(
                Consumer<CloudFrontOriginAccessIdentityConfig.Builder> cloudFrontOriginAccessIdentityConfig) {
            return cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig.builder()
                    .applyMutation(cloudFrontOriginAccessIdentityConfig).build());
        }

        /**
         * <p>
         * The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param eTag
         *        The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCloudFrontOriginAccessIdentityConfigResponse model) {
            super(model);
            cloudFrontOriginAccessIdentityConfig(model.cloudFrontOriginAccessIdentityConfig);
            eTag(model.eTag);
        }

        public final CloudFrontOriginAccessIdentityConfig.Builder getCloudFrontOriginAccessIdentityConfig() {
            return cloudFrontOriginAccessIdentityConfig != null ? cloudFrontOriginAccessIdentityConfig.toBuilder() : null;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentityConfig(
                CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig;
            return this;
        }

        public final void setCloudFrontOriginAccessIdentityConfig(
                CloudFrontOriginAccessIdentityConfig.BuilderImpl cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig != null ? cloudFrontOriginAccessIdentityConfig
                    .build() : null;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public GetCloudFrontOriginAccessIdentityConfigResponse build() {
            return new GetCloudFrontOriginAccessIdentityConfigResponse(this);
        }
    }
}
