/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A distribution list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DistributionList implements ToCopyableBuilder<DistributionList.Builder, DistributionList> {
    private final String marker;

    private final String nextMarker;

    private final Integer maxItems;

    private final Boolean isTruncated;

    private final Integer quantity;

    private final List<DistributionSummary> items;

    private DistributionList(BuilderImpl builder) {
        this.marker = builder.marker;
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
        this.isTruncated = builder.isTruncated;
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * The value you provided for the <code>Marker</code> request parameter.
     * </p>
     * 
     * @return The value you provided for the <code>Marker</code> request parameter.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value you can use for
     * the <code>Marker</code> request parameter to continue listing your distributions where they left off.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value you can
     *         use for the <code>Marker</code> request parameter to continue listing your distributions where they left
     *         off.
     */
    public String nextMarker() {
        return nextMarker;
    }

    /**
     * <p>
     * The value you provided for the <code>MaxItems</code> request parameter.
     * </p>
     * 
     * @return The value you provided for the <code>MaxItems</code> request parameter.
     */
    public Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * A flag that indicates whether more distributions remain to be listed. If your results were truncated, you can
     * make a follow-up pagination request using the <code>Marker</code> request parameter to retrieve more
     * distributions in the list.
     * </p>
     * 
     * @return A flag that indicates whether more distributions remain to be listed. If your results were truncated, you
     *         can make a follow-up pagination request using the <code>Marker</code> request parameter to retrieve more
     *         distributions in the list.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * The number of distributions that were created by the current AWS account.
     * </p>
     * 
     * @return The number of distributions that were created by the current AWS account.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * A complex type that contains one <code>DistributionSummary</code> element for each distribution that was created
     * by the current AWS account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains one <code>DistributionSummary</code> element for each distribution that was
     *         created by the current AWS account.
     */
    public List<DistributionSummary> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(items());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionList)) {
            return false;
        }
        DistributionList other = (DistributionList) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(nextMarker(), other.nextMarker())
                && Objects.equals(maxItems(), other.maxItems()) && Objects.equals(isTruncated(), other.isTruncated())
                && Objects.equals(quantity(), other.quantity()) && Objects.equals(items(), other.items());
    }

    @Override
    public String toString() {
        return ToString.builder("DistributionList").add("Marker", marker()).add("NextMarker", nextMarker())
                .add("MaxItems", maxItems()).add("IsTruncated", isTruncated()).add("Quantity", quantity()).add("Items", items())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DistributionList> {
        /**
         * <p>
         * The value you provided for the <code>Marker</code> request parameter.
         * </p>
         * 
         * @param marker
         *        The value you provided for the <code>Marker</code> request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value you can use
         * for the <code>Marker</code> request parameter to continue listing your distributions where they left off.
         * </p>
         * 
         * @param nextMarker
         *        If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value you
         *        can use for the <code>Marker</code> request parameter to continue listing your distributions where
         *        they left off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The value you provided for the <code>MaxItems</code> request parameter.
         * </p>
         * 
         * @param maxItems
         *        The value you provided for the <code>MaxItems</code> request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * A flag that indicates whether more distributions remain to be listed. If your results were truncated, you can
         * make a follow-up pagination request using the <code>Marker</code> request parameter to retrieve more
         * distributions in the list.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether more distributions remain to be listed. If your results were truncated,
         *        you can make a follow-up pagination request using the <code>Marker</code> request parameter to
         *        retrieve more distributions in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * The number of distributions that were created by the current AWS account.
         * </p>
         * 
         * @param quantity
         *        The number of distributions that were created by the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * A complex type that contains one <code>DistributionSummary</code> element for each distribution that was
         * created by the current AWS account.
         * </p>
         * 
         * @param items
         *        A complex type that contains one <code>DistributionSummary</code> element for each distribution that
         *        was created by the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<DistributionSummary> items);

        /**
         * <p>
         * A complex type that contains one <code>DistributionSummary</code> element for each distribution that was
         * created by the current AWS account.
         * </p>
         * 
         * @param items
         *        A complex type that contains one <code>DistributionSummary</code> element for each distribution that
         *        was created by the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(DistributionSummary... items);

        /**
         * <p>
         * A complex type that contains one <code>DistributionSummary</code> element for each distribution that was
         * created by the current AWS account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DistributionSummary>.Builder} avoiding the
         * need to create one manually via {@link List<DistributionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DistributionSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #items(List<DistributionSummary>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<DistributionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<DistributionSummary>)
         */
        Builder items(Consumer<DistributionSummary.Builder>... items);
    }

    static final class BuilderImpl implements Builder {
        private String marker;

        private String nextMarker;

        private Integer maxItems;

        private Boolean isTruncated;

        private Integer quantity;

        private List<DistributionSummary> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionList model) {
            marker(model.marker);
            nextMarker(model.nextMarker);
            maxItems(model.maxItems);
            isTruncated(model.isTruncated);
            quantity(model.quantity);
            items(model.items);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<DistributionSummary.Builder> getItems() {
            return items != null ? items.stream().map(DistributionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<DistributionSummary> items) {
            this.items = DistributionSummaryListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(DistributionSummary... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<DistributionSummary.Builder>... items) {
            items(Stream.of(items).map(c -> DistributionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<DistributionSummary.BuilderImpl> items) {
            this.items = DistributionSummaryListCopier.copyFromBuilder(items);
        }

        @Override
        public DistributionList build() {
            return new DistributionList(this);
        }
    }
}
