/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDistributionWithTagsResponse extends CloudFrontResponse implements
        ToCopyableBuilder<CreateDistributionWithTagsResponse.Builder, CreateDistributionWithTagsResponse> {
    private final Distribution distribution;

    private final String location;

    private final String eTag;

    private CreateDistributionWithTagsResponse(BuilderImpl builder) {
        super(builder);
        this.distribution = builder.distribution;
        this.location = builder.location;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The distribution's information.
     * </p>
     * 
     * @return The distribution's information.
     */
    public Distribution distribution() {
        return distribution;
    }

    /**
     * <p>
     * The fully qualified URI of the new distribution resource just created. For example:
     * <code>https://cloudfront.amazonaws.com/2010-11-01/distribution/EDFDVBD632BHDS5</code>.
     * </p>
     * 
     * @return The fully qualified URI of the new distribution resource just created. For example:
     *         <code>https://cloudfront.amazonaws.com/2010-11-01/distribution/EDFDVBD632BHDS5</code>.
     */
    public String location() {
        return location;
    }

    /**
     * <p>
     * The current version of the distribution created.
     * </p>
     * 
     * @return The current version of the distribution created.
     */
    public String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(distribution());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDistributionWithTagsResponse)) {
            return false;
        }
        CreateDistributionWithTagsResponse other = (CreateDistributionWithTagsResponse) obj;
        return Objects.equals(distribution(), other.distribution()) && Objects.equals(location(), other.location())
                && Objects.equals(eTag(), other.eTag());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateDistributionWithTagsResponse").add("Distribution", distribution())
                .add("Location", location()).add("ETag", eTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Distribution":
            return Optional.ofNullable(clazz.cast(distribution()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFrontResponse.Builder, CopyableBuilder<Builder, CreateDistributionWithTagsResponse> {
        /**
         * <p>
         * The distribution's information.
         * </p>
         * 
         * @param distribution
         *        The distribution's information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distribution(Distribution distribution);

        /**
         * <p>
         * The distribution's information.
         * </p>
         * This is a convenience that creates an instance of the {@link Distribution.Builder} avoiding the need to
         * create one manually via {@link Distribution#builder()}.
         *
         * When the {@link Consumer} completes, {@link Distribution.Builder#build()} is called immediately and its
         * result is passed to {@link #distribution(Distribution)}.
         * 
         * @param distribution
         *        a consumer that will call methods on {@link Distribution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distribution(Distribution)
         */
        default Builder distribution(Consumer<Distribution.Builder> distribution) {
            return distribution(Distribution.builder().applyMutation(distribution).build());
        }

        /**
         * <p>
         * The fully qualified URI of the new distribution resource just created. For example:
         * <code>https://cloudfront.amazonaws.com/2010-11-01/distribution/EDFDVBD632BHDS5</code>.
         * </p>
         * 
         * @param location
         *        The fully qualified URI of the new distribution resource just created. For example:
         *        <code>https://cloudfront.amazonaws.com/2010-11-01/distribution/EDFDVBD632BHDS5</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The current version of the distribution created.
         * </p>
         * 
         * @param eTag
         *        The current version of the distribution created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private Distribution distribution;

        private String location;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDistributionWithTagsResponse model) {
            super(model);
            distribution(model.distribution);
            location(model.location);
            eTag(model.eTag);
        }

        public final Distribution.Builder getDistribution() {
            return distribution != null ? distribution.toBuilder() : null;
        }

        @Override
        public final Builder distribution(Distribution distribution) {
            this.distribution = distribution;
            return this;
        }

        public final void setDistribution(Distribution.BuilderImpl distribution) {
            this.distribution = distribution != null ? distribution.build() : null;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public CreateDistributionWithTagsResponse build() {
            return new CreateDistributionWithTagsResponse(this);
        }
    }
}
