/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * If the <code>CallerReference</code> is a value you already sent in a previous request to create an identity but the
 * content of the <code>CloudFrontOriginAccessIdentityConfig</code> is different from the original request, CloudFront
 * returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudFrontOriginAccessIdentityAlreadyExistsException extends CloudFrontException
        implements
        ToCopyableBuilder<CloudFrontOriginAccessIdentityAlreadyExistsException.Builder, CloudFrontOriginAccessIdentityAlreadyExistsException> {
    private CloudFrontOriginAccessIdentityAlreadyExistsException(BuilderImpl builder) {
        super(builder);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public interface Builder extends CopyableBuilder<Builder, CloudFrontOriginAccessIdentityAlreadyExistsException>,
            CloudFrontException.Builder {
        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends CloudFrontException.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(CloudFrontOriginAccessIdentityAlreadyExistsException model) {
            super(model);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public CloudFrontOriginAccessIdentityAlreadyExistsException build() {
            return new CloudFrontOriginAccessIdentityAlreadyExistsException(this);
        }
    }
}
