/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.transform;

import static java.nio.charset.StandardCharsets.UTF_8;

import java.io.StringWriter;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudfront.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.utils.StringInputStream;
import software.amazon.awssdk.core.util.StringConversion;

import software.amazon.awssdk.core.util.xml.XmlWriter;

/**
 * UpdateCloudFrontOriginAccessIdentityRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateCloudFrontOriginAccessIdentityRequestMarshaller implements
        Marshaller<Request<UpdateCloudFrontOriginAccessIdentityRequest>, UpdateCloudFrontOriginAccessIdentityRequest> {

    public Request<UpdateCloudFrontOriginAccessIdentityRequest> marshall(
            UpdateCloudFrontOriginAccessIdentityRequest updateCloudFrontOriginAccessIdentityRequest) {

        if (updateCloudFrontOriginAccessIdentityRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<UpdateCloudFrontOriginAccessIdentityRequest> request = new DefaultRequest<UpdateCloudFrontOriginAccessIdentityRequest>(
                updateCloudFrontOriginAccessIdentityRequest, "CloudFrontClient");

        request.setHttpMethod(HttpMethodName.PUT);

        if (updateCloudFrontOriginAccessIdentityRequest.ifMatch() != null) {
            request.addHeader("If-Match", StringConversion.fromString(updateCloudFrontOriginAccessIdentityRequest.ifMatch()));
        }

        String uriResourcePath = "/2017-03-25/origin-access-identity/cloudfront/{Id}/config";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Id",
                updateCloudFrontOriginAccessIdentityRequest.id());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = null;
            CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig = updateCloudFrontOriginAccessIdentityRequest
                    .cloudFrontOriginAccessIdentityConfig();
            if (cloudFrontOriginAccessIdentityConfig != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2017-03-25/");
                xmlWriter.startElement("CloudFrontOriginAccessIdentityConfig");

                if (cloudFrontOriginAccessIdentityConfig.callerReference() != null) {
                    xmlWriter.startElement("CallerReference").value(cloudFrontOriginAccessIdentityConfig.callerReference())
                            .endElement();
                }

                if (cloudFrontOriginAccessIdentityConfig.comment() != null) {
                    xmlWriter.startElement("Comment").value(cloudFrontOriginAccessIdentityConfig.comment()).endElement();
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }

        return request;
    }

}