/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudfront.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * StreamingDistributionConfig StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class StreamingDistributionConfigUnmarshaller implements
        Unmarshaller<StreamingDistributionConfig, StaxUnmarshallerContext> {

    public StreamingDistributionConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        StreamingDistributionConfig.Builder streamingDistributionConfig = StreamingDistributionConfig.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("CallerReference", targetDepth)) {
                    streamingDistributionConfig.callerReference(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("S3Origin", targetDepth)) {
                    streamingDistributionConfig.s3Origin(S3OriginUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Aliases", targetDepth)) {
                    streamingDistributionConfig.aliases(AliasesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Comment", targetDepth)) {
                    streamingDistributionConfig.comment(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Logging", targetDepth)) {
                    streamingDistributionConfig.logging(StreamingLoggingConfigUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("TrustedSigners", targetDepth)) {
                    streamingDistributionConfig.trustedSigners(TrustedSignersUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("PriceClass", targetDepth)) {
                    streamingDistributionConfig.priceClass(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Enabled", targetDepth)) {
                    streamingDistributionConfig.enabled(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return streamingDistributionConfig.build();
    }

    private static final StreamingDistributionConfigUnmarshaller INSTANCE = new StreamingDistributionConfigUnmarshaller();

    public static StreamingDistributionConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}
