/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudfront.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

/**
 * GetStreamingDistributionRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetStreamingDistributionRequestMarshaller implements
        Marshaller<Request<GetStreamingDistributionRequest>, GetStreamingDistributionRequest> {

    public Request<GetStreamingDistributionRequest> marshall(GetStreamingDistributionRequest getStreamingDistributionRequest) {

        if (getStreamingDistributionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<GetStreamingDistributionRequest> request = new DefaultRequest<GetStreamingDistributionRequest>(
                getStreamingDistributionRequest, "CloudFrontClient");

        request.setHttpMethod(HttpMethodName.GET);

        String uriResourcePath = "/2017-03-25/streaming-distribution/{Id}";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Id",
                getStreamingDistributionRequest.id());
        request.setResourcePath(uriResourcePath);

        return request;
    }

}