/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that specifies a list of Lambda functions associations for a cache behavior.
 * </p>
 * <p>
 * If you want to invoke one or more Lambda functions triggered by requests that match the <code>PathPattern</code> of
 * the cache behavior, specify the applicable values for <code>Quantity</code> and <code>Items</code>. Note that there
 * can be up to 4 <code>LambdaFunctionAssociation</code> items in this list (one for each possible value of
 * <code>EventType</code>) and each <code>EventType</code> can be associated with the Lambda function only once.
 * </p>
 * <p>
 * If you don't want to invoke any Lambda functions for the requests that match <code>PathPattern</code>, specify
 * <code>0</code> for <code>Quantity</code> and omit <code>Items</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaFunctionAssociations implements
        ToCopyableBuilder<LambdaFunctionAssociations.Builder, LambdaFunctionAssociations> {
    private final Integer quantity;

    private final List<LambdaFunctionAssociation> items;

    private LambdaFunctionAssociations(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * The number of Lambda function associations for this cache behavior.
     * </p>
     * 
     * @return The number of Lambda function associations for this cache behavior.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * <b>Optional</b>: A complex type that contains <code>LambdaFunctionAssociation</code> items for this cache
     * behavior. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return <b>Optional</b>: A complex type that contains <code>LambdaFunctionAssociation</code> items for this cache
     *         behavior. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
     */
    public List<LambdaFunctionAssociation> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(items());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionAssociations)) {
            return false;
        }
        LambdaFunctionAssociations other = (LambdaFunctionAssociations) obj;
        return Objects.equals(quantity(), other.quantity()) && Objects.equals(items(), other.items());
    }

    @Override
    public String toString() {
        return ToString.builder("LambdaFunctionAssociations").add("Quantity", quantity()).add("Items", items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, LambdaFunctionAssociations> {
        /**
         * <p>
         * The number of Lambda function associations for this cache behavior.
         * </p>
         * 
         * @param quantity
         *        The number of Lambda function associations for this cache behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * <b>Optional</b>: A complex type that contains <code>LambdaFunctionAssociation</code> items for this cache
         * behavior. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
         * </p>
         * 
         * @param items
         *        <b>Optional</b>: A complex type that contains <code>LambdaFunctionAssociation</code> items for this
         *        cache behavior. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<LambdaFunctionAssociation> items);

        /**
         * <p>
         * <b>Optional</b>: A complex type that contains <code>LambdaFunctionAssociation</code> items for this cache
         * behavior. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
         * </p>
         * 
         * @param items
         *        <b>Optional</b>: A complex type that contains <code>LambdaFunctionAssociation</code> items for this
         *        cache behavior. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(LambdaFunctionAssociation... items);

        /**
         * <p>
         * <b>Optional</b>: A complex type that contains <code>LambdaFunctionAssociation</code> items for this cache
         * behavior. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LambdaFunctionAssociation>.Builder}
         * avoiding the need to create one manually via {@link List<LambdaFunctionAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LambdaFunctionAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link #items(List<LambdaFunctionAssociation>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<LambdaFunctionAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<LambdaFunctionAssociation>)
         */
        Builder items(Consumer<LambdaFunctionAssociation.Builder>... items);
    }

    static final class BuilderImpl implements Builder {
        private Integer quantity;

        private List<LambdaFunctionAssociation> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionAssociations model) {
            quantity(model.quantity);
            items(model.items);
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<LambdaFunctionAssociation.Builder> getItems() {
            return items != null ? items.stream().map(LambdaFunctionAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<LambdaFunctionAssociation> items) {
            this.items = LambdaFunctionAssociationListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(LambdaFunctionAssociation... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<LambdaFunctionAssociation.Builder>... items) {
            items(Stream.of(items).map(c -> LambdaFunctionAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<LambdaFunctionAssociation.BuilderImpl> items) {
            this.items = LambdaFunctionAssociationListCopier.copyFromBuilder(items);
        }

        @Override
        public LambdaFunctionAssociations build() {
            return new LambdaFunctionAssociations(this);
        }
    }
}
