/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteServiceLinkedRoleRequest extends CloudFrontRequest implements
        ToCopyableBuilder<DeleteServiceLinkedRoleRequest.Builder, DeleteServiceLinkedRoleRequest> {
    private final String roleName;

    private DeleteServiceLinkedRoleRequest(BuilderImpl builder) {
        super(builder);
        this.roleName = builder.roleName;
    }

    /**
     * Returns the value of the RoleName property for this object.
     * 
     * @return The value of the RoleName property for this object.
     */
    public String roleName() {
        return roleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteServiceLinkedRoleRequest)) {
            return false;
        }
        DeleteServiceLinkedRoleRequest other = (DeleteServiceLinkedRoleRequest) obj;
        return Objects.equals(roleName(), other.roleName());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteServiceLinkedRoleRequest").add("RoleName", roleName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFrontRequest.Builder, CopyableBuilder<Builder, DeleteServiceLinkedRoleRequest> {
        /**
         * Sets the value of the RoleName property for this object.
         *
         * @param roleName
         *        The new value for the RoleName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String roleName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteServiceLinkedRoleRequest model) {
            super(model);
            roleName(model.roleName);
        }

        public final String getRoleName() {
            return roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteServiceLinkedRoleRequest build() {
            return new DeleteServiceLinkedRoleRequest(this);
        }
    }
}
