/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to create an invalidation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInvalidationRequest extends CloudFrontRequest implements
        ToCopyableBuilder<CreateInvalidationRequest.Builder, CreateInvalidationRequest> {
    private final String distributionId;

    private final InvalidationBatch invalidationBatch;

    private CreateInvalidationRequest(BuilderImpl builder) {
        super(builder);
        this.distributionId = builder.distributionId;
        this.invalidationBatch = builder.invalidationBatch;
    }

    /**
     * <p>
     * The distribution's id.
     * </p>
     * 
     * @return The distribution's id.
     */
    public String distributionId() {
        return distributionId;
    }

    /**
     * <p>
     * The batch information for the invalidation.
     * </p>
     * 
     * @return The batch information for the invalidation.
     */
    public InvalidationBatch invalidationBatch() {
        return invalidationBatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(distributionId());
        hashCode = 31 * hashCode + Objects.hashCode(invalidationBatch());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInvalidationRequest)) {
            return false;
        }
        CreateInvalidationRequest other = (CreateInvalidationRequest) obj;
        return Objects.equals(distributionId(), other.distributionId())
                && Objects.equals(invalidationBatch(), other.invalidationBatch());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateInvalidationRequest").add("DistributionId", distributionId())
                .add("InvalidationBatch", invalidationBatch()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistributionId":
            return Optional.ofNullable(clazz.cast(distributionId()));
        case "InvalidationBatch":
            return Optional.ofNullable(clazz.cast(invalidationBatch()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFrontRequest.Builder, CopyableBuilder<Builder, CreateInvalidationRequest> {
        /**
         * <p>
         * The distribution's id.
         * </p>
         * 
         * @param distributionId
         *        The distribution's id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionId(String distributionId);

        /**
         * <p>
         * The batch information for the invalidation.
         * </p>
         * 
         * @param invalidationBatch
         *        The batch information for the invalidation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidationBatch(InvalidationBatch invalidationBatch);

        /**
         * <p>
         * The batch information for the invalidation.
         * </p>
         * This is a convenience that creates an instance of the {@link InvalidationBatch.Builder} avoiding the need to
         * create one manually via {@link InvalidationBatch#builder()}.
         *
         * When the {@link Consumer} completes, {@link InvalidationBatch.Builder#build()} is called immediately and its
         * result is passed to {@link #invalidationBatch(InvalidationBatch)}.
         * 
         * @param invalidationBatch
         *        a consumer that will call methods on {@link InvalidationBatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invalidationBatch(InvalidationBatch)
         */
        default Builder invalidationBatch(Consumer<InvalidationBatch.Builder> invalidationBatch) {
            return invalidationBatch(InvalidationBatch.builder().applyMutation(invalidationBatch).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String distributionId;

        private InvalidationBatch invalidationBatch;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInvalidationRequest model) {
            super(model);
            distributionId(model.distributionId);
            invalidationBatch(model.invalidationBatch);
        }

        public final String getDistributionId() {
            return distributionId;
        }

        @Override
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        public final InvalidationBatch.Builder getInvalidationBatch() {
            return invalidationBatch != null ? invalidationBatch.toBuilder() : null;
        }

        @Override
        public final Builder invalidationBatch(InvalidationBatch invalidationBatch) {
            this.invalidationBatch = invalidationBatch;
            return this;
        }

        public final void setInvalidationBatch(InvalidationBatch.BuilderImpl invalidationBatch) {
            this.invalidationBatch = invalidationBatch != null ? invalidationBatch.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInvalidationRequest build() {
            return new CreateInvalidationRequest(this);
        }
    }
}
