/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudfront.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * CustomOriginConfig StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CustomOriginConfigUnmarshaller implements Unmarshaller<CustomOriginConfig, StaxUnmarshallerContext> {

    public CustomOriginConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        CustomOriginConfig.Builder customOriginConfig = CustomOriginConfig.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("HTTPPort", targetDepth)) {
                    customOriginConfig.httpPort(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("HTTPSPort", targetDepth)) {
                    customOriginConfig.httpsPort(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("OriginProtocolPolicy", targetDepth)) {
                    customOriginConfig.originProtocolPolicy(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("OriginSslProtocols", targetDepth)) {
                    customOriginConfig.originSslProtocols(OriginSslProtocolsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("OriginReadTimeout", targetDepth)) {
                    customOriginConfig.originReadTimeout(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("OriginKeepaliveTimeout", targetDepth)) {
                    customOriginConfig.originKeepaliveTimeout(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return customOriginConfig.build();
    }

    private static final CustomOriginConfigUnmarshaller INSTANCE = new CustomOriginConfigUnmarshaller();

    public static CustomOriginConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}
