/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to update a distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDistributionRequest extends CloudFrontRequest implements
        ToCopyableBuilder<UpdateDistributionRequest.Builder, UpdateDistributionRequest> {
    private final DistributionConfig distributionConfig;

    private final String id;

    private final String ifMatch;

    private UpdateDistributionRequest(BuilderImpl builder) {
        super(builder);
        this.distributionConfig = builder.distributionConfig;
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
    }

    /**
     * <p>
     * The distribution's configuration information.
     * </p>
     * 
     * @return The distribution's configuration information.
     */
    public DistributionConfig distributionConfig() {
        return distributionConfig;
    }

    /**
     * <p>
     * The distribution's id.
     * </p>
     * 
     * @return The distribution's id.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The value of the <code>ETag</code> header that you received when retrieving the distribution's configuration. For
     * example: <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The value of the <code>ETag</code> header that you received when retrieving the distribution's
     *         configuration. For example: <code>E2QWRUHAPOMQZL</code>.
     */
    public String ifMatch() {
        return ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(distributionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDistributionRequest)) {
            return false;
        }
        UpdateDistributionRequest other = (UpdateDistributionRequest) obj;
        return Objects.equals(distributionConfig(), other.distributionConfig()) && Objects.equals(id(), other.id())
                && Objects.equals(ifMatch(), other.ifMatch());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateDistributionRequest").add("DistributionConfig", distributionConfig()).add("Id", id())
                .add("IfMatch", ifMatch()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistributionConfig":
            return Optional.of(clazz.cast(distributionConfig()));
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "IfMatch":
            return Optional.of(clazz.cast(ifMatch()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFrontRequest.Builder, CopyableBuilder<Builder, UpdateDistributionRequest> {
        /**
         * <p>
         * The distribution's configuration information.
         * </p>
         * 
         * @param distributionConfig
         *        The distribution's configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionConfig(DistributionConfig distributionConfig);

        /**
         * <p>
         * The distribution's configuration information.
         * </p>
         * This is a convenience that creates an instance of the {@link DistributionConfig.Builder} avoiding the need to
         * create one manually via {@link DistributionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DistributionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #distributionConfig(DistributionConfig)}.
         * 
         * @param distributionConfig
         *        a consumer that will call methods on {@link DistributionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distributionConfig(DistributionConfig)
         */
        default Builder distributionConfig(Consumer<DistributionConfig.Builder> distributionConfig) {
            return distributionConfig(DistributionConfig.builder().apply(distributionConfig).build());
        }

        /**
         * <p>
         * The distribution's id.
         * </p>
         * 
         * @param id
         *        The distribution's id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The value of the <code>ETag</code> header that you received when retrieving the distribution's configuration.
         * For example: <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param ifMatch
         *        The value of the <code>ETag</code> header that you received when retrieving the distribution's
         *        configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private DistributionConfig distributionConfig;

        private String id;

        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDistributionRequest model) {
            super(model);
            distributionConfig(model.distributionConfig);
            id(model.id);
            ifMatch(model.ifMatch);
        }

        public final DistributionConfig.Builder getDistributionConfig() {
            return distributionConfig != null ? distributionConfig.toBuilder() : null;
        }

        @Override
        public final Builder distributionConfig(DistributionConfig distributionConfig) {
            this.distributionConfig = distributionConfig;
            return this;
        }

        public final void setDistributionConfig(DistributionConfig.BuilderImpl distributionConfig) {
            this.distributionConfig = distributionConfig != null ? distributionConfig.build() : null;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateDistributionRequest build() {
            return new UpdateDistributionRequest(this);
        }
    }
}
