/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to remove tags from a CloudFront resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UntagResourceRequest extends CloudFrontRequest implements
        ToCopyableBuilder<UntagResourceRequest.Builder, UntagResourceRequest> {
    private final String resource;

    private final TagKeys tagKeys;

    private UntagResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resource = builder.resource;
        this.tagKeys = builder.tagKeys;
    }

    /**
     * <p>
     * An ARN of a CloudFront resource.
     * </p>
     * 
     * @return An ARN of a CloudFront resource.
     */
    public String resource() {
        return resource;
    }

    /**
     * <p>
     * A complex type that contains zero or more <code>Tag</code> key elements.
     * </p>
     * 
     * @return A complex type that contains zero or more <code>Tag</code> key elements.
     */
    public TagKeys tagKeys() {
        return tagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(tagKeys());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagResourceRequest)) {
            return false;
        }
        UntagResourceRequest other = (UntagResourceRequest) obj;
        return Objects.equals(resource(), other.resource()) && Objects.equals(tagKeys(), other.tagKeys());
    }

    @Override
    public String toString() {
        return ToString.builder("UntagResourceRequest").add("Resource", resource()).add("TagKeys", tagKeys()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Resource":
            return Optional.of(clazz.cast(resource()));
        case "TagKeys":
            return Optional.of(clazz.cast(tagKeys()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFrontRequest.Builder, CopyableBuilder<Builder, UntagResourceRequest> {
        /**
         * <p>
         * An ARN of a CloudFront resource.
         * </p>
         * 
         * @param resource
         *        An ARN of a CloudFront resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * A complex type that contains zero or more <code>Tag</code> key elements.
         * </p>
         * 
         * @param tagKeys
         *        A complex type that contains zero or more <code>Tag</code> key elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(TagKeys tagKeys);

        /**
         * <p>
         * A complex type that contains zero or more <code>Tag</code> key elements.
         * </p>
         * This is a convenience that creates an instance of the {@link TagKeys.Builder} avoiding the need to create one
         * manually via {@link TagKeys#builder()}.
         *
         * When the {@link Consumer} completes, {@link TagKeys.Builder#build()} is called immediately and its result is
         * passed to {@link #tagKeys(TagKeys)}.
         * 
         * @param tagKeys
         *        a consumer that will call methods on {@link TagKeys.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagKeys(TagKeys)
         */
        default Builder tagKeys(Consumer<TagKeys.Builder> tagKeys) {
            return tagKeys(TagKeys.builder().apply(tagKeys).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String resource;

        private TagKeys tagKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(UntagResourceRequest model) {
            super(model);
            resource(model.resource);
            tagKeys(model.tagKeys);
        }

        public final String getResource() {
            return resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final TagKeys.Builder getTagKeys() {
            return tagKeys != null ? tagKeys.toBuilder() : null;
        }

        @Override
        public final Builder tagKeys(TagKeys tagKeys) {
            this.tagKeys = tagKeys;
            return this;
        }

        public final void setTagKeys(TagKeys.BuilderImpl tagKeys) {
            this.tagKeys = tagKeys != null ? tagKeys.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UntagResourceRequest build() {
            return new UntagResourceRequest(this);
        }
    }
}
