/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A streaming distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StreamingDistribution implements ToCopyableBuilder<StreamingDistribution.Builder, StreamingDistribution> {
    private final String id;

    private final String arn;

    private final String status;

    private final Instant lastModifiedTime;

    private final String domainName;

    private final ActiveTrustedSigners activeTrustedSigners;

    private final StreamingDistributionConfig streamingDistributionConfig;

    private StreamingDistribution(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.domainName = builder.domainName;
        this.activeTrustedSigners = builder.activeTrustedSigners;
        this.streamingDistributionConfig = builder.streamingDistributionConfig;
    }

    /**
     * <p>
     * The identifier for the RTMP distribution. For example: <code>EGTXBD79EXAMPLE</code>.
     * </p>
     * 
     * @return The identifier for the RTMP distribution. For example: <code>EGTXBD79EXAMPLE</code>.
     */
    public String id() {
        return id;
    }

    /**
     * Returns the value of the ARN property for this object.
     * 
     * @return The value of the ARN property for this object.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The current status of the RTMP distribution. When the status is <code>Deployed</code>, the distribution's
     * information is propagated to all CloudFront edge locations.
     * </p>
     * 
     * @return The current status of the RTMP distribution. When the status is <code>Deployed</code>, the distribution's
     *         information is propagated to all CloudFront edge locations.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The date and time that the distribution was last modified.
     * </p>
     * 
     * @return The date and time that the distribution was last modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The domain name that corresponds to the streaming distribution, for example,
     * <code>s5c39gqb8ow64r.cloudfront.net</code>.
     * </p>
     * 
     * @return The domain name that corresponds to the streaming distribution, for example,
     *         <code>s5c39gqb8ow64r.cloudfront.net</code>.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * A complex type that lists the AWS accounts, if any, that you included in the <code>TrustedSigners</code> complex
     * type for this distribution. These are the accounts that you want to allow to create signed URLs for private
     * content.
     * </p>
     * <p>
     * The <code>Signer</code> complex type lists the AWS account number of the trusted signer or <code>self</code> if
     * the signer is the AWS account that created the distribution. The <code>Signer</code> element also includes the
     * IDs of any active CloudFront key pairs that are associated with the trusted signer's AWS account. If no
     * <code>KeyPairId</code> element appears for a <code>Signer</code>, that signer can't create signed URLs.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return A complex type that lists the AWS accounts, if any, that you included in the <code>TrustedSigners</code>
     *         complex type for this distribution. These are the accounts that you want to allow to create signed URLs
     *         for private content.</p>
     *         <p>
     *         The <code>Signer</code> complex type lists the AWS account number of the trusted signer or
     *         <code>self</code> if the signer is the AWS account that created the distribution. The <code>Signer</code>
     *         element also includes the IDs of any active CloudFront key pairs that are associated with the trusted
     *         signer's AWS account. If no <code>KeyPairId</code> element appears for a <code>Signer</code>, that signer
     *         can't create signed URLs.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
     *         Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public ActiveTrustedSigners activeTrustedSigners() {
        return activeTrustedSigners;
    }

    /**
     * <p>
     * The current configuration information for the RTMP distribution.
     * </p>
     * 
     * @return The current configuration information for the RTMP distribution.
     */
    public StreamingDistributionConfig streamingDistributionConfig() {
        return streamingDistributionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(activeTrustedSigners());
        hashCode = 31 * hashCode + Objects.hashCode(streamingDistributionConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingDistribution)) {
            return false;
        }
        StreamingDistribution other = (StreamingDistribution) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(status(), other.status())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(domainName(), other.domainName())
                && Objects.equals(activeTrustedSigners(), other.activeTrustedSigners())
                && Objects.equals(streamingDistributionConfig(), other.streamingDistributionConfig());
    }

    @Override
    public String toString() {
        return ToString.builder("StreamingDistribution").add("Id", id()).add("ARN", arn()).add("Status", status())
                .add("LastModifiedTime", lastModifiedTime()).add("DomainName", domainName())
                .add("ActiveTrustedSigners", activeTrustedSigners())
                .add("StreamingDistributionConfig", streamingDistributionConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "ARN":
            return Optional.of(clazz.cast(arn()));
        case "Status":
            return Optional.of(clazz.cast(status()));
        case "LastModifiedTime":
            return Optional.of(clazz.cast(lastModifiedTime()));
        case "DomainName":
            return Optional.of(clazz.cast(domainName()));
        case "ActiveTrustedSigners":
            return Optional.of(clazz.cast(activeTrustedSigners()));
        case "StreamingDistributionConfig":
            return Optional.of(clazz.cast(streamingDistributionConfig()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, StreamingDistribution> {
        /**
         * <p>
         * The identifier for the RTMP distribution. For example: <code>EGTXBD79EXAMPLE</code>.
         * </p>
         * 
         * @param id
         *        The identifier for the RTMP distribution. For example: <code>EGTXBD79EXAMPLE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the ARN property for this object.
         *
         * @param arn
         *        The new value for the ARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The current status of the RTMP distribution. When the status is <code>Deployed</code>, the distribution's
         * information is propagated to all CloudFront edge locations.
         * </p>
         * 
         * @param status
         *        The current status of the RTMP distribution. When the status is <code>Deployed</code>, the
         *        distribution's information is propagated to all CloudFront edge locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time that the distribution was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time that the distribution was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The domain name that corresponds to the streaming distribution, for example,
         * <code>s5c39gqb8ow64r.cloudfront.net</code>.
         * </p>
         * 
         * @param domainName
         *        The domain name that corresponds to the streaming distribution, for example,
         *        <code>s5c39gqb8ow64r.cloudfront.net</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A complex type that lists the AWS accounts, if any, that you included in the <code>TrustedSigners</code>
         * complex type for this distribution. These are the accounts that you want to allow to create signed URLs for
         * private content.
         * </p>
         * <p>
         * The <code>Signer</code> complex type lists the AWS account number of the trusted signer or <code>self</code>
         * if the signer is the AWS account that created the distribution. The <code>Signer</code> element also includes
         * the IDs of any active CloudFront key pairs that are associated with the trusted signer's AWS account. If no
         * <code>KeyPairId</code> element appears for a <code>Signer</code>, that signer can't create signed URLs.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param activeTrustedSigners
         *        A complex type that lists the AWS accounts, if any, that you included in the
         *        <code>TrustedSigners</code> complex type for this distribution. These are the accounts that you want
         *        to allow to create signed URLs for private content.</p>
         *        <p>
         *        The <code>Signer</code> complex type lists the AWS account number of the trusted signer or
         *        <code>self</code> if the signer is the AWS account that created the distribution. The
         *        <code>Signer</code> element also includes the IDs of any active CloudFront key pairs that are
         *        associated with the trusted signer's AWS account. If no <code>KeyPairId</code> element appears for a
         *        <code>Signer</code>, that signer can't create signed URLs.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
         *        Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeTrustedSigners(ActiveTrustedSigners activeTrustedSigners);

        /**
         * <p>
         * A complex type that lists the AWS accounts, if any, that you included in the <code>TrustedSigners</code>
         * complex type for this distribution. These are the accounts that you want to allow to create signed URLs for
         * private content.
         * </p>
         * <p>
         * The <code>Signer</code> complex type lists the AWS account number of the trusted signer or <code>self</code>
         * if the signer is the AWS account that created the distribution. The <code>Signer</code> element also includes
         * the IDs of any active CloudFront key pairs that are associated with the trusted signer's AWS account. If no
         * <code>KeyPairId</code> element appears for a <code>Signer</code>, that signer can't create signed URLs.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link ActiveTrustedSigners.Builder} avoiding the need
         * to create one manually via {@link ActiveTrustedSigners#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActiveTrustedSigners.Builder#build()} is called immediately and
         * its result is passed to {@link #activeTrustedSigners(ActiveTrustedSigners)}.
         * 
         * @param activeTrustedSigners
         *        a consumer that will call methods on {@link ActiveTrustedSigners.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeTrustedSigners(ActiveTrustedSigners)
         */
        default Builder activeTrustedSigners(Consumer<ActiveTrustedSigners.Builder> activeTrustedSigners) {
            return activeTrustedSigners(ActiveTrustedSigners.builder().apply(activeTrustedSigners).build());
        }

        /**
         * <p>
         * The current configuration information for the RTMP distribution.
         * </p>
         * 
         * @param streamingDistributionConfig
         *        The current configuration information for the RTMP distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig);

        /**
         * <p>
         * The current configuration information for the RTMP distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamingDistributionConfig.Builder} avoiding
         * the need to create one manually via {@link StreamingDistributionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamingDistributionConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #streamingDistributionConfig(StreamingDistributionConfig)}.
         * 
         * @param streamingDistributionConfig
         *        a consumer that will call methods on {@link StreamingDistributionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingDistributionConfig(StreamingDistributionConfig)
         */
        default Builder streamingDistributionConfig(Consumer<StreamingDistributionConfig.Builder> streamingDistributionConfig) {
            return streamingDistributionConfig(StreamingDistributionConfig.builder().apply(streamingDistributionConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String status;

        private Instant lastModifiedTime;

        private String domainName;

        private ActiveTrustedSigners activeTrustedSigners;

        private StreamingDistributionConfig streamingDistributionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingDistribution model) {
            id(model.id);
            arn(model.arn);
            status(model.status);
            lastModifiedTime(model.lastModifiedTime);
            domainName(model.domainName);
            activeTrustedSigners(model.activeTrustedSigners);
            streamingDistributionConfig(model.streamingDistributionConfig);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getARN() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final ActiveTrustedSigners.Builder getActiveTrustedSigners() {
            return activeTrustedSigners != null ? activeTrustedSigners.toBuilder() : null;
        }

        @Override
        public final Builder activeTrustedSigners(ActiveTrustedSigners activeTrustedSigners) {
            this.activeTrustedSigners = activeTrustedSigners;
            return this;
        }

        public final void setActiveTrustedSigners(ActiveTrustedSigners.BuilderImpl activeTrustedSigners) {
            this.activeTrustedSigners = activeTrustedSigners != null ? activeTrustedSigners.build() : null;
        }

        public final StreamingDistributionConfig.Builder getStreamingDistributionConfig() {
            return streamingDistributionConfig != null ? streamingDistributionConfig.toBuilder() : null;
        }

        @Override
        public final Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig;
            return this;
        }

        public final void setStreamingDistributionConfig(StreamingDistributionConfig.BuilderImpl streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig != null ? streamingDistributionConfig.build() : null;
        }

        @Override
        public StreamingDistribution build() {
            return new StreamingDistribution(this);
        }
    }
}
