/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that identifies ways in which you want to restrict distribution of your content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Restrictions implements ToCopyableBuilder<Restrictions.Builder, Restrictions> {
    private final GeoRestriction geoRestriction;

    private Restrictions(BuilderImpl builder) {
        this.geoRestriction = builder.geoRestriction;
    }

    /**
     * Returns the value of the GeoRestriction property for this object.
     * 
     * @return The value of the GeoRestriction property for this object.
     */
    public GeoRestriction geoRestriction() {
        return geoRestriction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(geoRestriction());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Restrictions)) {
            return false;
        }
        Restrictions other = (Restrictions) obj;
        return Objects.equals(geoRestriction(), other.geoRestriction());
    }

    @Override
    public String toString() {
        return ToString.builder("Restrictions").add("GeoRestriction", geoRestriction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeoRestriction":
            return Optional.of(clazz.cast(geoRestriction()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Restrictions> {
        /**
         * Sets the value of the GeoRestriction property for this object.
         *
         * @param geoRestriction
         *        The new value for the GeoRestriction property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoRestriction(GeoRestriction geoRestriction);

        /**
         * Sets the value of the GeoRestriction property for this object.
         *
         * This is a convenience that creates an instance of the {@link GeoRestriction.Builder} avoiding the need to
         * create one manually via {@link GeoRestriction#builder()}.
         *
         * When the {@link Consumer} completes, {@link GeoRestriction.Builder#build()} is called immediately and its
         * result is passed to {@link #geoRestriction(GeoRestriction)}.
         * 
         * @param geoRestriction
         *        a consumer that will call methods on {@link GeoRestriction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geoRestriction(GeoRestriction)
         */
        default Builder geoRestriction(Consumer<GeoRestriction.Builder> geoRestriction) {
            return geoRestriction(GeoRestriction.builder().apply(geoRestriction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GeoRestriction geoRestriction;

        private BuilderImpl() {
        }

        private BuilderImpl(Restrictions model) {
            geoRestriction(model.geoRestriction);
        }

        public final GeoRestriction.Builder getGeoRestriction() {
            return geoRestriction != null ? geoRestriction.toBuilder() : null;
        }

        @Override
        public final Builder geoRestriction(GeoRestriction geoRestriction) {
            this.geoRestriction = geoRestriction;
            return this;
        }

        public final void setGeoRestriction(GeoRestriction.BuilderImpl geoRestriction) {
            this.geoRestriction = geoRestriction != null ? geoRestriction.build() : null;
        }

        @Override
        public Restrictions build() {
            return new Restrictions(this);
        }
    }
}
