/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about origins for this distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Origins implements ToCopyableBuilder<Origins.Builder, Origins> {
    private final Integer quantity;

    private final List<Origin> items;

    private Origins(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * The number of origins for this distribution.
     * </p>
     * 
     * @return The number of origins for this distribution.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * A complex type that contains origins for this distribution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains origins for this distribution.
     */
    public List<Origin> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(items());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Origins)) {
            return false;
        }
        Origins other = (Origins) obj;
        return Objects.equals(quantity(), other.quantity()) && Objects.equals(items(), other.items());
    }

    @Override
    public String toString() {
        return ToString.builder("Origins").add("Quantity", quantity()).add("Items", items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Quantity":
            return Optional.of(clazz.cast(quantity()));
        case "Items":
            return Optional.of(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Origins> {
        /**
         * <p>
         * The number of origins for this distribution.
         * </p>
         * 
         * @param quantity
         *        The number of origins for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * A complex type that contains origins for this distribution.
         * </p>
         * 
         * @param items
         *        A complex type that contains origins for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<Origin> items);

        /**
         * <p>
         * A complex type that contains origins for this distribution.
         * </p>
         * 
         * @param items
         *        A complex type that contains origins for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Origin... items);

        /**
         * <p>
         * A complex type that contains origins for this distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Origin>.Builder} avoiding the need to
         * create one manually via {@link List<Origin>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Origin>.Builder#build()} is called immediately and its
         * result is passed to {@link #items(List<Origin>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<Origin>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<Origin>)
         */
        Builder items(Consumer<Origin.Builder>... items);
    }

    static final class BuilderImpl implements Builder {
        private Integer quantity;

        private List<Origin> items;

        private BuilderImpl() {
        }

        private BuilderImpl(Origins model) {
            quantity(model.quantity);
            items(model.items);
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<Origin.Builder> getItems() {
            return items != null ? items.stream().map(Origin::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<Origin> items) {
            this.items = OriginListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Origin... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<Origin.Builder>... items) {
            items(Stream.of(items).map(c -> Origin.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<Origin.BuilderImpl> items) {
            this.items = OriginListCopier.copyFromBuilder(items);
        }

        @Override
        public Origins build() {
            return new Origins(this);
        }
    }
}
