/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that controls whether access logs are written for the distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LoggingConfig implements ToCopyableBuilder<LoggingConfig.Builder, LoggingConfig> {
    private final Boolean enabled;

    private final Boolean includeCookies;

    private final String bucket;

    private final String prefix;

    private LoggingConfig(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.includeCookies = builder.includeCookies;
        this.bucket = builder.bucket;
        this.prefix = builder.prefix;
    }

    /**
     * <p>
     * Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't want to enable
     * logging when you create a distribution or if you want to disable logging for an existing distribution, specify
     * <code>false</code> for <code>Enabled</code>, and specify empty <code>Bucket</code> and <code>Prefix</code>
     * elements. If you specify <code>false</code> for <code>Enabled</code> but you specify values for
     * <code>Bucket</code>, <code>prefix</code>, and <code>IncludeCookies</code>, the values are automatically deleted.
     * </p>
     * 
     * @return Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't want to
     *         enable logging when you create a distribution or if you want to disable logging for an existing
     *         distribution, specify <code>false</code> for <code>Enabled</code>, and specify empty <code>Bucket</code>
     *         and <code>Prefix</code> elements. If you specify <code>false</code> for <code>Enabled</code> but you
     *         specify values for <code>Bucket</code>, <code>prefix</code>, and <code>IncludeCookies</code>, the values
     *         are automatically deleted.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Specifies whether you want CloudFront to include cookies in access logs, specify <code>true</code> for
     * <code>IncludeCookies</code>. If you choose to include cookies in logs, CloudFront logs all cookies regardless of
     * how you configure the cache behaviors for this distribution. If you don't want to include cookies when you create
     * a distribution or if you want to disable include cookies for an existing distribution, specify <code>false</code>
     * for <code>IncludeCookies</code>.
     * </p>
     * 
     * @return Specifies whether you want CloudFront to include cookies in access logs, specify <code>true</code> for
     *         <code>IncludeCookies</code>. If you choose to include cookies in logs, CloudFront logs all cookies
     *         regardless of how you configure the cache behaviors for this distribution. If you don't want to include
     *         cookies when you create a distribution or if you want to disable include cookies for an existing
     *         distribution, specify <code>false</code> for <code>IncludeCookies</code>.
     */
    public Boolean includeCookies() {
        return includeCookies;
    }

    /**
     * <p>
     * The Amazon S3 bucket to store the access logs in, for example, <code>myawslogbucket.s3.amazonaws.com</code>.
     * </p>
     * 
     * @return The Amazon S3 bucket to store the access logs in, for example,
     *         <code>myawslogbucket.s3.amazonaws.com</code>.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * An optional string that you want CloudFront to prefix to the access log <code>filenames</code> for this
     * distribution, for example, <code>myprefix/</code>. If you want to enable logging, but you don't want to specify a
     * prefix, you still must include an empty <code>Prefix</code> element in the <code>Logging</code> element.
     * </p>
     * 
     * @return An optional string that you want CloudFront to prefix to the access log <code>filenames</code> for this
     *         distribution, for example, <code>myprefix/</code>. If you want to enable logging, but you don't want to
     *         specify a prefix, you still must include an empty <code>Prefix</code> element in the <code>Logging</code>
     *         element.
     */
    public String prefix() {
        return prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(includeCookies());
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfig)) {
            return false;
        }
        LoggingConfig other = (LoggingConfig) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(includeCookies(), other.includeCookies())
                && Objects.equals(bucket(), other.bucket()) && Objects.equals(prefix(), other.prefix());
    }

    @Override
    public String toString() {
        return ToString.builder("LoggingConfig").add("Enabled", enabled()).add("IncludeCookies", includeCookies())
                .add("Bucket", bucket()).add("Prefix", prefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.of(clazz.cast(enabled()));
        case "IncludeCookies":
            return Optional.of(clazz.cast(includeCookies()));
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "Prefix":
            return Optional.of(clazz.cast(prefix()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, LoggingConfig> {
        /**
         * <p>
         * Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't want to enable
         * logging when you create a distribution or if you want to disable logging for an existing distribution,
         * specify <code>false</code> for <code>Enabled</code>, and specify empty <code>Bucket</code> and
         * <code>Prefix</code> elements. If you specify <code>false</code> for <code>Enabled</code> but you specify
         * values for <code>Bucket</code>, <code>prefix</code>, and <code>IncludeCookies</code>, the values are
         * automatically deleted.
         * </p>
         * 
         * @param enabled
         *        Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't want to
         *        enable logging when you create a distribution or if you want to disable logging for an existing
         *        distribution, specify <code>false</code> for <code>Enabled</code>, and specify empty
         *        <code>Bucket</code> and <code>Prefix</code> elements. If you specify <code>false</code> for
         *        <code>Enabled</code> but you specify values for <code>Bucket</code>, <code>prefix</code>, and
         *        <code>IncludeCookies</code>, the values are automatically deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Specifies whether you want CloudFront to include cookies in access logs, specify <code>true</code> for
         * <code>IncludeCookies</code>. If you choose to include cookies in logs, CloudFront logs all cookies regardless
         * of how you configure the cache behaviors for this distribution. If you don't want to include cookies when you
         * create a distribution or if you want to disable include cookies for an existing distribution, specify
         * <code>false</code> for <code>IncludeCookies</code>.
         * </p>
         * 
         * @param includeCookies
         *        Specifies whether you want CloudFront to include cookies in access logs, specify <code>true</code> for
         *        <code>IncludeCookies</code>. If you choose to include cookies in logs, CloudFront logs all cookies
         *        regardless of how you configure the cache behaviors for this distribution. If you don't want to
         *        include cookies when you create a distribution or if you want to disable include cookies for an
         *        existing distribution, specify <code>false</code> for <code>IncludeCookies</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeCookies(Boolean includeCookies);

        /**
         * <p>
         * The Amazon S3 bucket to store the access logs in, for example, <code>myawslogbucket.s3.amazonaws.com</code>.
         * </p>
         * 
         * @param bucket
         *        The Amazon S3 bucket to store the access logs in, for example,
         *        <code>myawslogbucket.s3.amazonaws.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * An optional string that you want CloudFront to prefix to the access log <code>filenames</code> for this
         * distribution, for example, <code>myprefix/</code>. If you want to enable logging, but you don't want to
         * specify a prefix, you still must include an empty <code>Prefix</code> element in the <code>Logging</code>
         * element.
         * </p>
         * 
         * @param prefix
         *        An optional string that you want CloudFront to prefix to the access log <code>filenames</code> for
         *        this distribution, for example, <code>myprefix/</code>. If you want to enable logging, but you don't
         *        want to specify a prefix, you still must include an empty <code>Prefix</code> element in the
         *        <code>Logging</code> element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Boolean includeCookies;

        private String bucket;

        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfig model) {
            enabled(model.enabled);
            includeCookies(model.includeCookies);
            bucket(model.bucket);
            prefix(model.prefix);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Boolean getIncludeCookies() {
            return includeCookies;
        }

        @Override
        public final Builder includeCookies(Boolean includeCookies) {
            this.includeCookies = includeCookies;
            return this;
        }

        public final void setIncludeCookies(Boolean includeCookies) {
            this.includeCookies = includeCookies;
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public LoggingConfig build() {
            return new LoggingConfig(this);
        }
    }
}
