/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListInvalidationsResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListInvalidationsResponse.Builder, ListInvalidationsResponse> {
    private final InvalidationList invalidationList;

    private ListInvalidationsResponse(BuilderImpl builder) {
        super(builder);
        this.invalidationList = builder.invalidationList;
    }

    /**
     * <p>
     * Information about invalidation batches.
     * </p>
     * 
     * @return Information about invalidation batches.
     */
    public InvalidationList invalidationList() {
        return invalidationList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invalidationList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvalidationsResponse)) {
            return false;
        }
        ListInvalidationsResponse other = (ListInvalidationsResponse) obj;
        return Objects.equals(invalidationList(), other.invalidationList());
    }

    @Override
    public String toString() {
        return ToString.builder("ListInvalidationsResponse").add("InvalidationList", invalidationList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvalidationList":
            return Optional.of(clazz.cast(invalidationList()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFrontResponse.Builder, CopyableBuilder<Builder, ListInvalidationsResponse> {
        /**
         * <p>
         * Information about invalidation batches.
         * </p>
         * 
         * @param invalidationList
         *        Information about invalidation batches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidationList(InvalidationList invalidationList);

        /**
         * <p>
         * Information about invalidation batches.
         * </p>
         * This is a convenience that creates an instance of the {@link InvalidationList.Builder} avoiding the need to
         * create one manually via {@link InvalidationList#builder()}.
         *
         * When the {@link Consumer} completes, {@link InvalidationList.Builder#build()} is called immediately and its
         * result is passed to {@link #invalidationList(InvalidationList)}.
         * 
         * @param invalidationList
         *        a consumer that will call methods on {@link InvalidationList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invalidationList(InvalidationList)
         */
        default Builder invalidationList(Consumer<InvalidationList.Builder> invalidationList) {
            return invalidationList(InvalidationList.builder().apply(invalidationList).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private InvalidationList invalidationList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvalidationsResponse model) {
            super(model);
            invalidationList(model.invalidationList);
        }

        public final InvalidationList.Builder getInvalidationList() {
            return invalidationList != null ? invalidationList.toBuilder() : null;
        }

        @Override
        public final Builder invalidationList(InvalidationList invalidationList) {
            this.invalidationList = invalidationList;
            return this;
        }

        public final void setInvalidationList(InvalidationList.BuilderImpl invalidationList) {
            this.invalidationList = invalidationList != null ? invalidationList.build() : null;
        }

        @Override
        public ListInvalidationsResponse build() {
            return new ListInvalidationsResponse(this);
        }
    }
}
