/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListCloudFrontOriginAccessIdentitiesResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListCloudFrontOriginAccessIdentitiesResponse.Builder, ListCloudFrontOriginAccessIdentitiesResponse> {
    private final CloudFrontOriginAccessIdentityList cloudFrontOriginAccessIdentityList;

    private ListCloudFrontOriginAccessIdentitiesResponse(BuilderImpl builder) {
        super(builder);
        this.cloudFrontOriginAccessIdentityList = builder.cloudFrontOriginAccessIdentityList;
    }

    /**
     * <p>
     * The <code>CloudFrontOriginAccessIdentityList</code> type.
     * </p>
     * 
     * @return The <code>CloudFrontOriginAccessIdentityList</code> type.
     */
    public CloudFrontOriginAccessIdentityList cloudFrontOriginAccessIdentityList() {
        return cloudFrontOriginAccessIdentityList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudFrontOriginAccessIdentityList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCloudFrontOriginAccessIdentitiesResponse)) {
            return false;
        }
        ListCloudFrontOriginAccessIdentitiesResponse other = (ListCloudFrontOriginAccessIdentitiesResponse) obj;
        return Objects.equals(cloudFrontOriginAccessIdentityList(), other.cloudFrontOriginAccessIdentityList());
    }

    @Override
    public String toString() {
        return ToString.builder("ListCloudFrontOriginAccessIdentitiesResponse")
                .add("CloudFrontOriginAccessIdentityList", cloudFrontOriginAccessIdentityList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudFrontOriginAccessIdentityList":
            return Optional.of(clazz.cast(cloudFrontOriginAccessIdentityList()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFrontResponse.Builder,
            CopyableBuilder<Builder, ListCloudFrontOriginAccessIdentitiesResponse> {
        /**
         * <p>
         * The <code>CloudFrontOriginAccessIdentityList</code> type.
         * </p>
         * 
         * @param cloudFrontOriginAccessIdentityList
         *        The <code>CloudFrontOriginAccessIdentityList</code> type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFrontOriginAccessIdentityList(CloudFrontOriginAccessIdentityList cloudFrontOriginAccessIdentityList);

        /**
         * <p>
         * The <code>CloudFrontOriginAccessIdentityList</code> type.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudFrontOriginAccessIdentityList.Builder}
         * avoiding the need to create one manually via {@link CloudFrontOriginAccessIdentityList#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudFrontOriginAccessIdentityList.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cloudFrontOriginAccessIdentityList(CloudFrontOriginAccessIdentityList)}.
         * 
         * @param cloudFrontOriginAccessIdentityList
         *        a consumer that will call methods on {@link CloudFrontOriginAccessIdentityList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFrontOriginAccessIdentityList(CloudFrontOriginAccessIdentityList)
         */
        default Builder cloudFrontOriginAccessIdentityList(
                Consumer<CloudFrontOriginAccessIdentityList.Builder> cloudFrontOriginAccessIdentityList) {
            return cloudFrontOriginAccessIdentityList(CloudFrontOriginAccessIdentityList.builder()
                    .apply(cloudFrontOriginAccessIdentityList).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private CloudFrontOriginAccessIdentityList cloudFrontOriginAccessIdentityList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCloudFrontOriginAccessIdentitiesResponse model) {
            super(model);
            cloudFrontOriginAccessIdentityList(model.cloudFrontOriginAccessIdentityList);
        }

        public final CloudFrontOriginAccessIdentityList.Builder getCloudFrontOriginAccessIdentityList() {
            return cloudFrontOriginAccessIdentityList != null ? cloudFrontOriginAccessIdentityList.toBuilder() : null;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentityList(
                CloudFrontOriginAccessIdentityList cloudFrontOriginAccessIdentityList) {
            this.cloudFrontOriginAccessIdentityList = cloudFrontOriginAccessIdentityList;
            return this;
        }

        public final void setCloudFrontOriginAccessIdentityList(
                CloudFrontOriginAccessIdentityList.BuilderImpl cloudFrontOriginAccessIdentityList) {
            this.cloudFrontOriginAccessIdentityList = cloudFrontOriginAccessIdentityList != null ? cloudFrontOriginAccessIdentityList
                    .build() : null;
        }

        @Override
        public ListCloudFrontOriginAccessIdentitiesResponse build() {
            return new ListCloudFrontOriginAccessIdentitiesResponse(this);
        }
    }
}
