/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to list origin access identities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListCloudFrontOriginAccessIdentitiesRequest extends CloudFrontRequest implements
        ToCopyableBuilder<ListCloudFrontOriginAccessIdentitiesRequest.Builder, ListCloudFrontOriginAccessIdentitiesRequest> {
    private final String marker;

    private final String maxItems;

    private ListCloudFrontOriginAccessIdentitiesRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * Use this when paginating results to indicate where to begin in your list of origin access identities. The results
     * include identities in the list that occur after the marker. To get the next page of results, set the
     * <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also
     * the ID of the last identity on that page).
     * </p>
     * 
     * @return Use this when paginating results to indicate where to begin in your list of origin access identities. The
     *         results include identities in the list that occur after the marker. To get the next page of results, set
     *         the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response
     *         (which is also the ID of the last identity on that page).
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of origin access identities you want in the response body.
     * </p>
     * 
     * @return The maximum number of origin access identities you want in the response body.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCloudFrontOriginAccessIdentitiesRequest)) {
            return false;
        }
        ListCloudFrontOriginAccessIdentitiesRequest other = (ListCloudFrontOriginAccessIdentitiesRequest) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems());
    }

    @Override
    public String toString() {
        return ToString.builder("ListCloudFrontOriginAccessIdentitiesRequest").add("Marker", marker())
                .add("MaxItems", maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.of(clazz.cast(marker()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFrontRequest.Builder,
            CopyableBuilder<Builder, ListCloudFrontOriginAccessIdentitiesRequest> {
        /**
         * <p>
         * Use this when paginating results to indicate where to begin in your list of origin access identities. The
         * results include identities in the list that occur after the marker. To get the next page of results, set the
         * <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is
         * also the ID of the last identity on that page).
         * </p>
         * 
         * @param marker
         *        Use this when paginating results to indicate where to begin in your list of origin access identities.
         *        The results include identities in the list that occur after the marker. To get the next page of
         *        results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current
         *        page's response (which is also the ID of the last identity on that page).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of origin access identities you want in the response body.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of origin access identities you want in the response body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String marker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCloudFrontOriginAccessIdentitiesRequest model) {
            super(model);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListCloudFrontOriginAccessIdentitiesRequest build() {
            return new ListCloudFrontOriginAccessIdentitiesRequest(this);
        }
    }
}
