/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An invalidation batch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InvalidationBatch implements ToCopyableBuilder<InvalidationBatch.Builder, InvalidationBatch> {
    private final Paths paths;

    private final String callerReference;

    private InvalidationBatch(BuilderImpl builder) {
        this.paths = builder.paths;
        this.callerReference = builder.callerReference;
    }

    /**
     * <p>
     * A complex type that contains information about the objects that you want to invalidate. For more information, see
     * <a href=
     * "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects"
     * >Specifying the Objects to Invalidate</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return A complex type that contains information about the objects that you want to invalidate. For more
     *         information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects"
     *         >Specifying the Objects to Invalidate</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public Paths paths() {
        return paths;
    }

    /**
     * <p>
     * A value that you specify to uniquely identify an invalidation request. CloudFront uses the value to prevent you
     * from accidentally resubmitting an identical request. Whenever you create a new invalidation request, you must
     * specify a new value for <code>CallerReference</code> and change other values in the request as applicable. One
     * way to ensure that the value of <code>CallerReference</code> is unique is to use a <code>timestamp</code>, for
     * example, <code>20120301090000</code>.
     * </p>
     * <p>
     * If you make a second invalidation request with the same value for <code>CallerReference</code>, and if the rest
     * of the request is the same, CloudFront doesn't create a new invalidation request. Instead, CloudFront returns
     * information about the invalidation request that you previously created with the same <code>CallerReference</code>
     * .
     * </p>
     * <p>
     * If <code>CallerReference</code> is a value you already sent in a previous invalidation batch request but the
     * content of any <code>Path</code> is different from the original request, CloudFront returns an
     * <code>InvalidationBatchAlreadyExists</code> error.
     * </p>
     * 
     * @return A value that you specify to uniquely identify an invalidation request. CloudFront uses the value to
     *         prevent you from accidentally resubmitting an identical request. Whenever you create a new invalidation
     *         request, you must specify a new value for <code>CallerReference</code> and change other values in the
     *         request as applicable. One way to ensure that the value of <code>CallerReference</code> is unique is to
     *         use a <code>timestamp</code>, for example, <code>20120301090000</code>.</p>
     *         <p>
     *         If you make a second invalidation request with the same value for <code>CallerReference</code>, and if
     *         the rest of the request is the same, CloudFront doesn't create a new invalidation request. Instead,
     *         CloudFront returns information about the invalidation request that you previously created with the same
     *         <code>CallerReference</code>.
     *         </p>
     *         <p>
     *         If <code>CallerReference</code> is a value you already sent in a previous invalidation batch request but
     *         the content of any <code>Path</code> is different from the original request, CloudFront returns an
     *         <code>InvalidationBatchAlreadyExists</code> error.
     */
    public String callerReference() {
        return callerReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(paths());
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvalidationBatch)) {
            return false;
        }
        InvalidationBatch other = (InvalidationBatch) obj;
        return Objects.equals(paths(), other.paths()) && Objects.equals(callerReference(), other.callerReference());
    }

    @Override
    public String toString() {
        return ToString.builder("InvalidationBatch").add("Paths", paths()).add("CallerReference", callerReference()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Paths":
            return Optional.of(clazz.cast(paths()));
        case "CallerReference":
            return Optional.of(clazz.cast(callerReference()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InvalidationBatch> {
        /**
         * <p>
         * A complex type that contains information about the objects that you want to invalidate. For more information,
         * see <a href=
         * "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects"
         * >Specifying the Objects to Invalidate</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param paths
         *        A complex type that contains information about the objects that you want to invalidate. For more
         *        information, see <a href=
         *        "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects"
         *        >Specifying the Objects to Invalidate</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paths(Paths paths);

        /**
         * <p>
         * A complex type that contains information about the objects that you want to invalidate. For more information,
         * see <a href=
         * "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects"
         * >Specifying the Objects to Invalidate</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link Paths.Builder} avoiding the need to create one
         * manually via {@link Paths#builder()}.
         *
         * When the {@link Consumer} completes, {@link Paths.Builder#build()} is called immediately and its result is
         * passed to {@link #paths(Paths)}.
         * 
         * @param paths
         *        a consumer that will call methods on {@link Paths.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #paths(Paths)
         */
        default Builder paths(Consumer<Paths.Builder> paths) {
            return paths(Paths.builder().apply(paths).build());
        }

        /**
         * <p>
         * A value that you specify to uniquely identify an invalidation request. CloudFront uses the value to prevent
         * you from accidentally resubmitting an identical request. Whenever you create a new invalidation request, you
         * must specify a new value for <code>CallerReference</code> and change other values in the request as
         * applicable. One way to ensure that the value of <code>CallerReference</code> is unique is to use a
         * <code>timestamp</code>, for example, <code>20120301090000</code>.
         * </p>
         * <p>
         * If you make a second invalidation request with the same value for <code>CallerReference</code>, and if the
         * rest of the request is the same, CloudFront doesn't create a new invalidation request. Instead, CloudFront
         * returns information about the invalidation request that you previously created with the same
         * <code>CallerReference</code>.
         * </p>
         * <p>
         * If <code>CallerReference</code> is a value you already sent in a previous invalidation batch request but the
         * content of any <code>Path</code> is different from the original request, CloudFront returns an
         * <code>InvalidationBatchAlreadyExists</code> error.
         * </p>
         * 
         * @param callerReference
         *        A value that you specify to uniquely identify an invalidation request. CloudFront uses the value to
         *        prevent you from accidentally resubmitting an identical request. Whenever you create a new
         *        invalidation request, you must specify a new value for <code>CallerReference</code> and change other
         *        values in the request as applicable. One way to ensure that the value of <code>CallerReference</code>
         *        is unique is to use a <code>timestamp</code>, for example, <code>20120301090000</code>.</p>
         *        <p>
         *        If you make a second invalidation request with the same value for <code>CallerReference</code>, and if
         *        the rest of the request is the same, CloudFront doesn't create a new invalidation request. Instead,
         *        CloudFront returns information about the invalidation request that you previously created with the
         *        same <code>CallerReference</code>.
         *        </p>
         *        <p>
         *        If <code>CallerReference</code> is a value you already sent in a previous invalidation batch request
         *        but the content of any <code>Path</code> is different from the original request, CloudFront returns an
         *        <code>InvalidationBatchAlreadyExists</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);
    }

    static final class BuilderImpl implements Builder {
        private Paths paths;

        private String callerReference;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidationBatch model) {
            paths(model.paths);
            callerReference(model.callerReference);
        }

        public final Paths.Builder getPaths() {
            return paths != null ? paths.toBuilder() : null;
        }

        @Override
        public final Builder paths(Paths paths) {
            this.paths = paths;
            return this;
        }

        public final void setPaths(Paths.BuilderImpl paths) {
            this.paths = paths != null ? paths.build() : null;
        }

        public final String getCallerReference() {
            return callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        @Override
        public InvalidationBatch build() {
            return new InvalidationBatch(this);
        }
    }
}
