/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetStreamingDistributionResponse extends CloudFrontResponse implements
        ToCopyableBuilder<GetStreamingDistributionResponse.Builder, GetStreamingDistributionResponse> {
    private final StreamingDistribution streamingDistribution;

    private final String eTag;

    private GetStreamingDistributionResponse(BuilderImpl builder) {
        super(builder);
        this.streamingDistribution = builder.streamingDistribution;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The streaming distribution's information.
     * </p>
     * 
     * @return The streaming distribution's information.
     */
    public StreamingDistribution streamingDistribution() {
        return streamingDistribution;
    }

    /**
     * <p>
     * The current version of the streaming distribution's information. For example: <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The current version of the streaming distribution's information. For example: <code>E2QWRUHAPOMQZL</code>
     *         .
     */
    public String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamingDistribution());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStreamingDistributionResponse)) {
            return false;
        }
        GetStreamingDistributionResponse other = (GetStreamingDistributionResponse) obj;
        return Objects.equals(streamingDistribution(), other.streamingDistribution()) && Objects.equals(eTag(), other.eTag());
    }

    @Override
    public String toString() {
        return ToString.builder("GetStreamingDistributionResponse").add("StreamingDistribution", streamingDistribution())
                .add("ETag", eTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamingDistribution":
            return Optional.of(clazz.cast(streamingDistribution()));
        case "ETag":
            return Optional.of(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFrontResponse.Builder, CopyableBuilder<Builder, GetStreamingDistributionResponse> {
        /**
         * <p>
         * The streaming distribution's information.
         * </p>
         * 
         * @param streamingDistribution
         *        The streaming distribution's information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingDistribution(StreamingDistribution streamingDistribution);

        /**
         * <p>
         * The streaming distribution's information.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamingDistribution.Builder} avoiding the need
         * to create one manually via {@link StreamingDistribution#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamingDistribution.Builder#build()} is called immediately and
         * its result is passed to {@link #streamingDistribution(StreamingDistribution)}.
         * 
         * @param streamingDistribution
         *        a consumer that will call methods on {@link StreamingDistribution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingDistribution(StreamingDistribution)
         */
        default Builder streamingDistribution(Consumer<StreamingDistribution.Builder> streamingDistribution) {
            return streamingDistribution(StreamingDistribution.builder().apply(streamingDistribution).build());
        }

        /**
         * <p>
         * The current version of the streaming distribution's information. For example: <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param eTag
         *        The current version of the streaming distribution's information. For example:
         *        <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private StreamingDistribution streamingDistribution;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStreamingDistributionResponse model) {
            super(model);
            streamingDistribution(model.streamingDistribution);
            eTag(model.eTag);
        }

        public final StreamingDistribution.Builder getStreamingDistribution() {
            return streamingDistribution != null ? streamingDistribution.toBuilder() : null;
        }

        @Override
        public final Builder streamingDistribution(StreamingDistribution streamingDistribution) {
            this.streamingDistribution = streamingDistribution;
            return this;
        }

        public final void setStreamingDistribution(StreamingDistribution.BuilderImpl streamingDistribution) {
            this.streamingDistribution = streamingDistribution != null ? streamingDistribution.build() : null;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public GetStreamingDistributionResponse build() {
            return new GetStreamingDistributionResponse(this);
        }
    }
}
