/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A distribution configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DistributionConfig implements ToCopyableBuilder<DistributionConfig.Builder, DistributionConfig> {
    private final String callerReference;

    private final Aliases aliases;

    private final String defaultRootObject;

    private final Origins origins;

    private final DefaultCacheBehavior defaultCacheBehavior;

    private final CacheBehaviors cacheBehaviors;

    private final CustomErrorResponses customErrorResponses;

    private final String comment;

    private final LoggingConfig logging;

    private final String priceClass;

    private final Boolean enabled;

    private final ViewerCertificate viewerCertificate;

    private final Restrictions restrictions;

    private final String webACLId;

    private final String httpVersion;

    private final Boolean isIPV6Enabled;

    private DistributionConfig(BuilderImpl builder) {
        this.callerReference = builder.callerReference;
        this.aliases = builder.aliases;
        this.defaultRootObject = builder.defaultRootObject;
        this.origins = builder.origins;
        this.defaultCacheBehavior = builder.defaultCacheBehavior;
        this.cacheBehaviors = builder.cacheBehaviors;
        this.customErrorResponses = builder.customErrorResponses;
        this.comment = builder.comment;
        this.logging = builder.logging;
        this.priceClass = builder.priceClass;
        this.enabled = builder.enabled;
        this.viewerCertificate = builder.viewerCertificate;
        this.restrictions = builder.restrictions;
        this.webACLId = builder.webACLId;
        this.httpVersion = builder.httpVersion;
        this.isIPV6Enabled = builder.isIPV6Enabled;
    }

    /**
     * <p>
     * A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.
     * </p>
     * <p>
     * If the value of <code>CallerReference</code> is new (regardless of the content of the
     * <code>DistributionConfig</code> object), CloudFront creates a new distribution.
     * </p>
     * <p>
     * If <code>CallerReference</code> is a value you already sent in a previous request to create a distribution, and
     * if the content of the <code>DistributionConfig</code> is identical to the original request (ignoring white
     * space), CloudFront returns the same the response that it returned to the original request.
     * </p>
     * <p>
     * If <code>CallerReference</code> is a value you already sent in a previous request to create a distribution but
     * the content of the <code>DistributionConfig</code> is different from the original request, CloudFront returns a
     * <code>DistributionAlreadyExists</code> error.
     * </p>
     * 
     * @return A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.</p>
     *         <p>
     *         If the value of <code>CallerReference</code> is new (regardless of the content of the
     *         <code>DistributionConfig</code> object), CloudFront creates a new distribution.
     *         </p>
     *         <p>
     *         If <code>CallerReference</code> is a value you already sent in a previous request to create a
     *         distribution, and if the content of the <code>DistributionConfig</code> is identical to the original
     *         request (ignoring white space), CloudFront returns the same the response that it returned to the original
     *         request.
     *         </p>
     *         <p>
     *         If <code>CallerReference</code> is a value you already sent in a previous request to create a
     *         distribution but the content of the <code>DistributionConfig</code> is different from the original
     *         request, CloudFront returns a <code>DistributionAlreadyExists</code> error.
     */
    public String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.
     * </p>
     * 
     * @return A complex type that contains information about CNAMEs (alternate domain names), if any, for this
     *         distribution.
     */
    public Aliases aliases() {
        return aliases;
    }

    /**
     * <p>
     * The object that you want CloudFront to request from your origin (for example, <code>index.html</code>) when a
     * viewer requests the root URL for your distribution (<code>http://www.example.com</code>) instead of an object in
     * your distribution (<code>http://www.example.com/product-description.html</code>). Specifying a default root
     * object avoids exposing the contents of your distribution.
     * </p>
     * <p>
     * Specify only the object name, for example, <code>index.html</code>. Don't add a <code>/</code> before the object
     * name.
     * </p>
     * <p>
     * If you don't want to specify a default root object when you create a distribution, include an empty
     * <code>DefaultRootObject</code> element.
     * </p>
     * <p>
     * To delete the default root object from an existing distribution, update the distribution configuration and
     * include an empty <code>DefaultRootObject</code> element.
     * </p>
     * <p>
     * To replace the default root object, update the distribution configuration and specify the new object.
     * </p>
     * <p>
     * For more information about the default root object, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html">Creating a
     * Default Root Object</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return The object that you want CloudFront to request from your origin (for example, <code>index.html</code>)
     *         when a viewer requests the root URL for your distribution (<code>http://www.example.com</code>) instead
     *         of an object in your distribution (<code>http://www.example.com/product-description.html</code>).
     *         Specifying a default root object avoids exposing the contents of your distribution.</p>
     *         <p>
     *         Specify only the object name, for example, <code>index.html</code>. Don't add a <code>/</code> before the
     *         object name.
     *         </p>
     *         <p>
     *         If you don't want to specify a default root object when you create a distribution, include an empty
     *         <code>DefaultRootObject</code> element.
     *         </p>
     *         <p>
     *         To delete the default root object from an existing distribution, update the distribution configuration
     *         and include an empty <code>DefaultRootObject</code> element.
     *         </p>
     *         <p>
     *         To replace the default root object, update the distribution configuration and specify the new object.
     *         </p>
     *         <p>
     *         For more information about the default root object, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html">Creating
     *         a Default Root Object</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public String defaultRootObject() {
        return defaultRootObject;
    }

    /**
     * <p>
     * A complex type that contains information about origins for this distribution.
     * </p>
     * 
     * @return A complex type that contains information about origins for this distribution.
     */
    public Origins origins() {
        return origins;
    }

    /**
     * <p>
     * A complex type that describes the default cache behavior if you don't specify a <code>CacheBehavior</code>
     * element or if files don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code>
     * elements. You must create exactly one default cache behavior.
     * </p>
     * 
     * @return A complex type that describes the default cache behavior if you don't specify a
     *         <code>CacheBehavior</code> element or if files don't match any of the values of <code>PathPattern</code>
     *         in <code>CacheBehavior</code> elements. You must create exactly one default cache behavior.
     */
    public DefaultCacheBehavior defaultCacheBehavior() {
        return defaultCacheBehavior;
    }

    /**
     * <p>
     * A complex type that contains zero or more <code>CacheBehavior</code> elements.
     * </p>
     * 
     * @return A complex type that contains zero or more <code>CacheBehavior</code> elements.
     */
    public CacheBehaviors cacheBehaviors() {
        return cacheBehaviors;
    }

    /**
     * <p>
     * A complex type that controls the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before
     * returning the response to the viewer.
     * </p>
     * </li>
     * <li>
     * <p>
     * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about custom error pages, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing
     * Error Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return A complex type that controls the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before
     *         returning the response to the viewer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about custom error pages, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html"
     *         >Customizing Error Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public CustomErrorResponses customErrorResponses() {
        return customErrorResponses;
    }

    /**
     * <p>
     * Any comments you want to include about the distribution.
     * </p>
     * <p>
     * If you don't want to specify a comment, include an empty <code>Comment</code> element.
     * </p>
     * <p>
     * To delete an existing comment, update the distribution configuration and include an empty <code>Comment</code>
     * element.
     * </p>
     * <p>
     * To add or change a comment, update the distribution configuration and specify the new comment.
     * </p>
     * 
     * @return Any comments you want to include about the distribution.</p>
     *         <p>
     *         If you don't want to specify a comment, include an empty <code>Comment</code> element.
     *         </p>
     *         <p>
     *         To delete an existing comment, update the distribution configuration and include an empty
     *         <code>Comment</code> element.
     *         </p>
     *         <p>
     *         To add or change a comment, update the distribution configuration and specify the new comment.
     */
    public String comment() {
        return comment;
    }

    /**
     * <p>
     * A complex type that controls whether access logs are written for the distribution.
     * </p>
     * <p>
     * For more information about logging, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access Logs</a> in the
     * <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return A complex type that controls whether access logs are written for the distribution.</p>
     *         <p>
     *         For more information about logging, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access Logs</a>
     *         in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public LoggingConfig logging() {
        return logging;
    }

    /**
     * <p>
     * The price class that corresponds with the maximum price that you want to pay for CloudFront service. If you
     * specify <code>PriceClass_All</code>, CloudFront responds to requests for your objects from all CloudFront edge
     * locations.
     * </p>
     * <p>
     * If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your objects from the
     * CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers who
     * are in or near regions that are excluded from your specified price class may encounter slower performance.
     * </p>
     * <p>
     * For more information about price classes, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the Price Class
     * for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For information about
     * CloudFront pricing, including how price classes map to CloudFront regions, see <a
     * href="https://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront Pricing</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceClass} will
     * return {@link PriceClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceClassAsString}.
     * </p>
     * 
     * @return The price class that corresponds with the maximum price that you want to pay for CloudFront service. If
     *         you specify <code>PriceClass_All</code>, CloudFront responds to requests for your objects from all
     *         CloudFront edge locations.</p>
     *         <p>
     *         If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your objects from
     *         the CloudFront edge location that has the lowest latency among the edge locations in your price class.
     *         Viewers who are in or near regions that are excluded from your specified price class may encounter slower
     *         performance.
     *         </p>
     *         <p>
     *         For more information about price classes, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the
     *         Price Class for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For
     *         information about CloudFront pricing, including how price classes map to CloudFront regions, see <a
     *         href="https://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront Pricing</a>.
     * @see PriceClass
     */
    public PriceClass priceClass() {
        return PriceClass.fromValue(priceClass);
    }

    /**
     * <p>
     * The price class that corresponds with the maximum price that you want to pay for CloudFront service. If you
     * specify <code>PriceClass_All</code>, CloudFront responds to requests for your objects from all CloudFront edge
     * locations.
     * </p>
     * <p>
     * If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your objects from the
     * CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers who
     * are in or near regions that are excluded from your specified price class may encounter slower performance.
     * </p>
     * <p>
     * For more information about price classes, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the Price Class
     * for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For information about
     * CloudFront pricing, including how price classes map to CloudFront regions, see <a
     * href="https://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront Pricing</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceClass} will
     * return {@link PriceClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceClassAsString}.
     * </p>
     * 
     * @return The price class that corresponds with the maximum price that you want to pay for CloudFront service. If
     *         you specify <code>PriceClass_All</code>, CloudFront responds to requests for your objects from all
     *         CloudFront edge locations.</p>
     *         <p>
     *         If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your objects from
     *         the CloudFront edge location that has the lowest latency among the edge locations in your price class.
     *         Viewers who are in or near regions that are excluded from your specified price class may encounter slower
     *         performance.
     *         </p>
     *         <p>
     *         For more information about price classes, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the
     *         Price Class for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For
     *         information about CloudFront pricing, including how price classes map to CloudFront regions, see <a
     *         href="https://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront Pricing</a>.
     * @see PriceClass
     */
    public String priceClassAsString() {
        return priceClass;
    }

    /**
     * <p>
     * From this field, you can enable or disable the selected distribution.
     * </p>
     * <p>
     * If you specify <code>false</code> for <code>Enabled</code> but you specify values for <code>Bucket</code> and
     * <code>Prefix</code>, the values are automatically deleted.
     * </p>
     * 
     * @return From this field, you can enable or disable the selected distribution.</p>
     *         <p>
     *         If you specify <code>false</code> for <code>Enabled</code> but you specify values for <code>Bucket</code>
     *         and <code>Prefix</code>, the values are automatically deleted.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * Returns the value of the ViewerCertificate property for this object.
     * 
     * @return The value of the ViewerCertificate property for this object.
     */
    public ViewerCertificate viewerCertificate() {
        return viewerCertificate;
    }

    /**
     * Returns the value of the Restrictions property for this object.
     * 
     * @return The value of the Restrictions property for this object.
     */
    public Restrictions restrictions() {
        return restrictions;
    }

    /**
     * <p>
     * A unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution.
     * </p>
     * <p>
     * AWS WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to
     * CloudFront, and lets you control access to your content. Based on conditions that you specify, such as the IP
     * addresses that requests originate from or the values of query strings, CloudFront responds to requests either
     * with the requested content or with an HTTP 403 status code (Forbidden). You can also configure CloudFront to
     * return a custom error page when a request is blocked. For more information about AWS WAF, see the <a
     * href="http://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">AWS WAF Developer Guide</a>.
     * </p>
     * 
     * @return A unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution.</p>
     *         <p>
     *         AWS WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are
     *         forwarded to CloudFront, and lets you control access to your content. Based on conditions that you
     *         specify, such as the IP addresses that requests originate from or the values of query strings, CloudFront
     *         responds to requests either with the requested content or with an HTTP 403 status code (Forbidden). You
     *         can also configure CloudFront to return a custom error page when a request is blocked. For more
     *         information about AWS WAF, see the <a
     *         href="http://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">AWS WAF Developer
     *         Guide</a>.
     */
    public String webACLId() {
        return webACLId;
    }

    /**
     * <p>
     * (Optional) Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The
     * default value for new web distributions is http2. Viewers that don't support HTTP/2 automatically use an earlier
     * HTTP version.
     * </p>
     * <p>
     * For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must support Server Name
     * Identification (SNI).
     * </p>
     * <p>
     * In general, configuring CloudFront to communicate with viewers using HTTP/2 reduces latency. You can improve
     * performance by optimizing for HTTP/2. For more information, do an Internet search for "http/2 optimization."
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpVersion} will
     * return {@link HttpVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpVersionAsString}.
     * </p>
     * 
     * @return (Optional) Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront.
     *         The default value for new web distributions is http2. Viewers that don't support HTTP/2 automatically use
     *         an earlier HTTP version.</p>
     *         <p>
     *         For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must support Server
     *         Name Identification (SNI).
     *         </p>
     *         <p>
     *         In general, configuring CloudFront to communicate with viewers using HTTP/2 reduces latency. You can
     *         improve performance by optimizing for HTTP/2. For more information, do an Internet search for
     *         "http/2 optimization."
     * @see HttpVersion
     */
    public HttpVersion httpVersion() {
        return HttpVersion.fromValue(httpVersion);
    }

    /**
     * <p>
     * (Optional) Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The
     * default value for new web distributions is http2. Viewers that don't support HTTP/2 automatically use an earlier
     * HTTP version.
     * </p>
     * <p>
     * For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must support Server Name
     * Identification (SNI).
     * </p>
     * <p>
     * In general, configuring CloudFront to communicate with viewers using HTTP/2 reduces latency. You can improve
     * performance by optimizing for HTTP/2. For more information, do an Internet search for "http/2 optimization."
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpVersion} will
     * return {@link HttpVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpVersionAsString}.
     * </p>
     * 
     * @return (Optional) Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront.
     *         The default value for new web distributions is http2. Viewers that don't support HTTP/2 automatically use
     *         an earlier HTTP version.</p>
     *         <p>
     *         For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must support Server
     *         Name Identification (SNI).
     *         </p>
     *         <p>
     *         In general, configuring CloudFront to communicate with viewers using HTTP/2 reduces latency. You can
     *         improve performance by optimizing for HTTP/2. For more information, do an Internet search for
     *         "http/2 optimization."
     * @see HttpVersion
     */
    public String httpVersionAsString() {
        return httpVersion;
    }

    /**
     * <p>
     * If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution, specify
     * <code>true</code>. If you specify <code>false</code>, CloudFront responds to IPv6 DNS requests with the DNS
     * response code <code>NOERROR</code> and with no IP addresses. This allows viewers to submit a second request, for
     * an IPv4 address for your distribution.
     * </p>
     * <p>
     * In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content. However,
     * if you're using signed URLs or signed cookies to restrict access to your content, and if you're using a custom
     * policy that includes the <code>IpAddress</code> parameter to restrict the IP addresses that can access your
     * content, don't enable IPv6. If you want to restrict access to some content by IP address and not restrict access
     * to other content (or restrict access but not by IP address), you can create two distributions. For more
     * information, see <a href=
     * "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html"
     * >Creating a Signed URL Using a Custom Policy</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * If you're using an Amazon Route 53 alias resource record set to route traffic to your CloudFront distribution,
     * you need to create a second alias resource record set when both of the following are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You enable IPv6 for the distribution
     * </p>
     * </li>
     * <li>
     * <p>
     * You're using alternate domain names in the URLs for your objects
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html">Routing
     * Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name</a> in the <i>Amazon Route 53
     * Developer Guide</i>.
     * </p>
     * <p>
     * If you created a CNAME resource record set, either with Amazon Route 53 or with another DNS service, you don't
     * need to make any changes. A CNAME record will route traffic to your distribution regardless of the IP address
     * format of the viewer request.
     * </p>
     * 
     * @return If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution,
     *         specify <code>true</code>. If you specify <code>false</code>, CloudFront responds to IPv6 DNS requests
     *         with the DNS response code <code>NOERROR</code> and with no IP addresses. This allows viewers to submit a
     *         second request, for an IPv4 address for your distribution. </p>
     *         <p>
     *         In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content.
     *         However, if you're using signed URLs or signed cookies to restrict access to your content, and if you're
     *         using a custom policy that includes the <code>IpAddress</code> parameter to restrict the IP addresses
     *         that can access your content, don't enable IPv6. If you want to restrict access to some content by IP
     *         address and not restrict access to other content (or restrict access but not by IP address), you can
     *         create two distributions. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html"
     *         >Creating a Signed URL Using a Custom Policy</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         If you're using an Amazon Route 53 alias resource record set to route traffic to your CloudFront
     *         distribution, you need to create a second alias resource record set when both of the following are true:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You enable IPv6 for the distribution
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You're using alternate domain names in the URLs for your objects
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html"
     *         >Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name</a> in the <i>Amazon
     *         Route 53 Developer Guide</i>.
     *         </p>
     *         <p>
     *         If you created a CNAME resource record set, either with Amazon Route 53 or with another DNS service, you
     *         don't need to make any changes. A CNAME record will route traffic to your distribution regardless of the
     *         IP address format of the viewer request.
     */
    public Boolean isIPV6Enabled() {
        return isIPV6Enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(aliases());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRootObject());
        hashCode = 31 * hashCode + Objects.hashCode(origins());
        hashCode = 31 * hashCode + Objects.hashCode(defaultCacheBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(cacheBehaviors());
        hashCode = 31 * hashCode + Objects.hashCode(customErrorResponses());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(logging());
        hashCode = 31 * hashCode + Objects.hashCode(priceClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(viewerCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(restrictions());
        hashCode = 31 * hashCode + Objects.hashCode(webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(httpVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isIPV6Enabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionConfig)) {
            return false;
        }
        DistributionConfig other = (DistributionConfig) obj;
        return Objects.equals(callerReference(), other.callerReference()) && Objects.equals(aliases(), other.aliases())
                && Objects.equals(defaultRootObject(), other.defaultRootObject()) && Objects.equals(origins(), other.origins())
                && Objects.equals(defaultCacheBehavior(), other.defaultCacheBehavior())
                && Objects.equals(cacheBehaviors(), other.cacheBehaviors())
                && Objects.equals(customErrorResponses(), other.customErrorResponses())
                && Objects.equals(comment(), other.comment()) && Objects.equals(logging(), other.logging())
                && Objects.equals(priceClassAsString(), other.priceClassAsString()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(viewerCertificate(), other.viewerCertificate())
                && Objects.equals(restrictions(), other.restrictions()) && Objects.equals(webACLId(), other.webACLId())
                && Objects.equals(httpVersionAsString(), other.httpVersionAsString())
                && Objects.equals(isIPV6Enabled(), other.isIPV6Enabled());
    }

    @Override
    public String toString() {
        return ToString.builder("DistributionConfig").add("CallerReference", callerReference()).add("Aliases", aliases())
                .add("DefaultRootObject", defaultRootObject()).add("Origins", origins())
                .add("DefaultCacheBehavior", defaultCacheBehavior()).add("CacheBehaviors", cacheBehaviors())
                .add("CustomErrorResponses", customErrorResponses()).add("Comment", comment()).add("Logging", logging())
                .add("PriceClass", priceClassAsString()).add("Enabled", enabled()).add("ViewerCertificate", viewerCertificate())
                .add("Restrictions", restrictions()).add("WebACLId", webACLId()).add("HttpVersion", httpVersionAsString())
                .add("IsIPV6Enabled", isIPV6Enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallerReference":
            return Optional.of(clazz.cast(callerReference()));
        case "Aliases":
            return Optional.of(clazz.cast(aliases()));
        case "DefaultRootObject":
            return Optional.of(clazz.cast(defaultRootObject()));
        case "Origins":
            return Optional.of(clazz.cast(origins()));
        case "DefaultCacheBehavior":
            return Optional.of(clazz.cast(defaultCacheBehavior()));
        case "CacheBehaviors":
            return Optional.of(clazz.cast(cacheBehaviors()));
        case "CustomErrorResponses":
            return Optional.of(clazz.cast(customErrorResponses()));
        case "Comment":
            return Optional.of(clazz.cast(comment()));
        case "Logging":
            return Optional.of(clazz.cast(logging()));
        case "PriceClass":
            return Optional.of(clazz.cast(priceClassAsString()));
        case "Enabled":
            return Optional.of(clazz.cast(enabled()));
        case "ViewerCertificate":
            return Optional.of(clazz.cast(viewerCertificate()));
        case "Restrictions":
            return Optional.of(clazz.cast(restrictions()));
        case "WebACLId":
            return Optional.of(clazz.cast(webACLId()));
        case "HttpVersion":
            return Optional.of(clazz.cast(httpVersionAsString()));
        case "IsIPV6Enabled":
            return Optional.of(clazz.cast(isIPV6Enabled()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DistributionConfig> {
        /**
         * <p>
         * A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.
         * </p>
         * <p>
         * If the value of <code>CallerReference</code> is new (regardless of the content of the
         * <code>DistributionConfig</code> object), CloudFront creates a new distribution.
         * </p>
         * <p>
         * If <code>CallerReference</code> is a value you already sent in a previous request to create a distribution,
         * and if the content of the <code>DistributionConfig</code> is identical to the original request (ignoring
         * white space), CloudFront returns the same the response that it returned to the original request.
         * </p>
         * <p>
         * If <code>CallerReference</code> is a value you already sent in a previous request to create a distribution
         * but the content of the <code>DistributionConfig</code> is different from the original request, CloudFront
         * returns a <code>DistributionAlreadyExists</code> error.
         * </p>
         * 
         * @param callerReference
         *        A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.</p>
         *        <p>
         *        If the value of <code>CallerReference</code> is new (regardless of the content of the
         *        <code>DistributionConfig</code> object), CloudFront creates a new distribution.
         *        </p>
         *        <p>
         *        If <code>CallerReference</code> is a value you already sent in a previous request to create a
         *        distribution, and if the content of the <code>DistributionConfig</code> is identical to the original
         *        request (ignoring white space), CloudFront returns the same the response that it returned to the
         *        original request.
         *        </p>
         *        <p>
         *        If <code>CallerReference</code> is a value you already sent in a previous request to create a
         *        distribution but the content of the <code>DistributionConfig</code> is different from the original
         *        request, CloudFront returns a <code>DistributionAlreadyExists</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         * distribution.
         * </p>
         * 
         * @param aliases
         *        A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         *        distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(Aliases aliases);

        /**
         * <p>
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         * distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link Aliases.Builder} avoiding the need to create one
         * manually via {@link Aliases#builder()}.
         *
         * When the {@link Consumer} completes, {@link Aliases.Builder#build()} is called immediately and its result is
         * passed to {@link #aliases(Aliases)}.
         * 
         * @param aliases
         *        a consumer that will call methods on {@link Aliases.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aliases(Aliases)
         */
        default Builder aliases(Consumer<Aliases.Builder> aliases) {
            return aliases(Aliases.builder().apply(aliases).build());
        }

        /**
         * <p>
         * The object that you want CloudFront to request from your origin (for example, <code>index.html</code>) when a
         * viewer requests the root URL for your distribution (<code>http://www.example.com</code>) instead of an object
         * in your distribution (<code>http://www.example.com/product-description.html</code>). Specifying a default
         * root object avoids exposing the contents of your distribution.
         * </p>
         * <p>
         * Specify only the object name, for example, <code>index.html</code>. Don't add a <code>/</code> before the
         * object name.
         * </p>
         * <p>
         * If you don't want to specify a default root object when you create a distribution, include an empty
         * <code>DefaultRootObject</code> element.
         * </p>
         * <p>
         * To delete the default root object from an existing distribution, update the distribution configuration and
         * include an empty <code>DefaultRootObject</code> element.
         * </p>
         * <p>
         * To replace the default root object, update the distribution configuration and specify the new object.
         * </p>
         * <p>
         * For more information about the default root object, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html">Creating a
         * Default Root Object</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param defaultRootObject
         *        The object that you want CloudFront to request from your origin (for example, <code>index.html</code>)
         *        when a viewer requests the root URL for your distribution (<code>http://www.example.com</code>)
         *        instead of an object in your distribution (
         *        <code>http://www.example.com/product-description.html</code>). Specifying a default root object avoids
         *        exposing the contents of your distribution.</p>
         *        <p>
         *        Specify only the object name, for example, <code>index.html</code>. Don't add a <code>/</code> before
         *        the object name.
         *        </p>
         *        <p>
         *        If you don't want to specify a default root object when you create a distribution, include an empty
         *        <code>DefaultRootObject</code> element.
         *        </p>
         *        <p>
         *        To delete the default root object from an existing distribution, update the distribution configuration
         *        and include an empty <code>DefaultRootObject</code> element.
         *        </p>
         *        <p>
         *        To replace the default root object, update the distribution configuration and specify the new object.
         *        </p>
         *        <p>
         *        For more information about the default root object, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html"
         *        >Creating a Default Root Object</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRootObject(String defaultRootObject);

        /**
         * <p>
         * A complex type that contains information about origins for this distribution.
         * </p>
         * 
         * @param origins
         *        A complex type that contains information about origins for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origins(Origins origins);

        /**
         * <p>
         * A complex type that contains information about origins for this distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link Origins.Builder} avoiding the need to create one
         * manually via {@link Origins#builder()}.
         *
         * When the {@link Consumer} completes, {@link Origins.Builder#build()} is called immediately and its result is
         * passed to {@link #origins(Origins)}.
         * 
         * @param origins
         *        a consumer that will call methods on {@link Origins.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #origins(Origins)
         */
        default Builder origins(Consumer<Origins.Builder> origins) {
            return origins(Origins.builder().apply(origins).build());
        }

        /**
         * <p>
         * A complex type that describes the default cache behavior if you don't specify a <code>CacheBehavior</code>
         * element or if files don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code>
         * elements. You must create exactly one default cache behavior.
         * </p>
         * 
         * @param defaultCacheBehavior
         *        A complex type that describes the default cache behavior if you don't specify a
         *        <code>CacheBehavior</code> element or if files don't match any of the values of
         *        <code>PathPattern</code> in <code>CacheBehavior</code> elements. You must create exactly one default
         *        cache behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCacheBehavior(DefaultCacheBehavior defaultCacheBehavior);

        /**
         * <p>
         * A complex type that describes the default cache behavior if you don't specify a <code>CacheBehavior</code>
         * element or if files don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code>
         * elements. You must create exactly one default cache behavior.
         * </p>
         * This is a convenience that creates an instance of the {@link DefaultCacheBehavior.Builder} avoiding the need
         * to create one manually via {@link DefaultCacheBehavior#builder()}.
         *
         * When the {@link Consumer} completes, {@link DefaultCacheBehavior.Builder#build()} is called immediately and
         * its result is passed to {@link #defaultCacheBehavior(DefaultCacheBehavior)}.
         * 
         * @param defaultCacheBehavior
         *        a consumer that will call methods on {@link DefaultCacheBehavior.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultCacheBehavior(DefaultCacheBehavior)
         */
        default Builder defaultCacheBehavior(Consumer<DefaultCacheBehavior.Builder> defaultCacheBehavior) {
            return defaultCacheBehavior(DefaultCacheBehavior.builder().apply(defaultCacheBehavior).build());
        }

        /**
         * <p>
         * A complex type that contains zero or more <code>CacheBehavior</code> elements.
         * </p>
         * 
         * @param cacheBehaviors
         *        A complex type that contains zero or more <code>CacheBehavior</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheBehaviors(CacheBehaviors cacheBehaviors);

        /**
         * <p>
         * A complex type that contains zero or more <code>CacheBehavior</code> elements.
         * </p>
         * This is a convenience that creates an instance of the {@link CacheBehaviors.Builder} avoiding the need to
         * create one manually via {@link CacheBehaviors#builder()}.
         *
         * When the {@link Consumer} completes, {@link CacheBehaviors.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheBehaviors(CacheBehaviors)}.
         * 
         * @param cacheBehaviors
         *        a consumer that will call methods on {@link CacheBehaviors.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheBehaviors(CacheBehaviors)
         */
        default Builder cacheBehaviors(Consumer<CacheBehaviors.Builder> cacheBehaviors) {
            return cacheBehaviors(CacheBehaviors.builder().apply(cacheBehaviors).build());
        }

        /**
         * <p>
         * A complex type that controls the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before
         * returning the response to the viewer.
         * </p>
         * </li>
         * <li>
         * <p>
         * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about custom error pages, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing
         * Error Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param customErrorResponses
         *        A complex type that controls the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages
         *        before returning the response to the viewer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about custom error pages, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html"
         *        >Customizing Error Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customErrorResponses(CustomErrorResponses customErrorResponses);

        /**
         * <p>
         * A complex type that controls the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before
         * returning the response to the viewer.
         * </p>
         * </li>
         * <li>
         * <p>
         * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about custom error pages, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing
         * Error Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomErrorResponses.Builder} avoiding the need
         * to create one manually via {@link CustomErrorResponses#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomErrorResponses.Builder#build()} is called immediately and
         * its result is passed to {@link #customErrorResponses(CustomErrorResponses)}.
         * 
         * @param customErrorResponses
         *        a consumer that will call methods on {@link CustomErrorResponses.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customErrorResponses(CustomErrorResponses)
         */
        default Builder customErrorResponses(Consumer<CustomErrorResponses.Builder> customErrorResponses) {
            return customErrorResponses(CustomErrorResponses.builder().apply(customErrorResponses).build());
        }

        /**
         * <p>
         * Any comments you want to include about the distribution.
         * </p>
         * <p>
         * If you don't want to specify a comment, include an empty <code>Comment</code> element.
         * </p>
         * <p>
         * To delete an existing comment, update the distribution configuration and include an empty
         * <code>Comment</code> element.
         * </p>
         * <p>
         * To add or change a comment, update the distribution configuration and specify the new comment.
         * </p>
         * 
         * @param comment
         *        Any comments you want to include about the distribution.</p>
         *        <p>
         *        If you don't want to specify a comment, include an empty <code>Comment</code> element.
         *        </p>
         *        <p>
         *        To delete an existing comment, update the distribution configuration and include an empty
         *        <code>Comment</code> element.
         *        </p>
         *        <p>
         *        To add or change a comment, update the distribution configuration and specify the new comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * A complex type that controls whether access logs are written for the distribution.
         * </p>
         * <p>
         * For more information about logging, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access Logs</a> in
         * the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param logging
         *        A complex type that controls whether access logs are written for the distribution.</p>
         *        <p>
         *        For more information about logging, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access
         *        Logs</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logging(LoggingConfig logging);

        /**
         * <p>
         * A complex type that controls whether access logs are written for the distribution.
         * </p>
         * <p>
         * For more information about logging, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access Logs</a> in
         * the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link LoggingConfig.Builder} avoiding the need to
         * create one manually via {@link LoggingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoggingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #logging(LoggingConfig)}.
         * 
         * @param logging
         *        a consumer that will call methods on {@link LoggingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logging(LoggingConfig)
         */
        default Builder logging(Consumer<LoggingConfig.Builder> logging) {
            return logging(LoggingConfig.builder().apply(logging).build());
        }

        /**
         * <p>
         * The price class that corresponds with the maximum price that you want to pay for CloudFront service. If you
         * specify <code>PriceClass_All</code>, CloudFront responds to requests for your objects from all CloudFront
         * edge locations.
         * </p>
         * <p>
         * If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your objects from the
         * CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers
         * who are in or near regions that are excluded from your specified price class may encounter slower
         * performance.
         * </p>
         * <p>
         * For more information about price classes, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the Price
         * Class for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For information
         * about CloudFront pricing, including how price classes map to CloudFront regions, see <a
         * href="https://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront Pricing</a>.
         * </p>
         * 
         * @param priceClass
         *        The price class that corresponds with the maximum price that you want to pay for CloudFront service.
         *        If you specify <code>PriceClass_All</code>, CloudFront responds to requests for your objects from all
         *        CloudFront edge locations.</p>
         *        <p>
         *        If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your objects
         *        from the CloudFront edge location that has the lowest latency among the edge locations in your price
         *        class. Viewers who are in or near regions that are excluded from your specified price class may
         *        encounter slower performance.
         *        </p>
         *        <p>
         *        For more information about price classes, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the
         *        Price Class for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For
         *        information about CloudFront pricing, including how price classes map to CloudFront regions, see <a
         *        href="https://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront Pricing</a>.
         * @see PriceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(String priceClass);

        /**
         * <p>
         * The price class that corresponds with the maximum price that you want to pay for CloudFront service. If you
         * specify <code>PriceClass_All</code>, CloudFront responds to requests for your objects from all CloudFront
         * edge locations.
         * </p>
         * <p>
         * If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your objects from the
         * CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers
         * who are in or near regions that are excluded from your specified price class may encounter slower
         * performance.
         * </p>
         * <p>
         * For more information about price classes, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the Price
         * Class for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For information
         * about CloudFront pricing, including how price classes map to CloudFront regions, see <a
         * href="https://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront Pricing</a>.
         * </p>
         * 
         * @param priceClass
         *        The price class that corresponds with the maximum price that you want to pay for CloudFront service.
         *        If you specify <code>PriceClass_All</code>, CloudFront responds to requests for your objects from all
         *        CloudFront edge locations.</p>
         *        <p>
         *        If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your objects
         *        from the CloudFront edge location that has the lowest latency among the edge locations in your price
         *        class. Viewers who are in or near regions that are excluded from your specified price class may
         *        encounter slower performance.
         *        </p>
         *        <p>
         *        For more information about price classes, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the
         *        Price Class for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For
         *        information about CloudFront pricing, including how price classes map to CloudFront regions, see <a
         *        href="https://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront Pricing</a>.
         * @see PriceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(PriceClass priceClass);

        /**
         * <p>
         * From this field, you can enable or disable the selected distribution.
         * </p>
         * <p>
         * If you specify <code>false</code> for <code>Enabled</code> but you specify values for <code>Bucket</code> and
         * <code>Prefix</code>, the values are automatically deleted.
         * </p>
         * 
         * @param enabled
         *        From this field, you can enable or disable the selected distribution.</p>
         *        <p>
         *        If you specify <code>false</code> for <code>Enabled</code> but you specify values for
         *        <code>Bucket</code> and <code>Prefix</code>, the values are automatically deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * Sets the value of the ViewerCertificate property for this object.
         *
         * @param viewerCertificate
         *        The new value for the ViewerCertificate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewerCertificate(ViewerCertificate viewerCertificate);

        /**
         * Sets the value of the ViewerCertificate property for this object.
         *
         * This is a convenience that creates an instance of the {@link ViewerCertificate.Builder} avoiding the need to
         * create one manually via {@link ViewerCertificate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ViewerCertificate.Builder#build()} is called immediately and its
         * result is passed to {@link #viewerCertificate(ViewerCertificate)}.
         * 
         * @param viewerCertificate
         *        a consumer that will call methods on {@link ViewerCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #viewerCertificate(ViewerCertificate)
         */
        default Builder viewerCertificate(Consumer<ViewerCertificate.Builder> viewerCertificate) {
            return viewerCertificate(ViewerCertificate.builder().apply(viewerCertificate).build());
        }

        /**
         * Sets the value of the Restrictions property for this object.
         *
         * @param restrictions
         *        The new value for the Restrictions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictions(Restrictions restrictions);

        /**
         * Sets the value of the Restrictions property for this object.
         *
         * This is a convenience that creates an instance of the {@link Restrictions.Builder} avoiding the need to
         * create one manually via {@link Restrictions#builder()}.
         *
         * When the {@link Consumer} completes, {@link Restrictions.Builder#build()} is called immediately and its
         * result is passed to {@link #restrictions(Restrictions)}.
         * 
         * @param restrictions
         *        a consumer that will call methods on {@link Restrictions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restrictions(Restrictions)
         */
        default Builder restrictions(Consumer<Restrictions.Builder> restrictions) {
            return restrictions(Restrictions.builder().apply(restrictions).build());
        }

        /**
         * <p>
         * A unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution.
         * </p>
         * <p>
         * AWS WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to
         * CloudFront, and lets you control access to your content. Based on conditions that you specify, such as the IP
         * addresses that requests originate from or the values of query strings, CloudFront responds to requests either
         * with the requested content or with an HTTP 403 status code (Forbidden). You can also configure CloudFront to
         * return a custom error page when a request is blocked. For more information about AWS WAF, see the <a
         * href="http://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">AWS WAF Developer Guide</a>.
         * </p>
         * 
         * @param webACLId
         *        A unique identifier that specifies the AWS WAF web ACL, if any, to associate with this
         *        distribution.</p>
         *        <p>
         *        AWS WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are
         *        forwarded to CloudFront, and lets you control access to your content. Based on conditions that you
         *        specify, such as the IP addresses that requests originate from or the values of query strings,
         *        CloudFront responds to requests either with the requested content or with an HTTP 403 status code
         *        (Forbidden). You can also configure CloudFront to return a custom error page when a request is
         *        blocked. For more information about AWS WAF, see the <a
         *        href="http://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">AWS WAF Developer
         *        Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLId(String webACLId);

        /**
         * <p>
         * (Optional) Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The
         * default value for new web distributions is http2. Viewers that don't support HTTP/2 automatically use an
         * earlier HTTP version.
         * </p>
         * <p>
         * For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must support Server Name
         * Identification (SNI).
         * </p>
         * <p>
         * In general, configuring CloudFront to communicate with viewers using HTTP/2 reduces latency. You can improve
         * performance by optimizing for HTTP/2. For more information, do an Internet search for "http/2 optimization."
         * </p>
         * 
         * @param httpVersion
         *        (Optional) Specify the maximum HTTP version that you want viewers to use to communicate with
         *        CloudFront. The default value for new web distributions is http2. Viewers that don't support HTTP/2
         *        automatically use an earlier HTTP version.</p>
         *        <p>
         *        For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must support
         *        Server Name Identification (SNI).
         *        </p>
         *        <p>
         *        In general, configuring CloudFront to communicate with viewers using HTTP/2 reduces latency. You can
         *        improve performance by optimizing for HTTP/2. For more information, do an Internet search for
         *        "http/2 optimization."
         * @see HttpVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpVersion
         */
        Builder httpVersion(String httpVersion);

        /**
         * <p>
         * (Optional) Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The
         * default value for new web distributions is http2. Viewers that don't support HTTP/2 automatically use an
         * earlier HTTP version.
         * </p>
         * <p>
         * For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must support Server Name
         * Identification (SNI).
         * </p>
         * <p>
         * In general, configuring CloudFront to communicate with viewers using HTTP/2 reduces latency. You can improve
         * performance by optimizing for HTTP/2. For more information, do an Internet search for "http/2 optimization."
         * </p>
         * 
         * @param httpVersion
         *        (Optional) Specify the maximum HTTP version that you want viewers to use to communicate with
         *        CloudFront. The default value for new web distributions is http2. Viewers that don't support HTTP/2
         *        automatically use an earlier HTTP version.</p>
         *        <p>
         *        For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must support
         *        Server Name Identification (SNI).
         *        </p>
         *        <p>
         *        In general, configuring CloudFront to communicate with viewers using HTTP/2 reduces latency. You can
         *        improve performance by optimizing for HTTP/2. For more information, do an Internet search for
         *        "http/2 optimization."
         * @see HttpVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpVersion
         */
        Builder httpVersion(HttpVersion httpVersion);

        /**
         * <p>
         * If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution, specify
         * <code>true</code>. If you specify <code>false</code>, CloudFront responds to IPv6 DNS requests with the DNS
         * response code <code>NOERROR</code> and with no IP addresses. This allows viewers to submit a second request,
         * for an IPv4 address for your distribution.
         * </p>
         * <p>
         * In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content.
         * However, if you're using signed URLs or signed cookies to restrict access to your content, and if you're
         * using a custom policy that includes the <code>IpAddress</code> parameter to restrict the IP addresses that
         * can access your content, don't enable IPv6. If you want to restrict access to some content by IP address and
         * not restrict access to other content (or restrict access but not by IP address), you can create two
         * distributions. For more information, see <a href=
         * "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html"
         * >Creating a Signed URL Using a Custom Policy</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you're using an Amazon Route 53 alias resource record set to route traffic to your CloudFront
         * distribution, you need to create a second alias resource record set when both of the following are true:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You enable IPv6 for the distribution
         * </p>
         * </li>
         * <li>
         * <p>
         * You're using alternate domain names in the URLs for your objects
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html"
         * >Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name</a> in the <i>Amazon
         * Route 53 Developer Guide</i>.
         * </p>
         * <p>
         * If you created a CNAME resource record set, either with Amazon Route 53 or with another DNS service, you
         * don't need to make any changes. A CNAME record will route traffic to your distribution regardless of the IP
         * address format of the viewer request.
         * </p>
         * 
         * @param isIPV6Enabled
         *        If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution,
         *        specify <code>true</code>. If you specify <code>false</code>, CloudFront responds to IPv6 DNS requests
         *        with the DNS response code <code>NOERROR</code> and with no IP addresses. This allows viewers to
         *        submit a second request, for an IPv4 address for your distribution. </p>
         *        <p>
         *        In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content.
         *        However, if you're using signed URLs or signed cookies to restrict access to your content, and if
         *        you're using a custom policy that includes the <code>IpAddress</code> parameter to restrict the IP
         *        addresses that can access your content, don't enable IPv6. If you want to restrict access to some
         *        content by IP address and not restrict access to other content (or restrict access but not by IP
         *        address), you can create two distributions. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html"
         *        >Creating a Signed URL Using a Custom Policy</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        If you're using an Amazon Route 53 alias resource record set to route traffic to your CloudFront
         *        distribution, you need to create a second alias resource record set when both of the following are
         *        true:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You enable IPv6 for the distribution
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You're using alternate domain names in the URLs for your objects
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html"
         *        >Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name</a> in the
         *        <i>Amazon Route 53 Developer Guide</i>.
         *        </p>
         *        <p>
         *        If you created a CNAME resource record set, either with Amazon Route 53 or with another DNS service,
         *        you don't need to make any changes. A CNAME record will route traffic to your distribution regardless
         *        of the IP address format of the viewer request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isIPV6Enabled(Boolean isIPV6Enabled);
    }

    static final class BuilderImpl implements Builder {
        private String callerReference;

        private Aliases aliases;

        private String defaultRootObject;

        private Origins origins;

        private DefaultCacheBehavior defaultCacheBehavior;

        private CacheBehaviors cacheBehaviors;

        private CustomErrorResponses customErrorResponses;

        private String comment;

        private LoggingConfig logging;

        private String priceClass;

        private Boolean enabled;

        private ViewerCertificate viewerCertificate;

        private Restrictions restrictions;

        private String webACLId;

        private String httpVersion;

        private Boolean isIPV6Enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionConfig model) {
            callerReference(model.callerReference);
            aliases(model.aliases);
            defaultRootObject(model.defaultRootObject);
            origins(model.origins);
            defaultCacheBehavior(model.defaultCacheBehavior);
            cacheBehaviors(model.cacheBehaviors);
            customErrorResponses(model.customErrorResponses);
            comment(model.comment);
            logging(model.logging);
            priceClass(model.priceClass);
            enabled(model.enabled);
            viewerCertificate(model.viewerCertificate);
            restrictions(model.restrictions);
            webACLId(model.webACLId);
            httpVersion(model.httpVersion);
            isIPV6Enabled(model.isIPV6Enabled);
        }

        public final String getCallerReference() {
            return callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final Aliases.Builder getAliases() {
            return aliases != null ? aliases.toBuilder() : null;
        }

        @Override
        public final Builder aliases(Aliases aliases) {
            this.aliases = aliases;
            return this;
        }

        public final void setAliases(Aliases.BuilderImpl aliases) {
            this.aliases = aliases != null ? aliases.build() : null;
        }

        public final String getDefaultRootObject() {
            return defaultRootObject;
        }

        @Override
        public final Builder defaultRootObject(String defaultRootObject) {
            this.defaultRootObject = defaultRootObject;
            return this;
        }

        public final void setDefaultRootObject(String defaultRootObject) {
            this.defaultRootObject = defaultRootObject;
        }

        public final Origins.Builder getOrigins() {
            return origins != null ? origins.toBuilder() : null;
        }

        @Override
        public final Builder origins(Origins origins) {
            this.origins = origins;
            return this;
        }

        public final void setOrigins(Origins.BuilderImpl origins) {
            this.origins = origins != null ? origins.build() : null;
        }

        public final DefaultCacheBehavior.Builder getDefaultCacheBehavior() {
            return defaultCacheBehavior != null ? defaultCacheBehavior.toBuilder() : null;
        }

        @Override
        public final Builder defaultCacheBehavior(DefaultCacheBehavior defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
            return this;
        }

        public final void setDefaultCacheBehavior(DefaultCacheBehavior.BuilderImpl defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior != null ? defaultCacheBehavior.build() : null;
        }

        public final CacheBehaviors.Builder getCacheBehaviors() {
            return cacheBehaviors != null ? cacheBehaviors.toBuilder() : null;
        }

        @Override
        public final Builder cacheBehaviors(CacheBehaviors cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors;
            return this;
        }

        public final void setCacheBehaviors(CacheBehaviors.BuilderImpl cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors != null ? cacheBehaviors.build() : null;
        }

        public final CustomErrorResponses.Builder getCustomErrorResponses() {
            return customErrorResponses != null ? customErrorResponses.toBuilder() : null;
        }

        @Override
        public final Builder customErrorResponses(CustomErrorResponses customErrorResponses) {
            this.customErrorResponses = customErrorResponses;
            return this;
        }

        public final void setCustomErrorResponses(CustomErrorResponses.BuilderImpl customErrorResponses) {
            this.customErrorResponses = customErrorResponses != null ? customErrorResponses.build() : null;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final LoggingConfig.Builder getLogging() {
            return logging != null ? logging.toBuilder() : null;
        }

        @Override
        public final Builder logging(LoggingConfig logging) {
            this.logging = logging;
            return this;
        }

        public final void setLogging(LoggingConfig.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        public final String getPriceClass() {
            return priceClass;
        }

        @Override
        public final Builder priceClass(String priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        @Override
        public final Builder priceClass(PriceClass priceClass) {
            this.priceClass(priceClass.toString());
            return this;
        }

        public final void setPriceClass(String priceClass) {
            this.priceClass = priceClass;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final ViewerCertificate.Builder getViewerCertificate() {
            return viewerCertificate != null ? viewerCertificate.toBuilder() : null;
        }

        @Override
        public final Builder viewerCertificate(ViewerCertificate viewerCertificate) {
            this.viewerCertificate = viewerCertificate;
            return this;
        }

        public final void setViewerCertificate(ViewerCertificate.BuilderImpl viewerCertificate) {
            this.viewerCertificate = viewerCertificate != null ? viewerCertificate.build() : null;
        }

        public final Restrictions.Builder getRestrictions() {
            return restrictions != null ? restrictions.toBuilder() : null;
        }

        @Override
        public final Builder restrictions(Restrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public final void setRestrictions(Restrictions.BuilderImpl restrictions) {
            this.restrictions = restrictions != null ? restrictions.build() : null;
        }

        public final String getWebACLId() {
            return webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        public final String getHttpVersion() {
            return httpVersion;
        }

        @Override
        public final Builder httpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        @Override
        public final Builder httpVersion(HttpVersion httpVersion) {
            this.httpVersion(httpVersion.toString());
            return this;
        }

        public final void setHttpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
        }

        public final Boolean getIsIPV6Enabled() {
            return isIPV6Enabled;
        }

        @Override
        public final Builder isIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
            return this;
        }

        public final void setIsIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
        }

        @Override
        public DistributionConfig build() {
            return new DistributionConfig(this);
        }
    }
}
