/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that controls:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning
 * the response to the viewer.
 * </p>
 * </li>
 * <li>
 * <p>
 * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information about custom error pages, see <a
 * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error
 * Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CustomErrorResponses implements ToCopyableBuilder<CustomErrorResponses.Builder, CustomErrorResponses> {
    private final Integer quantity;

    private final List<CustomErrorResponse> items;

    private CustomErrorResponses(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * The number of HTTP status codes for which you want to specify a custom error page and/or a caching duration. If
     * <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
     * </p>
     * 
     * @return The number of HTTP status codes for which you want to specify a custom error page and/or a caching
     *         duration. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * A complex type that contains a <code>CustomErrorResponse</code> element for each HTTP status code for which you
     * want to specify a custom error page and/or a caching duration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains a <code>CustomErrorResponse</code> element for each HTTP status code for
     *         which you want to specify a custom error page and/or a caching duration.
     */
    public List<CustomErrorResponse> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(items());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomErrorResponses)) {
            return false;
        }
        CustomErrorResponses other = (CustomErrorResponses) obj;
        return Objects.equals(quantity(), other.quantity()) && Objects.equals(items(), other.items());
    }

    @Override
    public String toString() {
        return ToString.builder("CustomErrorResponses").add("Quantity", quantity()).add("Items", items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Quantity":
            return Optional.of(clazz.cast(quantity()));
        case "Items":
            return Optional.of(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CustomErrorResponses> {
        /**
         * <p>
         * The number of HTTP status codes for which you want to specify a custom error page and/or a caching duration.
         * If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
         * </p>
         * 
         * @param quantity
         *        The number of HTTP status codes for which you want to specify a custom error page and/or a caching
         *        duration. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * A complex type that contains a <code>CustomErrorResponse</code> element for each HTTP status code for which
         * you want to specify a custom error page and/or a caching duration.
         * </p>
         * 
         * @param items
         *        A complex type that contains a <code>CustomErrorResponse</code> element for each HTTP status code for
         *        which you want to specify a custom error page and/or a caching duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<CustomErrorResponse> items);

        /**
         * <p>
         * A complex type that contains a <code>CustomErrorResponse</code> element for each HTTP status code for which
         * you want to specify a custom error page and/or a caching duration.
         * </p>
         * 
         * @param items
         *        A complex type that contains a <code>CustomErrorResponse</code> element for each HTTP status code for
         *        which you want to specify a custom error page and/or a caching duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(CustomErrorResponse... items);

        /**
         * <p>
         * A complex type that contains a <code>CustomErrorResponse</code> element for each HTTP status code for which
         * you want to specify a custom error page and/or a caching duration.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CustomErrorResponse>.Builder} avoiding the
         * need to create one manually via {@link List<CustomErrorResponse>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomErrorResponse>.Builder#build()} is called immediately
         * and its result is passed to {@link #items(List<CustomErrorResponse>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<CustomErrorResponse>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<CustomErrorResponse>)
         */
        Builder items(Consumer<CustomErrorResponse.Builder>... items);
    }

    static final class BuilderImpl implements Builder {
        private Integer quantity;

        private List<CustomErrorResponse> items;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomErrorResponses model) {
            quantity(model.quantity);
            items(model.items);
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<CustomErrorResponse.Builder> getItems() {
            return items != null ? items.stream().map(CustomErrorResponse::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<CustomErrorResponse> items) {
            this.items = CustomErrorResponseListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(CustomErrorResponse... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<CustomErrorResponse.Builder>... items) {
            items(Stream.of(items).map(c -> CustomErrorResponse.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<CustomErrorResponse.BuilderImpl> items) {
            this.items = CustomErrorResponseListCopier.copyFromBuilder(items);
        }

        @Override
        public CustomErrorResponses build() {
            return new CustomErrorResponses(this);
        }
    }
}
