/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to create a new origin access identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateCloudFrontOriginAccessIdentityRequest extends CloudFrontRequest implements
        ToCopyableBuilder<CreateCloudFrontOriginAccessIdentityRequest.Builder, CreateCloudFrontOriginAccessIdentityRequest> {
    private final CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

    private CreateCloudFrontOriginAccessIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.cloudFrontOriginAccessIdentityConfig = builder.cloudFrontOriginAccessIdentityConfig;
    }

    /**
     * <p>
     * The current configuration information for the identity.
     * </p>
     * 
     * @return The current configuration information for the identity.
     */
    public CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig() {
        return cloudFrontOriginAccessIdentityConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudFrontOriginAccessIdentityConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudFrontOriginAccessIdentityRequest)) {
            return false;
        }
        CreateCloudFrontOriginAccessIdentityRequest other = (CreateCloudFrontOriginAccessIdentityRequest) obj;
        return Objects.equals(cloudFrontOriginAccessIdentityConfig(), other.cloudFrontOriginAccessIdentityConfig());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateCloudFrontOriginAccessIdentityRequest")
                .add("CloudFrontOriginAccessIdentityConfig", cloudFrontOriginAccessIdentityConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudFrontOriginAccessIdentityConfig":
            return Optional.of(clazz.cast(cloudFrontOriginAccessIdentityConfig()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFrontRequest.Builder,
            CopyableBuilder<Builder, CreateCloudFrontOriginAccessIdentityRequest> {
        /**
         * <p>
         * The current configuration information for the identity.
         * </p>
         * 
         * @param cloudFrontOriginAccessIdentityConfig
         *        The current configuration information for the identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig);

        /**
         * <p>
         * The current configuration information for the identity.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudFrontOriginAccessIdentityConfig.Builder}
         * avoiding the need to create one manually via {@link CloudFrontOriginAccessIdentityConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudFrontOriginAccessIdentityConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig)}.
         * 
         * @param cloudFrontOriginAccessIdentityConfig
         *        a consumer that will call methods on {@link CloudFrontOriginAccessIdentityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig)
         */
        default Builder cloudFrontOriginAccessIdentityConfig(
                Consumer<CloudFrontOriginAccessIdentityConfig.Builder> cloudFrontOriginAccessIdentityConfig) {
            return cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig.builder()
                    .apply(cloudFrontOriginAccessIdentityConfig).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudFrontOriginAccessIdentityRequest model) {
            super(model);
            cloudFrontOriginAccessIdentityConfig(model.cloudFrontOriginAccessIdentityConfig);
        }

        public final CloudFrontOriginAccessIdentityConfig.Builder getCloudFrontOriginAccessIdentityConfig() {
            return cloudFrontOriginAccessIdentityConfig != null ? cloudFrontOriginAccessIdentityConfig.toBuilder() : null;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentityConfig(
                CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig;
            return this;
        }

        public final void setCloudFrontOriginAccessIdentityConfig(
                CloudFrontOriginAccessIdentityConfig.BuilderImpl cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig != null ? cloudFrontOriginAccessIdentityConfig
                    .build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateCloudFrontOriginAccessIdentityRequest build() {
            return new CreateCloudFrontOriginAccessIdentityRequest(this);
        }
    }
}
