/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains zero or more <code>CacheBehavior</code> elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CacheBehaviors implements ToCopyableBuilder<CacheBehaviors.Builder, CacheBehaviors> {
    private final Integer quantity;

    private final List<CacheBehavior> items;

    private CacheBehaviors(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * The number of cache behaviors for this distribution.
     * </p>
     * 
     * @return The number of cache behaviors for this distribution.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * Optional: A complex type that contains cache behaviors for this distribution. If <code>Quantity</code> is
     * <code>0</code>, you can omit <code>Items</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Optional: A complex type that contains cache behaviors for this distribution. If <code>Quantity</code> is
     *         <code>0</code>, you can omit <code>Items</code>.
     */
    public List<CacheBehavior> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(items());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheBehaviors)) {
            return false;
        }
        CacheBehaviors other = (CacheBehaviors) obj;
        return Objects.equals(quantity(), other.quantity()) && Objects.equals(items(), other.items());
    }

    @Override
    public String toString() {
        return ToString.builder("CacheBehaviors").add("Quantity", quantity()).add("Items", items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Quantity":
            return Optional.of(clazz.cast(quantity()));
        case "Items":
            return Optional.of(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CacheBehaviors> {
        /**
         * <p>
         * The number of cache behaviors for this distribution.
         * </p>
         * 
         * @param quantity
         *        The number of cache behaviors for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * Optional: A complex type that contains cache behaviors for this distribution. If <code>Quantity</code> is
         * <code>0</code>, you can omit <code>Items</code>.
         * </p>
         * 
         * @param items
         *        Optional: A complex type that contains cache behaviors for this distribution. If <code>Quantity</code>
         *        is <code>0</code>, you can omit <code>Items</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<CacheBehavior> items);

        /**
         * <p>
         * Optional: A complex type that contains cache behaviors for this distribution. If <code>Quantity</code> is
         * <code>0</code>, you can omit <code>Items</code>.
         * </p>
         * 
         * @param items
         *        Optional: A complex type that contains cache behaviors for this distribution. If <code>Quantity</code>
         *        is <code>0</code>, you can omit <code>Items</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(CacheBehavior... items);

        /**
         * <p>
         * Optional: A complex type that contains cache behaviors for this distribution. If <code>Quantity</code> is
         * <code>0</code>, you can omit <code>Items</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CacheBehavior>.Builder} avoiding the need
         * to create one manually via {@link List<CacheBehavior>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CacheBehavior>.Builder#build()} is called immediately and
         * its result is passed to {@link #items(List<CacheBehavior>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<CacheBehavior>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<CacheBehavior>)
         */
        Builder items(Consumer<CacheBehavior.Builder>... items);
    }

    static final class BuilderImpl implements Builder {
        private Integer quantity;

        private List<CacheBehavior> items;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheBehaviors model) {
            quantity(model.quantity);
            items(model.items);
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<CacheBehavior.Builder> getItems() {
            return items != null ? items.stream().map(CacheBehavior::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<CacheBehavior> items) {
            this.items = CacheBehaviorListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(CacheBehavior... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<CacheBehavior.Builder>... items) {
            items(Stream.of(items).map(c -> CacheBehavior.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<CacheBehavior.BuilderImpl> items) {
            this.items = CacheBehaviorListCopier.copyFromBuilder(items);
        }

        @Override
        public CacheBehaviors build() {
            return new CacheBehaviors(this);
        }
    }
}
