/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.Tag;
import software.amazon.awssdk.services.cloudfront.model.Tags;
import software.amazon.awssdk.services.cloudfront.transform.TagUnmarshaller;

public class TagsUnmarshaller
implements Unmarshaller<Tags, StaxUnmarshallerContext> {
    private static TagsUnmarshaller INSTANCE;

    public Tags unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Tags.Builder tags = Tags.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Items", targetDepth)) {
                    tags.items(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("Items/Tag", targetDepth)) continue;
                tags.items(TagUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Tags)tags.build();
    }

    public static TagsUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TagsUnmarshaller();
        }
        return INSTANCE;
    }
}

