/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.QueryStringCacheKeys;

public class QueryStringCacheKeysUnmarshaller
implements Unmarshaller<QueryStringCacheKeys, StaxUnmarshallerContext> {
    private static QueryStringCacheKeysUnmarshaller INSTANCE;

    public QueryStringCacheKeys unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        QueryStringCacheKeys.Builder queryStringCacheKeys = QueryStringCacheKeys.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    queryStringCacheKeys.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    queryStringCacheKeys.items(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Items/Name", targetDepth)) continue;
                queryStringCacheKeys.items(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (QueryStringCacheKeys)queryStringCacheKeys.build();
    }

    public static QueryStringCacheKeysUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new QueryStringCacheKeysUnmarshaller();
        }
        return INSTANCE;
    }
}

