/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.Origin;
import software.amazon.awssdk.services.cloudfront.model.Origins;
import software.amazon.awssdk.services.cloudfront.transform.OriginUnmarshaller;

public class OriginsUnmarshaller
implements Unmarshaller<Origins, StaxUnmarshallerContext> {
    private static OriginsUnmarshaller INSTANCE;

    public Origins unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Origins.Builder origins = Origins.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    origins.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    origins.items(new ArrayList<Origin>());
                    continue;
                }
                if (!context.testExpression("Items/Origin", targetDepth)) continue;
                origins.items(OriginUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Origins)origins.build();
    }

    public static OriginsUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new OriginsUnmarshaller();
        }
        return INSTANCE;
    }
}

