/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListDistributionsRequestMarshaller
implements Marshaller<Request<ListDistributionsRequest>, ListDistributionsRequest> {
    public Request<ListDistributionsRequest> marshall(ListDistributionsRequest listDistributionsRequest) {
        if (listDistributionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listDistributionsRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2017-03-25/distribution";
        request.setResourcePath(uriResourcePath);
        if (listDistributionsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)listDistributionsRequest.marker()));
        }
        if (listDistributionsRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromString((String)listDistributionsRequest.maxItems()));
        }
        return request;
    }
}

