/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.InvalidationList;
import software.amazon.awssdk.services.cloudfront.model.InvalidationSummary;
import software.amazon.awssdk.services.cloudfront.transform.InvalidationSummaryUnmarshaller;

public class InvalidationListUnmarshaller
implements Unmarshaller<InvalidationList, StaxUnmarshallerContext> {
    private static InvalidationListUnmarshaller INSTANCE;

    public InvalidationList unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        InvalidationList.Builder invalidationList = InvalidationList.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Marker", targetDepth)) {
                    invalidationList.marker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NextMarker", targetDepth)) {
                    invalidationList.nextMarker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxItems", targetDepth)) {
                    invalidationList.maxItems(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IsTruncated", targetDepth)) {
                    invalidationList.isTruncated(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Quantity", targetDepth)) {
                    invalidationList.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    invalidationList.items(new ArrayList<InvalidationSummary>());
                    continue;
                }
                if (!context.testExpression("Items/InvalidationSummary", targetDepth)) continue;
                invalidationList.items(InvalidationSummaryUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (InvalidationList)invalidationList.build();
    }

    public static InvalidationListUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InvalidationListUnmarshaller();
        }
        return INSTANCE;
    }
}

