/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.CacheBehavior;
import software.amazon.awssdk.services.cloudfront.transform.AllowedMethodsUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ForwardedValuesUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.LambdaFunctionAssociationsUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TrustedSignersUnmarshaller;

public class CacheBehaviorUnmarshaller
implements Unmarshaller<CacheBehavior, StaxUnmarshallerContext> {
    private static CacheBehaviorUnmarshaller INSTANCE;

    public CacheBehavior unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CacheBehavior.Builder cacheBehavior = CacheBehavior.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("PathPattern", targetDepth)) {
                    cacheBehavior.pathPattern(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TargetOriginId", targetDepth)) {
                    cacheBehavior.targetOriginId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ForwardedValues", targetDepth)) {
                    cacheBehavior.forwardedValues(ForwardedValuesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TrustedSigners", targetDepth)) {
                    cacheBehavior.trustedSigners(TrustedSignersUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ViewerProtocolPolicy", targetDepth)) {
                    cacheBehavior.viewerProtocolPolicy(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MinTTL", targetDepth)) {
                    cacheBehavior.minTTL(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AllowedMethods", targetDepth)) {
                    cacheBehavior.allowedMethods(AllowedMethodsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SmoothStreaming", targetDepth)) {
                    cacheBehavior.smoothStreaming(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DefaultTTL", targetDepth)) {
                    cacheBehavior.defaultTTL(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxTTL", targetDepth)) {
                    cacheBehavior.maxTTL(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Compress", targetDepth)) {
                    cacheBehavior.compress(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("LambdaFunctionAssociations", targetDepth)) continue;
                cacheBehavior.lambdaFunctionAssociations(LambdaFunctionAssociationsUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CacheBehavior)cacheBehavior.build();
    }

    public static CacheBehaviorUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CacheBehaviorUnmarshaller();
        }
        return INSTANCE;
    }
}

