/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.waiters;

import javax.annotation.Generated;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.model.*;
import software.amazon.awssdk.waiters.*;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CloudFrontClientWaiters {

    /**
     * Represents the service client
     */
    private final CloudFrontClient client;

    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    /**
     * Constructs a new CloudFrontClientWaiters with the given client
     * 
     * @param client
     *        Service client
     */
    @SdkInternalApi
    public CloudFrontClientWaiters(CloudFrontClient client) {
        this.client = client;
    }

    /**
     * Builds a DistributionDeployed waiter by using custom parameters waiterParameters and other parameters defined in
     * the waiters specification, and then polls until it determines whether the resource entered the desired state or
     * not, where polling criteria is bound by either default polling strategy or custom polling strategy.
     */
    public Waiter<GetDistributionRequest> distributionDeployed() {

        return new WaiterBuilder<GetDistributionRequest, GetDistributionResponse>()
                .withSdkFunction(new GetDistributionFunction(client)).withAcceptors(new DistributionDeployed.IsDeployedMatcher())
                .withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(25), new FixedDelayStrategy(60)))
                .withExecutorService(executorService).build();
    }

    /**
     * Builds a StreamingDistributionDeployed waiter by using custom parameters waiterParameters and other parameters
     * defined in the waiters specification, and then polls until it determines whether the resource entered the desired
     * state or not, where polling criteria is bound by either default polling strategy or custom polling strategy.
     */
    public Waiter<GetStreamingDistributionRequest> streamingDistributionDeployed() {

        return new WaiterBuilder<GetStreamingDistributionRequest, GetStreamingDistributionResponse>()
                .withSdkFunction(new GetStreamingDistributionFunction(client))
                .withAcceptors(new StreamingDistributionDeployed.IsDeployedMatcher())
                .withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(25), new FixedDelayStrategy(60)))
                .withExecutorService(executorService).build();
    }

    /**
     * Builds a InvalidationCompleted waiter by using custom parameters waiterParameters and other parameters defined in
     * the waiters specification, and then polls until it determines whether the resource entered the desired state or
     * not, where polling criteria is bound by either default polling strategy or custom polling strategy.
     */
    public Waiter<GetInvalidationRequest> invalidationCompleted() {

        return new WaiterBuilder<GetInvalidationRequest, GetInvalidationResponse>()
                .withSdkFunction(new GetInvalidationFunction(client))
                .withAcceptors(new InvalidationCompleted.IsCompletedMatcher())
                .withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(30), new FixedDelayStrategy(20)))
                .withExecutorService(executorService).build();
    }

}
