/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.transform;

import static software.amazon.awssdk.util.StringUtils.UTF8;

import java.io.StringWriter;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.cloudfront.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;

import software.amazon.awssdk.util.XmlWriter;

/**
 * UpdateDistributionRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateDistributionRequestMarshaller implements
        Marshaller<Request<UpdateDistributionRequest>, UpdateDistributionRequest> {

    public Request<UpdateDistributionRequest> marshall(UpdateDistributionRequest updateDistributionRequest) {

        if (updateDistributionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<UpdateDistributionRequest> request = new DefaultRequest<UpdateDistributionRequest>(updateDistributionRequest,
                "CloudFrontClient");

        request.setHttpMethod(HttpMethodName.PUT);

        if (updateDistributionRequest.ifMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString(updateDistributionRequest.ifMatch()));
        }

        String uriResourcePath = "/2017-03-25/distribution/{Id}/config";

        uriResourcePath = software.amazon.awssdk.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id",
                updateDistributionRequest.id());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = null;
            DistributionConfig distributionConfig = updateDistributionRequest.distributionConfig();
            if (distributionConfig != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2017-03-25/");
                xmlWriter.startElement("DistributionConfig");

                if (distributionConfig.callerReference() != null) {
                    xmlWriter.startElement("CallerReference").value(distributionConfig.callerReference()).endElement();
                }

                Aliases aliases = distributionConfig.aliases();
                if (aliases != null) {
                    xmlWriter.startElement("Aliases");

                    if (aliases.quantity() != null) {
                        xmlWriter.startElement("Quantity").value(aliases.quantity()).endElement();
                    }

                    software.amazon.awssdk.runtime.SdkInternalList<String> aliasesItemsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) aliases
                            .items();
                    if (!aliasesItemsList.isEmpty() || !aliasesItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");

                        for (String aliasesItemsListValue : aliasesItemsList) {
                            xmlWriter.startElement("CNAME");
                            xmlWriter.value(aliasesItemsListValue);
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }

                if (distributionConfig.defaultRootObject() != null) {
                    xmlWriter.startElement("DefaultRootObject").value(distributionConfig.defaultRootObject()).endElement();
                }

                Origins origins = distributionConfig.origins();
                if (origins != null) {
                    xmlWriter.startElement("Origins");

                    if (origins.quantity() != null) {
                        xmlWriter.startElement("Quantity").value(origins.quantity()).endElement();
                    }

                    software.amazon.awssdk.runtime.SdkInternalList<Origin> originsItemsList = (software.amazon.awssdk.runtime.SdkInternalList<Origin>) origins
                            .items();
                    if (!originsItemsList.isEmpty() || !originsItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");

                        for (Origin originsItemsListValue : originsItemsList) {
                            xmlWriter.startElement("Origin");

                            if (originsItemsListValue.id() != null) {
                                xmlWriter.startElement("Id").value(originsItemsListValue.id()).endElement();
                            }

                            if (originsItemsListValue.domainName() != null) {
                                xmlWriter.startElement("DomainName").value(originsItemsListValue.domainName()).endElement();
                            }

                            if (originsItemsListValue.originPath() != null) {
                                xmlWriter.startElement("OriginPath").value(originsItemsListValue.originPath()).endElement();
                            }

                            CustomHeaders customHeaders = originsItemsListValue.customHeaders();
                            if (customHeaders != null) {
                                xmlWriter.startElement("CustomHeaders");

                                if (customHeaders.quantity() != null) {
                                    xmlWriter.startElement("Quantity").value(customHeaders.quantity()).endElement();
                                }

                                software.amazon.awssdk.runtime.SdkInternalList<OriginCustomHeader> customHeadersItemsList = (software.amazon.awssdk.runtime.SdkInternalList<OriginCustomHeader>) customHeaders
                                        .items();
                                if (!customHeadersItemsList.isEmpty() || !customHeadersItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");

                                    for (OriginCustomHeader customHeadersItemsListValue : customHeadersItemsList) {
                                        xmlWriter.startElement("OriginCustomHeader");

                                        if (customHeadersItemsListValue.headerName() != null) {
                                            xmlWriter.startElement("HeaderName").value(customHeadersItemsListValue.headerName())
                                                    .endElement();
                                        }

                                        if (customHeadersItemsListValue.headerValue() != null) {
                                            xmlWriter.startElement("HeaderValue")
                                                    .value(customHeadersItemsListValue.headerValue()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }

                            S3OriginConfig s3OriginConfig = originsItemsListValue.s3OriginConfig();
                            if (s3OriginConfig != null) {
                                xmlWriter.startElement("S3OriginConfig");

                                if (s3OriginConfig.originAccessIdentity() != null) {
                                    xmlWriter.startElement("OriginAccessIdentity").value(s3OriginConfig.originAccessIdentity())
                                            .endElement();
                                }
                                xmlWriter.endElement();
                            }

                            CustomOriginConfig customOriginConfig = originsItemsListValue.customOriginConfig();
                            if (customOriginConfig != null) {
                                xmlWriter.startElement("CustomOriginConfig");

                                if (customOriginConfig.httpPort() != null) {
                                    xmlWriter.startElement("HTTPPort").value(customOriginConfig.httpPort()).endElement();
                                }

                                if (customOriginConfig.httpsPort() != null) {
                                    xmlWriter.startElement("HTTPSPort").value(customOriginConfig.httpsPort()).endElement();
                                }

                                if (customOriginConfig.originProtocolPolicy() != null) {
                                    xmlWriter.startElement("OriginProtocolPolicy")
                                            .value(customOriginConfig.originProtocolPolicy()).endElement();
                                }

                                OriginSslProtocols originSslProtocols = customOriginConfig.originSslProtocols();
                                if (originSslProtocols != null) {
                                    xmlWriter.startElement("OriginSslProtocols");

                                    if (originSslProtocols.quantity() != null) {
                                        xmlWriter.startElement("Quantity").value(originSslProtocols.quantity()).endElement();
                                    }

                                    software.amazon.awssdk.runtime.SdkInternalList<String> originSslProtocolsItemsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) originSslProtocols
                                            .items();
                                    if (!originSslProtocolsItemsList.isEmpty() || !originSslProtocolsItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");

                                        for (String originSslProtocolsItemsListValue : originSslProtocolsItemsList) {
                                            xmlWriter.startElement("SslProtocol");
                                            xmlWriter.value(originSslProtocolsItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }

                                if (customOriginConfig.originReadTimeout() != null) {
                                    xmlWriter.startElement("OriginReadTimeout").value(customOriginConfig.originReadTimeout())
                                            .endElement();
                                }

                                if (customOriginConfig.originKeepaliveTimeout() != null) {
                                    xmlWriter.startElement("OriginKeepaliveTimeout")
                                            .value(customOriginConfig.originKeepaliveTimeout()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }

                DefaultCacheBehavior defaultCacheBehavior = distributionConfig.defaultCacheBehavior();
                if (defaultCacheBehavior != null) {
                    xmlWriter.startElement("DefaultCacheBehavior");

                    if (defaultCacheBehavior.targetOriginId() != null) {
                        xmlWriter.startElement("TargetOriginId").value(defaultCacheBehavior.targetOriginId()).endElement();
                    }

                    ForwardedValues forwardedValues = defaultCacheBehavior.forwardedValues();
                    if (forwardedValues != null) {
                        xmlWriter.startElement("ForwardedValues");

                        if (forwardedValues.queryString() != null) {
                            xmlWriter.startElement("QueryString").value(forwardedValues.queryString()).endElement();
                        }

                        CookiePreference cookies = forwardedValues.cookies();
                        if (cookies != null) {
                            xmlWriter.startElement("Cookies");

                            if (cookies.forward() != null) {
                                xmlWriter.startElement("Forward").value(cookies.forward()).endElement();
                            }

                            CookieNames whitelistedNames = cookies.whitelistedNames();
                            if (whitelistedNames != null) {
                                xmlWriter.startElement("WhitelistedNames");

                                if (whitelistedNames.quantity() != null) {
                                    xmlWriter.startElement("Quantity").value(whitelistedNames.quantity()).endElement();
                                }

                                software.amazon.awssdk.runtime.SdkInternalList<String> cookieNamesItemsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) whitelistedNames
                                        .items();
                                if (!cookieNamesItemsList.isEmpty() || !cookieNamesItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");

                                    for (String cookieNamesItemsListValue : cookieNamesItemsList) {
                                        xmlWriter.startElement("Name");
                                        xmlWriter.value(cookieNamesItemsListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }

                        Headers headers = forwardedValues.headers();
                        if (headers != null) {
                            xmlWriter.startElement("Headers");

                            if (headers.quantity() != null) {
                                xmlWriter.startElement("Quantity").value(headers.quantity()).endElement();
                            }

                            software.amazon.awssdk.runtime.SdkInternalList<String> headersItemsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) headers
                                    .items();
                            if (!headersItemsList.isEmpty() || !headersItemsList.isAutoConstruct()) {
                                xmlWriter.startElement("Items");

                                for (String headersItemsListValue : headersItemsList) {
                                    xmlWriter.startElement("Name");
                                    xmlWriter.value(headersItemsListValue);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }

                        QueryStringCacheKeys queryStringCacheKeys = forwardedValues.queryStringCacheKeys();
                        if (queryStringCacheKeys != null) {
                            xmlWriter.startElement("QueryStringCacheKeys");

                            if (queryStringCacheKeys.quantity() != null) {
                                xmlWriter.startElement("Quantity").value(queryStringCacheKeys.quantity()).endElement();
                            }

                            software.amazon.awssdk.runtime.SdkInternalList<String> queryStringCacheKeysItemsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) queryStringCacheKeys
                                    .items();
                            if (!queryStringCacheKeysItemsList.isEmpty() || !queryStringCacheKeysItemsList.isAutoConstruct()) {
                                xmlWriter.startElement("Items");

                                for (String queryStringCacheKeysItemsListValue : queryStringCacheKeysItemsList) {
                                    xmlWriter.startElement("Name");
                                    xmlWriter.value(queryStringCacheKeysItemsListValue);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }

                    TrustedSigners trustedSigners = defaultCacheBehavior.trustedSigners();
                    if (trustedSigners != null) {
                        xmlWriter.startElement("TrustedSigners");

                        if (trustedSigners.enabled() != null) {
                            xmlWriter.startElement("Enabled").value(trustedSigners.enabled()).endElement();
                        }

                        if (trustedSigners.quantity() != null) {
                            xmlWriter.startElement("Quantity").value(trustedSigners.quantity()).endElement();
                        }

                        software.amazon.awssdk.runtime.SdkInternalList<String> trustedSignersItemsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) trustedSigners
                                .items();
                        if (!trustedSignersItemsList.isEmpty() || !trustedSignersItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");

                            for (String trustedSignersItemsListValue : trustedSignersItemsList) {
                                xmlWriter.startElement("AwsAccountNumber");
                                xmlWriter.value(trustedSignersItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }

                    if (defaultCacheBehavior.viewerProtocolPolicy() != null) {
                        xmlWriter.startElement("ViewerProtocolPolicy").value(defaultCacheBehavior.viewerProtocolPolicy())
                                .endElement();
                    }

                    if (defaultCacheBehavior.minTTL() != null) {
                        xmlWriter.startElement("MinTTL").value(defaultCacheBehavior.minTTL()).endElement();
                    }

                    AllowedMethods allowedMethods = defaultCacheBehavior.allowedMethods();
                    if (allowedMethods != null) {
                        xmlWriter.startElement("AllowedMethods");

                        if (allowedMethods.quantity() != null) {
                            xmlWriter.startElement("Quantity").value(allowedMethods.quantity()).endElement();
                        }

                        software.amazon.awssdk.runtime.SdkInternalList<String> allowedMethodsItemsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) allowedMethods
                                .items();
                        if (!allowedMethodsItemsList.isEmpty() || !allowedMethodsItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");

                            for (String allowedMethodsItemsListValue : allowedMethodsItemsList) {
                                xmlWriter.startElement("Method");
                                xmlWriter.value(allowedMethodsItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }

                        CachedMethods cachedMethods = allowedMethods.cachedMethods();
                        if (cachedMethods != null) {
                            xmlWriter.startElement("CachedMethods");

                            if (cachedMethods.quantity() != null) {
                                xmlWriter.startElement("Quantity").value(cachedMethods.quantity()).endElement();
                            }

                            software.amazon.awssdk.runtime.SdkInternalList<String> cachedMethodsItemsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) cachedMethods
                                    .items();
                            if (!cachedMethodsItemsList.isEmpty() || !cachedMethodsItemsList.isAutoConstruct()) {
                                xmlWriter.startElement("Items");

                                for (String cachedMethodsItemsListValue : cachedMethodsItemsList) {
                                    xmlWriter.startElement("Method");
                                    xmlWriter.value(cachedMethodsItemsListValue);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }

                    if (defaultCacheBehavior.smoothStreaming() != null) {
                        xmlWriter.startElement("SmoothStreaming").value(defaultCacheBehavior.smoothStreaming()).endElement();
                    }

                    if (defaultCacheBehavior.defaultTTL() != null) {
                        xmlWriter.startElement("DefaultTTL").value(defaultCacheBehavior.defaultTTL()).endElement();
                    }

                    if (defaultCacheBehavior.maxTTL() != null) {
                        xmlWriter.startElement("MaxTTL").value(defaultCacheBehavior.maxTTL()).endElement();
                    }

                    if (defaultCacheBehavior.compress() != null) {
                        xmlWriter.startElement("Compress").value(defaultCacheBehavior.compress()).endElement();
                    }

                    LambdaFunctionAssociations lambdaFunctionAssociations = defaultCacheBehavior.lambdaFunctionAssociations();
                    if (lambdaFunctionAssociations != null) {
                        xmlWriter.startElement("LambdaFunctionAssociations");

                        if (lambdaFunctionAssociations.quantity() != null) {
                            xmlWriter.startElement("Quantity").value(lambdaFunctionAssociations.quantity()).endElement();
                        }

                        software.amazon.awssdk.runtime.SdkInternalList<LambdaFunctionAssociation> lambdaFunctionAssociationsItemsList = (software.amazon.awssdk.runtime.SdkInternalList<LambdaFunctionAssociation>) lambdaFunctionAssociations
                                .items();
                        if (!lambdaFunctionAssociationsItemsList.isEmpty()
                                || !lambdaFunctionAssociationsItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");

                            for (LambdaFunctionAssociation lambdaFunctionAssociationsItemsListValue : lambdaFunctionAssociationsItemsList) {
                                xmlWriter.startElement("LambdaFunctionAssociation");

                                if (lambdaFunctionAssociationsItemsListValue.lambdaFunctionARN() != null) {
                                    xmlWriter.startElement("LambdaFunctionARN")
                                            .value(lambdaFunctionAssociationsItemsListValue.lambdaFunctionARN()).endElement();
                                }

                                if (lambdaFunctionAssociationsItemsListValue.eventType() != null) {
                                    xmlWriter.startElement("EventType")
                                            .value(lambdaFunctionAssociationsItemsListValue.eventType()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }

                CacheBehaviors cacheBehaviors = distributionConfig.cacheBehaviors();
                if (cacheBehaviors != null) {
                    xmlWriter.startElement("CacheBehaviors");

                    if (cacheBehaviors.quantity() != null) {
                        xmlWriter.startElement("Quantity").value(cacheBehaviors.quantity()).endElement();
                    }

                    software.amazon.awssdk.runtime.SdkInternalList<CacheBehavior> cacheBehaviorsItemsList = (software.amazon.awssdk.runtime.SdkInternalList<CacheBehavior>) cacheBehaviors
                            .items();
                    if (!cacheBehaviorsItemsList.isEmpty() || !cacheBehaviorsItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");

                        for (CacheBehavior cacheBehaviorsItemsListValue : cacheBehaviorsItemsList) {
                            xmlWriter.startElement("CacheBehavior");

                            if (cacheBehaviorsItemsListValue.pathPattern() != null) {
                                xmlWriter.startElement("PathPattern").value(cacheBehaviorsItemsListValue.pathPattern())
                                        .endElement();
                            }

                            if (cacheBehaviorsItemsListValue.targetOriginId() != null) {
                                xmlWriter.startElement("TargetOriginId").value(cacheBehaviorsItemsListValue.targetOriginId())
                                        .endElement();
                            }

                            ForwardedValues forwardedValues = cacheBehaviorsItemsListValue.forwardedValues();
                            if (forwardedValues != null) {
                                xmlWriter.startElement("ForwardedValues");

                                if (forwardedValues.queryString() != null) {
                                    xmlWriter.startElement("QueryString").value(forwardedValues.queryString()).endElement();
                                }

                                CookiePreference cookies = forwardedValues.cookies();
                                if (cookies != null) {
                                    xmlWriter.startElement("Cookies");

                                    if (cookies.forward() != null) {
                                        xmlWriter.startElement("Forward").value(cookies.forward()).endElement();
                                    }

                                    CookieNames whitelistedNames = cookies.whitelistedNames();
                                    if (whitelistedNames != null) {
                                        xmlWriter.startElement("WhitelistedNames");

                                        if (whitelistedNames.quantity() != null) {
                                            xmlWriter.startElement("Quantity").value(whitelistedNames.quantity()).endElement();
                                        }

                                        software.amazon.awssdk.runtime.SdkInternalList<String> cookieNamesItemsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) whitelistedNames
                                                .items();
                                        if (!cookieNamesItemsList.isEmpty() || !cookieNamesItemsList.isAutoConstruct()) {
                                            xmlWriter.startElement("Items");

                                            for (String cookieNamesItemsListValue : cookieNamesItemsList) {
                                                xmlWriter.startElement("Name");
                                                xmlWriter.value(cookieNamesItemsListValue);
                                                xmlWriter.endElement();
                                            }
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }

                                Headers headers = forwardedValues.headers();
                                if (headers != null) {
                                    xmlWriter.startElement("Headers");

                                    if (headers.quantity() != null) {
                                        xmlWriter.startElement("Quantity").value(headers.quantity()).endElement();
                                    }

                                    software.amazon.awssdk.runtime.SdkInternalList<String> headersItemsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) headers
                                            .items();
                                    if (!headersItemsList.isEmpty() || !headersItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");

                                        for (String headersItemsListValue : headersItemsList) {
                                            xmlWriter.startElement("Name");
                                            xmlWriter.value(headersItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }

                                QueryStringCacheKeys queryStringCacheKeys = forwardedValues.queryStringCacheKeys();
                                if (queryStringCacheKeys != null) {
                                    xmlWriter.startElement("QueryStringCacheKeys");

                                    if (queryStringCacheKeys.quantity() != null) {
                                        xmlWriter.startElement("Quantity").value(queryStringCacheKeys.quantity()).endElement();
                                    }

                                    software.amazon.awssdk.runtime.SdkInternalList<String> queryStringCacheKeysItemsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) queryStringCacheKeys
                                            .items();
                                    if (!queryStringCacheKeysItemsList.isEmpty()
                                            || !queryStringCacheKeysItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");

                                        for (String queryStringCacheKeysItemsListValue : queryStringCacheKeysItemsList) {
                                            xmlWriter.startElement("Name");
                                            xmlWriter.value(queryStringCacheKeysItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }

                            TrustedSigners trustedSigners = cacheBehaviorsItemsListValue.trustedSigners();
                            if (trustedSigners != null) {
                                xmlWriter.startElement("TrustedSigners");

                                if (trustedSigners.enabled() != null) {
                                    xmlWriter.startElement("Enabled").value(trustedSigners.enabled()).endElement();
                                }

                                if (trustedSigners.quantity() != null) {
                                    xmlWriter.startElement("Quantity").value(trustedSigners.quantity()).endElement();
                                }

                                software.amazon.awssdk.runtime.SdkInternalList<String> trustedSignersItemsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) trustedSigners
                                        .items();
                                if (!trustedSignersItemsList.isEmpty() || !trustedSignersItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");

                                    for (String trustedSignersItemsListValue : trustedSignersItemsList) {
                                        xmlWriter.startElement("AwsAccountNumber");
                                        xmlWriter.value(trustedSignersItemsListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }

                            if (cacheBehaviorsItemsListValue.viewerProtocolPolicy() != null) {
                                xmlWriter.startElement("ViewerProtocolPolicy")
                                        .value(cacheBehaviorsItemsListValue.viewerProtocolPolicy()).endElement();
                            }

                            if (cacheBehaviorsItemsListValue.minTTL() != null) {
                                xmlWriter.startElement("MinTTL").value(cacheBehaviorsItemsListValue.minTTL()).endElement();
                            }

                            AllowedMethods allowedMethods = cacheBehaviorsItemsListValue.allowedMethods();
                            if (allowedMethods != null) {
                                xmlWriter.startElement("AllowedMethods");

                                if (allowedMethods.quantity() != null) {
                                    xmlWriter.startElement("Quantity").value(allowedMethods.quantity()).endElement();
                                }

                                software.amazon.awssdk.runtime.SdkInternalList<String> allowedMethodsItemsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) allowedMethods
                                        .items();
                                if (!allowedMethodsItemsList.isEmpty() || !allowedMethodsItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");

                                    for (String allowedMethodsItemsListValue : allowedMethodsItemsList) {
                                        xmlWriter.startElement("Method");
                                        xmlWriter.value(allowedMethodsItemsListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }

                                CachedMethods cachedMethods = allowedMethods.cachedMethods();
                                if (cachedMethods != null) {
                                    xmlWriter.startElement("CachedMethods");

                                    if (cachedMethods.quantity() != null) {
                                        xmlWriter.startElement("Quantity").value(cachedMethods.quantity()).endElement();
                                    }

                                    software.amazon.awssdk.runtime.SdkInternalList<String> cachedMethodsItemsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) cachedMethods
                                            .items();
                                    if (!cachedMethodsItemsList.isEmpty() || !cachedMethodsItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");

                                        for (String cachedMethodsItemsListValue : cachedMethodsItemsList) {
                                            xmlWriter.startElement("Method");
                                            xmlWriter.value(cachedMethodsItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }

                            if (cacheBehaviorsItemsListValue.smoothStreaming() != null) {
                                xmlWriter.startElement("SmoothStreaming").value(cacheBehaviorsItemsListValue.smoothStreaming())
                                        .endElement();
                            }

                            if (cacheBehaviorsItemsListValue.defaultTTL() != null) {
                                xmlWriter.startElement("DefaultTTL").value(cacheBehaviorsItemsListValue.defaultTTL())
                                        .endElement();
                            }

                            if (cacheBehaviorsItemsListValue.maxTTL() != null) {
                                xmlWriter.startElement("MaxTTL").value(cacheBehaviorsItemsListValue.maxTTL()).endElement();
                            }

                            if (cacheBehaviorsItemsListValue.compress() != null) {
                                xmlWriter.startElement("Compress").value(cacheBehaviorsItemsListValue.compress()).endElement();
                            }

                            LambdaFunctionAssociations lambdaFunctionAssociations = cacheBehaviorsItemsListValue
                                    .lambdaFunctionAssociations();
                            if (lambdaFunctionAssociations != null) {
                                xmlWriter.startElement("LambdaFunctionAssociations");

                                if (lambdaFunctionAssociations.quantity() != null) {
                                    xmlWriter.startElement("Quantity").value(lambdaFunctionAssociations.quantity()).endElement();
                                }

                                software.amazon.awssdk.runtime.SdkInternalList<LambdaFunctionAssociation> lambdaFunctionAssociationsItemsList = (software.amazon.awssdk.runtime.SdkInternalList<LambdaFunctionAssociation>) lambdaFunctionAssociations
                                        .items();
                                if (!lambdaFunctionAssociationsItemsList.isEmpty()
                                        || !lambdaFunctionAssociationsItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");

                                    for (LambdaFunctionAssociation lambdaFunctionAssociationsItemsListValue : lambdaFunctionAssociationsItemsList) {
                                        xmlWriter.startElement("LambdaFunctionAssociation");

                                        if (lambdaFunctionAssociationsItemsListValue.lambdaFunctionARN() != null) {
                                            xmlWriter.startElement("LambdaFunctionARN")
                                                    .value(lambdaFunctionAssociationsItemsListValue.lambdaFunctionARN())
                                                    .endElement();
                                        }

                                        if (lambdaFunctionAssociationsItemsListValue.eventType() != null) {
                                            xmlWriter.startElement("EventType")
                                                    .value(lambdaFunctionAssociationsItemsListValue.eventType()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }

                CustomErrorResponses customErrorResponses = distributionConfig.customErrorResponses();
                if (customErrorResponses != null) {
                    xmlWriter.startElement("CustomErrorResponses");

                    if (customErrorResponses.quantity() != null) {
                        xmlWriter.startElement("Quantity").value(customErrorResponses.quantity()).endElement();
                    }

                    software.amazon.awssdk.runtime.SdkInternalList<CustomErrorResponse> customErrorResponsesItemsList = (software.amazon.awssdk.runtime.SdkInternalList<CustomErrorResponse>) customErrorResponses
                            .items();
                    if (!customErrorResponsesItemsList.isEmpty() || !customErrorResponsesItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");

                        for (CustomErrorResponse customErrorResponsesItemsListValue : customErrorResponsesItemsList) {
                            xmlWriter.startElement("CustomErrorResponse");

                            if (customErrorResponsesItemsListValue.errorCode() != null) {
                                xmlWriter.startElement("ErrorCode").value(customErrorResponsesItemsListValue.errorCode())
                                        .endElement();
                            }

                            if (customErrorResponsesItemsListValue.responsePagePath() != null) {
                                xmlWriter.startElement("ResponsePagePath")
                                        .value(customErrorResponsesItemsListValue.responsePagePath()).endElement();
                            }

                            if (customErrorResponsesItemsListValue.responseCode() != null) {
                                xmlWriter.startElement("ResponseCode").value(customErrorResponsesItemsListValue.responseCode())
                                        .endElement();
                            }

                            if (customErrorResponsesItemsListValue.errorCachingMinTTL() != null) {
                                xmlWriter.startElement("ErrorCachingMinTTL")
                                        .value(customErrorResponsesItemsListValue.errorCachingMinTTL()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }

                if (distributionConfig.comment() != null) {
                    xmlWriter.startElement("Comment").value(distributionConfig.comment()).endElement();
                }

                LoggingConfig logging = distributionConfig.logging();
                if (logging != null) {
                    xmlWriter.startElement("Logging");

                    if (logging.enabled() != null) {
                        xmlWriter.startElement("Enabled").value(logging.enabled()).endElement();
                    }

                    if (logging.includeCookies() != null) {
                        xmlWriter.startElement("IncludeCookies").value(logging.includeCookies()).endElement();
                    }

                    if (logging.bucket() != null) {
                        xmlWriter.startElement("Bucket").value(logging.bucket()).endElement();
                    }

                    if (logging.prefix() != null) {
                        xmlWriter.startElement("Prefix").value(logging.prefix()).endElement();
                    }
                    xmlWriter.endElement();
                }

                if (distributionConfig.priceClass() != null) {
                    xmlWriter.startElement("PriceClass").value(distributionConfig.priceClass()).endElement();
                }

                if (distributionConfig.enabled() != null) {
                    xmlWriter.startElement("Enabled").value(distributionConfig.enabled()).endElement();
                }

                ViewerCertificate viewerCertificate = distributionConfig.viewerCertificate();
                if (viewerCertificate != null) {
                    xmlWriter.startElement("ViewerCertificate");

                    if (viewerCertificate.cloudFrontDefaultCertificate() != null) {
                        xmlWriter.startElement("CloudFrontDefaultCertificate")
                                .value(viewerCertificate.cloudFrontDefaultCertificate()).endElement();
                    }

                    if (viewerCertificate.iamCertificateId() != null) {
                        xmlWriter.startElement("IAMCertificateId").value(viewerCertificate.iamCertificateId()).endElement();
                    }

                    if (viewerCertificate.acmCertificateArn() != null) {
                        xmlWriter.startElement("ACMCertificateArn").value(viewerCertificate.acmCertificateArn()).endElement();
                    }

                    if (viewerCertificate.sslSupportMethod() != null) {
                        xmlWriter.startElement("SSLSupportMethod").value(viewerCertificate.sslSupportMethod()).endElement();
                    }

                    if (viewerCertificate.minimumProtocolVersion() != null) {
                        xmlWriter.startElement("MinimumProtocolVersion").value(viewerCertificate.minimumProtocolVersion())
                                .endElement();
                    }

                    if (viewerCertificate.certificate() != null) {
                        xmlWriter.startElement("Certificate").value(viewerCertificate.certificate()).endElement();
                    }

                    if (viewerCertificate.certificateSource() != null) {
                        xmlWriter.startElement("CertificateSource").value(viewerCertificate.certificateSource()).endElement();
                    }
                    xmlWriter.endElement();
                }

                Restrictions restrictions = distributionConfig.restrictions();
                if (restrictions != null) {
                    xmlWriter.startElement("Restrictions");

                    GeoRestriction geoRestriction = restrictions.geoRestriction();
                    if (geoRestriction != null) {
                        xmlWriter.startElement("GeoRestriction");

                        if (geoRestriction.restrictionType() != null) {
                            xmlWriter.startElement("RestrictionType").value(geoRestriction.restrictionType()).endElement();
                        }

                        if (geoRestriction.quantity() != null) {
                            xmlWriter.startElement("Quantity").value(geoRestriction.quantity()).endElement();
                        }

                        software.amazon.awssdk.runtime.SdkInternalList<String> geoRestrictionItemsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) geoRestriction
                                .items();
                        if (!geoRestrictionItemsList.isEmpty() || !geoRestrictionItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");

                            for (String geoRestrictionItemsListValue : geoRestrictionItemsList) {
                                xmlWriter.startElement("Location");
                                xmlWriter.value(geoRestrictionItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }

                if (distributionConfig.webACLId() != null) {
                    xmlWriter.startElement("WebACLId").value(distributionConfig.webACLId()).endElement();
                }

                if (distributionConfig.httpVersion() != null) {
                    xmlWriter.startElement("HttpVersion").value(distributionConfig.httpVersion()).endElement();
                }

                if (distributionConfig.isIPV6Enabled() != null) {
                    xmlWriter.startElement("IsIPV6Enabled").value(distributionConfig.isIPV6Enabled()).endElement();
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }

        return request;
    }

}