/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.cloudfront.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

import software.amazon.awssdk.util.StringUtils;

/**
 * ListDistributionsByWebACLIdRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListDistributionsByWebACLIdRequestMarshaller implements
        Marshaller<Request<ListDistributionsByWebACLIdRequest>, ListDistributionsByWebACLIdRequest> {

    public Request<ListDistributionsByWebACLIdRequest> marshall(
            ListDistributionsByWebACLIdRequest listDistributionsByWebACLIdRequest) {

        if (listDistributionsByWebACLIdRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ListDistributionsByWebACLIdRequest> request = new DefaultRequest<ListDistributionsByWebACLIdRequest>(
                listDistributionsByWebACLIdRequest, "CloudFrontClient");

        request.setHttpMethod(HttpMethodName.GET);

        String uriResourcePath = "/2017-03-25/distributionsByWebACLId/{WebACLId}";

        uriResourcePath = software.amazon.awssdk.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "WebACLId", listDistributionsByWebACLIdRequest.webACLId());
        request.setResourcePath(uriResourcePath);

        if (listDistributionsByWebACLIdRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listDistributionsByWebACLIdRequest.marker()));
        }

        if (listDistributionsByWebACLIdRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromString(listDistributionsByWebACLIdRequest.maxItems()));
        }

        return request;
    }

}