/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to update a streaming distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateStreamingDistributionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateStreamingDistributionRequest.Builder, UpdateStreamingDistributionRequest> {
    private final StreamingDistributionConfig streamingDistributionConfig;

    private final String id;

    private final String ifMatch;

    private UpdateStreamingDistributionRequest(BuilderImpl builder) {
        this.streamingDistributionConfig = builder.streamingDistributionConfig;
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
    }

    /**
     * <p>
     * The streaming distribution's configuration information.
     * </p>
     * 
     * @return The streaming distribution's configuration information.
     */
    public StreamingDistributionConfig streamingDistributionConfig() {
        return streamingDistributionConfig;
    }

    /**
     * <p>
     * The streaming distribution's id.
     * </p>
     * 
     * @return The streaming distribution's id.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The value of the <code>ETag</code> header that you received when retrieving the streaming distribution's
     * configuration. For example: <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The value of the <code>ETag</code> header that you received when retrieving the streaming distribution's
     *         configuration. For example: <code>E2QWRUHAPOMQZL</code>.
     */
    public String ifMatch() {
        return ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamingDistributionConfig() == null) ? 0 : streamingDistributionConfig().hashCode());
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((ifMatch() == null) ? 0 : ifMatch().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStreamingDistributionRequest)) {
            return false;
        }
        UpdateStreamingDistributionRequest other = (UpdateStreamingDistributionRequest) obj;
        if (other.streamingDistributionConfig() == null ^ this.streamingDistributionConfig() == null) {
            return false;
        }
        if (other.streamingDistributionConfig() != null
                && !other.streamingDistributionConfig().equals(this.streamingDistributionConfig())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.ifMatch() == null ^ this.ifMatch() == null) {
            return false;
        }
        if (other.ifMatch() != null && !other.ifMatch().equals(this.ifMatch())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (streamingDistributionConfig() != null) {
            sb.append("StreamingDistributionConfig: ").append(streamingDistributionConfig()).append(",");
        }
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (ifMatch() != null) {
            sb.append("IfMatch: ").append(ifMatch()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateStreamingDistributionRequest> {
        /**
         * <p>
         * The streaming distribution's configuration information.
         * </p>
         * 
         * @param streamingDistributionConfig
         *        The streaming distribution's configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig);

        /**
         * <p>
         * The streaming distribution's id.
         * </p>
         * 
         * @param id
         *        The streaming distribution's id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The value of the <code>ETag</code> header that you received when retrieving the streaming distribution's
         * configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param ifMatch
         *        The value of the <code>ETag</code> header that you received when retrieving the streaming
         *        distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);
    }

    private static final class BuilderImpl implements Builder {
        private StreamingDistributionConfig streamingDistributionConfig;

        private String id;

        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStreamingDistributionRequest model) {
            setStreamingDistributionConfig(model.streamingDistributionConfig);
            setId(model.id);
            setIfMatch(model.ifMatch);
        }

        public final StreamingDistributionConfig getStreamingDistributionConfig() {
            return streamingDistributionConfig;
        }

        @Override
        public final Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig;
            return this;
        }

        public final void setStreamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public UpdateStreamingDistributionRequest build() {
            return new UpdateStreamingDistributionRequest(this);
        }
    }
}
