/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains zero or more <code>Tag</code> elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Tags implements ToCopyableBuilder<Tags.Builder, Tags> {
    private final List<Tag> items;

    private Tags(BuilderImpl builder) {
        this.items = builder.items;
    }

    /**
     * <p>
     * A complex type that contains <code>Tag</code> elements.
     * </p>
     * 
     * @return A complex type that contains <code>Tag</code> elements.
     */
    public List<Tag> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((items() == null) ? 0 : items().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tags)) {
            return false;
        }
        Tags other = (Tags) obj;
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        if (other.items() != null && !other.items().equals(this.items())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (items() != null) {
            sb.append("Items: ").append(items()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Tags> {
        /**
         * <p>
         * A complex type that contains <code>Tag</code> elements.
         * </p>
         * 
         * @param items
         *        A complex type that contains <code>Tag</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<Tag> items);

        /**
         * <p>
         * A complex type that contains <code>Tag</code> elements.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setItems(java.util.Collection)} or {@link #withItems(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param items
         *        A complex type that contains <code>Tag</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Tag... items);
    }

    private static final class BuilderImpl implements Builder {
        private List<Tag> items = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(Tags model) {
            setItems(model.items);
        }

        public final Collection<Tag> getItems() {
            return items;
        }

        @Override
        public final Builder items(Collection<Tag> items) {
            this.items = TagListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Tag... items) {
            if (this.items == null) {
                this.items = new SdkInternalList<>(items.length);
            }
            for (Tag e : items) {
                this.items.add(e);
            }
            return this;
        }

        public final void setItems(Collection<Tag> items) {
            this.items = TagListCopier.copy(items);
        }

        @SafeVarargs
        public final void setItems(Tag... items) {
            if (this.items == null) {
                this.items = new SdkInternalList<>(items.length);
            }
            for (Tag e : items) {
                this.items.add(e);
            }
        }

        @Override
        public Tags build() {
            return new Tags(this);
        }
    }
}
