/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the information for an Amazon CloudFront streaming distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StreamingDistributionSummary implements
        ToCopyableBuilder<StreamingDistributionSummary.Builder, StreamingDistributionSummary> {
    private final String id;

    private final String arn;

    private final String status;

    private final Date lastModifiedTime;

    private final String domainName;

    private final S3Origin s3Origin;

    private final Aliases aliases;

    private final TrustedSigners trustedSigners;

    private final String comment;

    private final String priceClass;

    private final Boolean enabled;

    private StreamingDistributionSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.domainName = builder.domainName;
        this.s3Origin = builder.s3Origin;
        this.aliases = builder.aliases;
        this.trustedSigners = builder.trustedSigners;
        this.comment = builder.comment;
        this.priceClass = builder.priceClass;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
     * </p>
     * 
     * @return The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) for the streaming distribution. For example:
     * <code>arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5</code>, where
     * <code>123456789012</code> is your AWS account ID.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) for the streaming distribution. For example:
     *         <code>arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5</code>, where
     *         <code>123456789012</code> is your AWS account ID.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * Indicates the current status of the distribution. When the status is <code>Deployed</code>, the distribution's
     * information is fully propagated throughout the Amazon CloudFront system.
     * </p>
     * 
     * @return Indicates the current status of the distribution. When the status is <code>Deployed</code>, the
     *         distribution's information is fully propagated throughout the Amazon CloudFront system.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The date and time the distribution was last modified.
     * </p>
     * 
     * @return The date and time the distribution was last modified.
     */
    public Date lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The domain name corresponding to the distribution. For example: <code>d604721fxaaqy9.cloudfront.net</code>.
     * </p>
     * 
     * @return The domain name corresponding to the distribution. For example:
     *         <code>d604721fxaaqy9.cloudfront.net</code>.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your
     * media files for distribution.
     * </p>
     * 
     * @return A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get
     *         your media files for distribution.
     */
    public S3Origin s3Origin() {
        return s3Origin;
    }

    /**
     * <p>
     * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming
     * distribution.
     * </p>
     * 
     * @return A complex type that contains information about CNAMEs (alternate domain names), if any, for this
     *         streaming distribution.
     */
    public Aliases aliases() {
        return aliases;
    }

    /**
     * <p>
     * A complex type that specifies the AWS accounts, if any, that you want to allow to create signed URLs for private
     * content. If you want to require signed URLs in requests for objects in the target origin that match the
     * <code>PathPattern</code> for this cache behavior, specify <code>true</code> for <code>Enabled</code>, and specify
     * the applicable values for <code>Quantity</code> and <code>Items</code>.If you don't want to require signed URLs
     * in requests for objects that match <code>PathPattern</code>, specify <code>false</code> for <code>Enabled</code>
     * and <code>0</code> for <code>Quantity</code>. Omit <code>Items</code>. To add, change, or remove one or more
     * trusted signers, change <code>Enabled</code> to <code>true</code> (if it's currently <code>false</code>), change
     * <code>Quantity</code> as applicable, and specify all of the trusted signers that you want to include in the
     * updated distribution.
     * </p>
     * 
     * @return A complex type that specifies the AWS accounts, if any, that you want to allow to create signed URLs for
     *         private content. If you want to require signed URLs in requests for objects in the target origin that
     *         match the <code>PathPattern</code> for this cache behavior, specify <code>true</code> for
     *         <code>Enabled</code>, and specify the applicable values for <code>Quantity</code> and <code>Items</code>
     *         .If you don't want to require signed URLs in requests for objects that match <code>PathPattern</code>,
     *         specify <code>false</code> for <code>Enabled</code> and <code>0</code> for <code>Quantity</code>. Omit
     *         <code>Items</code>. To add, change, or remove one or more trusted signers, change <code>Enabled</code> to
     *         <code>true</code> (if it's currently <code>false</code>), change <code>Quantity</code> as applicable, and
     *         specify all of the trusted signers that you want to include in the updated distribution.
     */
    public TrustedSigners trustedSigners() {
        return trustedSigners;
    }

    /**
     * <p>
     * The comment originally specified when this distribution was created.
     * </p>
     * 
     * @return The comment originally specified when this distribution was created.
     */
    public String comment() {
        return comment;
    }

    /**
     *
     * @return
     * @see PriceClass
     */
    public String priceClass() {
        return priceClass;
    }

    /**
     * <p>
     * Whether the distribution is enabled to accept end user requests for content.
     * </p>
     * 
     * @return Whether the distribution is enabled to accept end user requests for content.
     */
    public Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((lastModifiedTime() == null) ? 0 : lastModifiedTime().hashCode());
        hashCode = 31 * hashCode + ((domainName() == null) ? 0 : domainName().hashCode());
        hashCode = 31 * hashCode + ((s3Origin() == null) ? 0 : s3Origin().hashCode());
        hashCode = 31 * hashCode + ((aliases() == null) ? 0 : aliases().hashCode());
        hashCode = 31 * hashCode + ((trustedSigners() == null) ? 0 : trustedSigners().hashCode());
        hashCode = 31 * hashCode + ((comment() == null) ? 0 : comment().hashCode());
        hashCode = 31 * hashCode + ((priceClass() == null) ? 0 : priceClass().hashCode());
        hashCode = 31 * hashCode + ((enabled() == null) ? 0 : enabled().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingDistributionSummary)) {
            return false;
        }
        StreamingDistributionSummary other = (StreamingDistributionSummary) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.lastModifiedTime() == null ^ this.lastModifiedTime() == null) {
            return false;
        }
        if (other.lastModifiedTime() != null && !other.lastModifiedTime().equals(this.lastModifiedTime())) {
            return false;
        }
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.s3Origin() == null ^ this.s3Origin() == null) {
            return false;
        }
        if (other.s3Origin() != null && !other.s3Origin().equals(this.s3Origin())) {
            return false;
        }
        if (other.aliases() == null ^ this.aliases() == null) {
            return false;
        }
        if (other.aliases() != null && !other.aliases().equals(this.aliases())) {
            return false;
        }
        if (other.trustedSigners() == null ^ this.trustedSigners() == null) {
            return false;
        }
        if (other.trustedSigners() != null && !other.trustedSigners().equals(this.trustedSigners())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        if (other.priceClass() == null ^ this.priceClass() == null) {
            return false;
        }
        if (other.priceClass() != null && !other.priceClass().equals(this.priceClass())) {
            return false;
        }
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (arn() != null) {
            sb.append("ARN: ").append(arn()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (lastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(lastModifiedTime()).append(",");
        }
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (s3Origin() != null) {
            sb.append("S3Origin: ").append(s3Origin()).append(",");
        }
        if (aliases() != null) {
            sb.append("Aliases: ").append(aliases()).append(",");
        }
        if (trustedSigners() != null) {
            sb.append("TrustedSigners: ").append(trustedSigners()).append(",");
        }
        if (comment() != null) {
            sb.append("Comment: ").append(comment()).append(",");
        }
        if (priceClass() != null) {
            sb.append("PriceClass: ").append(priceClass()).append(",");
        }
        if (enabled() != null) {
            sb.append("Enabled: ").append(enabled()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, StreamingDistributionSummary> {
        /**
         * <p>
         * The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
         * </p>
         * 
         * @param id
         *        The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN (Amazon Resource Name) for the streaming distribution. For example:
         * <code>arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5</code>, where
         * <code>123456789012</code> is your AWS account ID.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) for the streaming distribution. For example:
         *        <code>arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5</code>, where
         *        <code>123456789012</code> is your AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Indicates the current status of the distribution. When the status is <code>Deployed</code>, the
         * distribution's information is fully propagated throughout the Amazon CloudFront system.
         * </p>
         * 
         * @param status
         *        Indicates the current status of the distribution. When the status is <code>Deployed</code>, the
         *        distribution's information is fully propagated throughout the Amazon CloudFront system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time the distribution was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time the distribution was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Date lastModifiedTime);

        /**
         * <p>
         * The domain name corresponding to the distribution. For example: <code>d604721fxaaqy9.cloudfront.net</code>.
         * </p>
         * 
         * @param domainName
         *        The domain name corresponding to the distribution. For example:
         *        <code>d604721fxaaqy9.cloudfront.net</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get
         * your media files for distribution.
         * </p>
         * 
         * @param s3Origin
         *        A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to
         *        get your media files for distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Origin(S3Origin s3Origin);

        /**
         * <p>
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming
         * distribution.
         * </p>
         * 
         * @param aliases
         *        A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         *        streaming distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(Aliases aliases);

        /**
         * <p>
         * A complex type that specifies the AWS accounts, if any, that you want to allow to create signed URLs for
         * private content. If you want to require signed URLs in requests for objects in the target origin that match
         * the <code>PathPattern</code> for this cache behavior, specify <code>true</code> for <code>Enabled</code>, and
         * specify the applicable values for <code>Quantity</code> and <code>Items</code>.If you don't want to require
         * signed URLs in requests for objects that match <code>PathPattern</code>, specify <code>false</code> for
         * <code>Enabled</code> and <code>0</code> for <code>Quantity</code>. Omit <code>Items</code>. To add, change,
         * or remove one or more trusted signers, change <code>Enabled</code> to <code>true</code> (if it's currently
         * <code>false</code>), change <code>Quantity</code> as applicable, and specify all of the trusted signers that
         * you want to include in the updated distribution.
         * </p>
         * 
         * @param trustedSigners
         *        A complex type that specifies the AWS accounts, if any, that you want to allow to create signed URLs
         *        for private content. If you want to require signed URLs in requests for objects in the target origin
         *        that match the <code>PathPattern</code> for this cache behavior, specify <code>true</code> for
         *        <code>Enabled</code>, and specify the applicable values for <code>Quantity</code> and
         *        <code>Items</code>.If you don't want to require signed URLs in requests for objects that match
         *        <code>PathPattern</code>, specify <code>false</code> for <code>Enabled</code> and <code>0</code> for
         *        <code>Quantity</code>. Omit <code>Items</code>. To add, change, or remove one or more trusted signers,
         *        change <code>Enabled</code> to <code>true</code> (if it's currently <code>false</code>), change
         *        <code>Quantity</code> as applicable, and specify all of the trusted signers that you want to include
         *        in the updated distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedSigners(TrustedSigners trustedSigners);

        /**
         * <p>
         * The comment originally specified when this distribution was created.
         * </p>
         * 
         * @param comment
         *        The comment originally specified when this distribution was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         *
         * @param priceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(String priceClass);

        /**
         *
         * @param priceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(PriceClass priceClass);

        /**
         * <p>
         * Whether the distribution is enabled to accept end user requests for content.
         * </p>
         * 
         * @param enabled
         *        Whether the distribution is enabled to accept end user requests for content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String status;

        private Date lastModifiedTime;

        private String domainName;

        private S3Origin s3Origin;

        private Aliases aliases;

        private TrustedSigners trustedSigners;

        private String comment;

        private String priceClass;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingDistributionSummary model) {
            setId(model.id);
            setARN(model.arn);
            setStatus(model.status);
            setLastModifiedTime(model.lastModifiedTime);
            setDomainName(model.domainName);
            setS3Origin(model.s3Origin);
            setAliases(model.aliases);
            setTrustedSigners(model.trustedSigners);
            setComment(model.comment);
            setPriceClass(model.priceClass);
            setEnabled(model.enabled);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getARN() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Date getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Date lastModifiedTime) {
            this.lastModifiedTime = StandardMemberCopier.copy(lastModifiedTime);
            return this;
        }

        public final void setLastModifiedTime(Date lastModifiedTime) {
            this.lastModifiedTime = StandardMemberCopier.copy(lastModifiedTime);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final S3Origin getS3Origin() {
            return s3Origin;
        }

        @Override
        public final Builder s3Origin(S3Origin s3Origin) {
            this.s3Origin = s3Origin;
            return this;
        }

        public final void setS3Origin(S3Origin s3Origin) {
            this.s3Origin = s3Origin;
        }

        public final Aliases getAliases() {
            return aliases;
        }

        @Override
        public final Builder aliases(Aliases aliases) {
            this.aliases = aliases;
            return this;
        }

        public final void setAliases(Aliases aliases) {
            this.aliases = aliases;
        }

        public final TrustedSigners getTrustedSigners() {
            return trustedSigners;
        }

        @Override
        public final Builder trustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
            return this;
        }

        public final void setTrustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final String getPriceClass() {
            return priceClass;
        }

        @Override
        public final Builder priceClass(String priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        @Override
        public final Builder priceClass(PriceClass priceClass) {
            this.priceClass(priceClass.toString());
            return this;
        }

        public final void setPriceClass(String priceClass) {
            this.priceClass = priceClass;
        }

        public final void setPriceClass(PriceClass priceClass) {
            this.priceClass(priceClass.toString());
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public StreamingDistributionSummary build() {
            return new StreamingDistributionSummary(this);
        }
    }
}
