/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The RTMP distribution's configuration information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StreamingDistributionConfig implements
        ToCopyableBuilder<StreamingDistributionConfig.Builder, StreamingDistributionConfig> {
    private final String callerReference;

    private final S3Origin s3Origin;

    private final Aliases aliases;

    private final String comment;

    private final StreamingLoggingConfig logging;

    private final TrustedSigners trustedSigners;

    private final String priceClass;

    private final Boolean enabled;

    private StreamingDistributionConfig(BuilderImpl builder) {
        this.callerReference = builder.callerReference;
        this.s3Origin = builder.s3Origin;
        this.aliases = builder.aliases;
        this.comment = builder.comment;
        this.logging = builder.logging;
        this.trustedSigners = builder.trustedSigners;
        this.priceClass = builder.priceClass;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * A unique number that ensures that the request can't be replayed. If the <code>CallerReference</code> is new (no
     * matter the content of the <code>StreamingDistributionConfig</code> object), a new streaming distribution is
     * created. If the <code>CallerReference</code> is a value that you already sent in a previous request to create a
     * streaming distribution, and the content of the <code>StreamingDistributionConfig</code> is identical to the
     * original request (ignoring white space), the response includes the same information returned to the original
     * request. If the <code>CallerReference</code> is a value that you already sent in a previous request to create a
     * streaming distribution but the content of the <code>StreamingDistributionConfig</code> is different from the
     * original request, CloudFront returns a <code>DistributionAlreadyExists</code> error.
     * </p>
     * 
     * @return A unique number that ensures that the request can't be replayed. If the <code>CallerReference</code> is
     *         new (no matter the content of the <code>StreamingDistributionConfig</code> object), a new streaming
     *         distribution is created. If the <code>CallerReference</code> is a value that you already sent in a
     *         previous request to create a streaming distribution, and the content of the
     *         <code>StreamingDistributionConfig</code> is identical to the original request (ignoring white space), the
     *         response includes the same information returned to the original request. If the
     *         <code>CallerReference</code> is a value that you already sent in a previous request to create a streaming
     *         distribution but the content of the <code>StreamingDistributionConfig</code> is different from the
     *         original request, CloudFront returns a <code>DistributionAlreadyExists</code> error.
     */
    public String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your
     * media files for distribution.
     * </p>
     * 
     * @return A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get
     *         your media files for distribution.
     */
    public S3Origin s3Origin() {
        return s3Origin;
    }

    /**
     * <p>
     * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming
     * distribution.
     * </p>
     * 
     * @return A complex type that contains information about CNAMEs (alternate domain names), if any, for this
     *         streaming distribution.
     */
    public Aliases aliases() {
        return aliases;
    }

    /**
     * <p>
     * Any comments you want to include about the streaming distribution.
     * </p>
     * 
     * @return Any comments you want to include about the streaming distribution.
     */
    public String comment() {
        return comment;
    }

    /**
     * <p>
     * A complex type that controls whether access logs are written for the streaming distribution.
     * </p>
     * 
     * @return A complex type that controls whether access logs are written for the streaming distribution.
     */
    public StreamingLoggingConfig logging() {
        return logging;
    }

    /**
     * <p>
     * A complex type that specifies any AWS accounts that you want to permit to create signed URLs for private content.
     * If you want the distribution to use signed URLs, include this element; if you want the distribution to use public
     * URLs, remove this element. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return A complex type that specifies any AWS accounts that you want to permit to create signed URLs for private
     *         content. If you want the distribution to use signed URLs, include this element; if you want the
     *         distribution to use public URLs, remove this element. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
     *         Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public TrustedSigners trustedSigners() {
        return trustedSigners;
    }

    /**
     * <p>
     * A complex type that contains information about price class for this streaming distribution.
     * </p>
     * 
     * @return A complex type that contains information about price class for this streaming distribution.
     * @see PriceClass
     */
    public String priceClass() {
        return priceClass;
    }

    /**
     * <p>
     * Whether the streaming distribution is enabled to accept user requests for content.
     * </p>
     * 
     * @return Whether the streaming distribution is enabled to accept user requests for content.
     */
    public Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((callerReference() == null) ? 0 : callerReference().hashCode());
        hashCode = 31 * hashCode + ((s3Origin() == null) ? 0 : s3Origin().hashCode());
        hashCode = 31 * hashCode + ((aliases() == null) ? 0 : aliases().hashCode());
        hashCode = 31 * hashCode + ((comment() == null) ? 0 : comment().hashCode());
        hashCode = 31 * hashCode + ((logging() == null) ? 0 : logging().hashCode());
        hashCode = 31 * hashCode + ((trustedSigners() == null) ? 0 : trustedSigners().hashCode());
        hashCode = 31 * hashCode + ((priceClass() == null) ? 0 : priceClass().hashCode());
        hashCode = 31 * hashCode + ((enabled() == null) ? 0 : enabled().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingDistributionConfig)) {
            return false;
        }
        StreamingDistributionConfig other = (StreamingDistributionConfig) obj;
        if (other.callerReference() == null ^ this.callerReference() == null) {
            return false;
        }
        if (other.callerReference() != null && !other.callerReference().equals(this.callerReference())) {
            return false;
        }
        if (other.s3Origin() == null ^ this.s3Origin() == null) {
            return false;
        }
        if (other.s3Origin() != null && !other.s3Origin().equals(this.s3Origin())) {
            return false;
        }
        if (other.aliases() == null ^ this.aliases() == null) {
            return false;
        }
        if (other.aliases() != null && !other.aliases().equals(this.aliases())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        if (other.logging() == null ^ this.logging() == null) {
            return false;
        }
        if (other.logging() != null && !other.logging().equals(this.logging())) {
            return false;
        }
        if (other.trustedSigners() == null ^ this.trustedSigners() == null) {
            return false;
        }
        if (other.trustedSigners() != null && !other.trustedSigners().equals(this.trustedSigners())) {
            return false;
        }
        if (other.priceClass() == null ^ this.priceClass() == null) {
            return false;
        }
        if (other.priceClass() != null && !other.priceClass().equals(this.priceClass())) {
            return false;
        }
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (callerReference() != null) {
            sb.append("CallerReference: ").append(callerReference()).append(",");
        }
        if (s3Origin() != null) {
            sb.append("S3Origin: ").append(s3Origin()).append(",");
        }
        if (aliases() != null) {
            sb.append("Aliases: ").append(aliases()).append(",");
        }
        if (comment() != null) {
            sb.append("Comment: ").append(comment()).append(",");
        }
        if (logging() != null) {
            sb.append("Logging: ").append(logging()).append(",");
        }
        if (trustedSigners() != null) {
            sb.append("TrustedSigners: ").append(trustedSigners()).append(",");
        }
        if (priceClass() != null) {
            sb.append("PriceClass: ").append(priceClass()).append(",");
        }
        if (enabled() != null) {
            sb.append("Enabled: ").append(enabled()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, StreamingDistributionConfig> {
        /**
         * <p>
         * A unique number that ensures that the request can't be replayed. If the <code>CallerReference</code> is new
         * (no matter the content of the <code>StreamingDistributionConfig</code> object), a new streaming distribution
         * is created. If the <code>CallerReference</code> is a value that you already sent in a previous request to
         * create a streaming distribution, and the content of the <code>StreamingDistributionConfig</code> is identical
         * to the original request (ignoring white space), the response includes the same information returned to the
         * original request. If the <code>CallerReference</code> is a value that you already sent in a previous request
         * to create a streaming distribution but the content of the <code>StreamingDistributionConfig</code> is
         * different from the original request, CloudFront returns a <code>DistributionAlreadyExists</code> error.
         * </p>
         * 
         * @param callerReference
         *        A unique number that ensures that the request can't be replayed. If the <code>CallerReference</code>
         *        is new (no matter the content of the <code>StreamingDistributionConfig</code> object), a new streaming
         *        distribution is created. If the <code>CallerReference</code> is a value that you already sent in a
         *        previous request to create a streaming distribution, and the content of the
         *        <code>StreamingDistributionConfig</code> is identical to the original request (ignoring white space),
         *        the response includes the same information returned to the original request. If the
         *        <code>CallerReference</code> is a value that you already sent in a previous request to create a
         *        streaming distribution but the content of the <code>StreamingDistributionConfig</code> is different
         *        from the original request, CloudFront returns a <code>DistributionAlreadyExists</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get
         * your media files for distribution.
         * </p>
         * 
         * @param s3Origin
         *        A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to
         *        get your media files for distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Origin(S3Origin s3Origin);

        /**
         * <p>
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming
         * distribution.
         * </p>
         * 
         * @param aliases
         *        A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         *        streaming distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(Aliases aliases);

        /**
         * <p>
         * Any comments you want to include about the streaming distribution.
         * </p>
         * 
         * @param comment
         *        Any comments you want to include about the streaming distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * A complex type that controls whether access logs are written for the streaming distribution.
         * </p>
         * 
         * @param logging
         *        A complex type that controls whether access logs are written for the streaming distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logging(StreamingLoggingConfig logging);

        /**
         * <p>
         * A complex type that specifies any AWS accounts that you want to permit to create signed URLs for private
         * content. If you want the distribution to use signed URLs, include this element; if you want the distribution
         * to use public URLs, remove this element. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param trustedSigners
         *        A complex type that specifies any AWS accounts that you want to permit to create signed URLs for
         *        private content. If you want the distribution to use signed URLs, include this element; if you want
         *        the distribution to use public URLs, remove this element. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
         *        Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedSigners(TrustedSigners trustedSigners);

        /**
         * <p>
         * A complex type that contains information about price class for this streaming distribution.
         * </p>
         * 
         * @param priceClass
         *        A complex type that contains information about price class for this streaming distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(String priceClass);

        /**
         * <p>
         * A complex type that contains information about price class for this streaming distribution.
         * </p>
         * 
         * @param priceClass
         *        A complex type that contains information about price class for this streaming distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(PriceClass priceClass);

        /**
         * <p>
         * Whether the streaming distribution is enabled to accept user requests for content.
         * </p>
         * 
         * @param enabled
         *        Whether the streaming distribution is enabled to accept user requests for content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    private static final class BuilderImpl implements Builder {
        private String callerReference;

        private S3Origin s3Origin;

        private Aliases aliases;

        private String comment;

        private StreamingLoggingConfig logging;

        private TrustedSigners trustedSigners;

        private String priceClass;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingDistributionConfig model) {
            setCallerReference(model.callerReference);
            setS3Origin(model.s3Origin);
            setAliases(model.aliases);
            setComment(model.comment);
            setLogging(model.logging);
            setTrustedSigners(model.trustedSigners);
            setPriceClass(model.priceClass);
            setEnabled(model.enabled);
        }

        public final String getCallerReference() {
            return callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final S3Origin getS3Origin() {
            return s3Origin;
        }

        @Override
        public final Builder s3Origin(S3Origin s3Origin) {
            this.s3Origin = s3Origin;
            return this;
        }

        public final void setS3Origin(S3Origin s3Origin) {
            this.s3Origin = s3Origin;
        }

        public final Aliases getAliases() {
            return aliases;
        }

        @Override
        public final Builder aliases(Aliases aliases) {
            this.aliases = aliases;
            return this;
        }

        public final void setAliases(Aliases aliases) {
            this.aliases = aliases;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final StreamingLoggingConfig getLogging() {
            return logging;
        }

        @Override
        public final Builder logging(StreamingLoggingConfig logging) {
            this.logging = logging;
            return this;
        }

        public final void setLogging(StreamingLoggingConfig logging) {
            this.logging = logging;
        }

        public final TrustedSigners getTrustedSigners() {
            return trustedSigners;
        }

        @Override
        public final Builder trustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
            return this;
        }

        public final void setTrustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
        }

        public final String getPriceClass() {
            return priceClass;
        }

        @Override
        public final Builder priceClass(String priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        @Override
        public final Builder priceClass(PriceClass priceClass) {
            this.priceClass(priceClass.toString());
            return this;
        }

        public final void setPriceClass(String priceClass) {
            this.priceClass = priceClass;
        }

        public final void setPriceClass(PriceClass priceClass) {
            this.priceClass(priceClass.toString());
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public StreamingDistributionConfig build() {
            return new StreamingDistributionConfig(this);
        }
    }
}
