/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains a Lambda function association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LambdaFunctionAssociation implements ToCopyableBuilder<LambdaFunctionAssociation.Builder, LambdaFunctionAssociation> {
    private final String lambdaFunctionARN;

    private final String eventType;

    private LambdaFunctionAssociation(BuilderImpl builder) {
        this.lambdaFunctionARN = builder.lambdaFunctionARN;
        this.eventType = builder.eventType;
    }

    /**
     * <p>
     * The ARN of the Lambda function.
     * </p>
     * 
     * @return The ARN of the Lambda function.
     */
    public String lambdaFunctionARN() {
        return lambdaFunctionARN;
    }

    /**
     * <p>
     * Specifies the event type that triggers a Lambda function invocation. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>viewer-request</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>origin-request</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>viewer-response</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>origin-response</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies the event type that triggers a Lambda function invocation. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>viewer-request</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>origin-request</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>viewer-response</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>origin-response</code>
     *         </p>
     *         </li>
     * @see EventType
     */
    public String eventType() {
        return eventType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((lambdaFunctionARN() == null) ? 0 : lambdaFunctionARN().hashCode());
        hashCode = 31 * hashCode + ((eventType() == null) ? 0 : eventType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionAssociation)) {
            return false;
        }
        LambdaFunctionAssociation other = (LambdaFunctionAssociation) obj;
        if (other.lambdaFunctionARN() == null ^ this.lambdaFunctionARN() == null) {
            return false;
        }
        if (other.lambdaFunctionARN() != null && !other.lambdaFunctionARN().equals(this.lambdaFunctionARN())) {
            return false;
        }
        if (other.eventType() == null ^ this.eventType() == null) {
            return false;
        }
        if (other.eventType() != null && !other.eventType().equals(this.eventType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (lambdaFunctionARN() != null) {
            sb.append("LambdaFunctionARN: ").append(lambdaFunctionARN()).append(",");
        }
        if (eventType() != null) {
            sb.append("EventType: ").append(eventType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, LambdaFunctionAssociation> {
        /**
         * <p>
         * The ARN of the Lambda function.
         * </p>
         * 
         * @param lambdaFunctionARN
         *        The ARN of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionARN(String lambdaFunctionARN);

        /**
         * <p>
         * Specifies the event type that triggers a Lambda function invocation. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>viewer-request</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>origin-request</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>viewer-response</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>origin-response</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventType
         *        Specifies the event type that triggers a Lambda function invocation. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>viewer-request</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>origin-request</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>viewer-response</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>origin-response</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * Specifies the event type that triggers a Lambda function invocation. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>viewer-request</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>origin-request</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>viewer-response</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>origin-response</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventType
         *        Specifies the event type that triggers a Lambda function invocation. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>viewer-request</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>origin-request</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>viewer-response</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>origin-response</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(EventType eventType);
    }

    private static final class BuilderImpl implements Builder {
        private String lambdaFunctionARN;

        private String eventType;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionAssociation model) {
            setLambdaFunctionARN(model.lambdaFunctionARN);
            setEventType(model.eventType);
        }

        public final String getLambdaFunctionARN() {
            return lambdaFunctionARN;
        }

        @Override
        public final Builder lambdaFunctionARN(String lambdaFunctionARN) {
            this.lambdaFunctionARN = lambdaFunctionARN;
            return this;
        }

        public final void setLambdaFunctionARN(String lambdaFunctionARN) {
            this.lambdaFunctionARN = lambdaFunctionARN;
        }

        public final String getEventType() {
            return eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType.toString());
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final void setEventType(EventType eventType) {
            this.eventType(eventType.toString());
        }

        @Override
        public LambdaFunctionAssociation build() {
            return new LambdaFunctionAssociation(this);
        }
    }
}
