/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that controls the countries in which your content is distributed. CloudFront determines the location
 * of your users using <code>MaxMind</code> GeoIP databases.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GeoRestriction implements ToCopyableBuilder<GeoRestriction.Builder, GeoRestriction> {
    private final String restrictionType;

    private final Integer quantity;

    private final List<String> items;

    private GeoRestriction(BuilderImpl builder) {
        this.restrictionType = builder.restrictionType;
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * The method that you want to use to restrict distribution of your content by country:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>none</code>: No geo restriction is enabled, meaning access to content is not restricted by client geo
     * location.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>blacklist</code>: The <code>Location</code> elements specify the countries in which you do not want
     * CloudFront to distribute your content.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>whitelist</code>: The <code>Location</code> elements specify the countries in which you want CloudFront to
     * distribute your content.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The method that you want to use to restrict distribution of your content by country:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>none</code>: No geo restriction is enabled, meaning access to content is not restricted by client
     *         geo location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>blacklist</code>: The <code>Location</code> elements specify the countries in which you do not want
     *         CloudFront to distribute your content.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>whitelist</code>: The <code>Location</code> elements specify the countries in which you want
     *         CloudFront to distribute your content.
     *         </p>
     *         </li>
     * @see GeoRestrictionType
     */
    public String restrictionType() {
        return restrictionType;
    }

    /**
     * <p>
     * When geo restriction is <code>enabled</code>, this is the number of countries in your <code>whitelist</code> or
     * <code>blacklist</code>. Otherwise, when it is not enabled, <code>Quantity</code> is <code>0</code>, and you can
     * omit <code>Items</code>.
     * </p>
     * 
     * @return When geo restriction is <code>enabled</code>, this is the number of countries in your
     *         <code>whitelist</code> or <code>blacklist</code>. Otherwise, when it is not enabled,
     *         <code>Quantity</code> is <code>0</code>, and you can omit <code>Items</code>.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * A complex type that contains a <code>Location</code> element for each country in which you want CloudFront either
     * to distribute your content (<code>whitelist</code>) or not distribute your content (<code>blacklist</code>).
     * </p>
     * <p>
     * The <code>Location</code> element is a two-letter, uppercase country code for a country that you want to include
     * in your <code>blacklist</code> or <code>whitelist</code>. Include one <code>Location</code> element for each
     * country.
     * </p>
     * <p>
     * CloudFront and <code>MaxMind</code> both use <code>ISO 3166</code> country codes. For the current list of
     * countries and the corresponding codes, see <code>ISO 3166-1-alpha-2</code> code on the <i>International
     * Organization for Standardization</i> website. You can also refer to the country list in the CloudFront console,
     * which includes both country names and codes.
     * </p>
     * 
     * @return A complex type that contains a <code>Location</code> element for each country in which you want
     *         CloudFront either to distribute your content (<code>whitelist</code>) or not distribute your content (
     *         <code>blacklist</code>).</p>
     *         <p>
     *         The <code>Location</code> element is a two-letter, uppercase country code for a country that you want to
     *         include in your <code>blacklist</code> or <code>whitelist</code>. Include one <code>Location</code>
     *         element for each country.
     *         </p>
     *         <p>
     *         CloudFront and <code>MaxMind</code> both use <code>ISO 3166</code> country codes. For the current list of
     *         countries and the corresponding codes, see <code>ISO 3166-1-alpha-2</code> code on the <i>International
     *         Organization for Standardization</i> website. You can also refer to the country list in the CloudFront
     *         console, which includes both country names and codes.
     */
    public List<String> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((restrictionType() == null) ? 0 : restrictionType().hashCode());
        hashCode = 31 * hashCode + ((quantity() == null) ? 0 : quantity().hashCode());
        hashCode = 31 * hashCode + ((items() == null) ? 0 : items().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoRestriction)) {
            return false;
        }
        GeoRestriction other = (GeoRestriction) obj;
        if (other.restrictionType() == null ^ this.restrictionType() == null) {
            return false;
        }
        if (other.restrictionType() != null && !other.restrictionType().equals(this.restrictionType())) {
            return false;
        }
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        if (other.items() != null && !other.items().equals(this.items())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (restrictionType() != null) {
            sb.append("RestrictionType: ").append(restrictionType()).append(",");
        }
        if (quantity() != null) {
            sb.append("Quantity: ").append(quantity()).append(",");
        }
        if (items() != null) {
            sb.append("Items: ").append(items()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GeoRestriction> {
        /**
         * <p>
         * The method that you want to use to restrict distribution of your content by country:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>none</code>: No geo restriction is enabled, meaning access to content is not restricted by client geo
         * location.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>blacklist</code>: The <code>Location</code> elements specify the countries in which you do not want
         * CloudFront to distribute your content.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>whitelist</code>: The <code>Location</code> elements specify the countries in which you want CloudFront
         * to distribute your content.
         * </p>
         * </li>
         * </ul>
         * 
         * @param restrictionType
         *        The method that you want to use to restrict distribution of your content by country:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>none</code>: No geo restriction is enabled, meaning access to content is not restricted by
         *        client geo location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>blacklist</code>: The <code>Location</code> elements specify the countries in which you do not
         *        want CloudFront to distribute your content.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>whitelist</code>: The <code>Location</code> elements specify the countries in which you want
         *        CloudFront to distribute your content.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeoRestrictionType
         */
        Builder restrictionType(String restrictionType);

        /**
         * <p>
         * The method that you want to use to restrict distribution of your content by country:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>none</code>: No geo restriction is enabled, meaning access to content is not restricted by client geo
         * location.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>blacklist</code>: The <code>Location</code> elements specify the countries in which you do not want
         * CloudFront to distribute your content.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>whitelist</code>: The <code>Location</code> elements specify the countries in which you want CloudFront
         * to distribute your content.
         * </p>
         * </li>
         * </ul>
         * 
         * @param restrictionType
         *        The method that you want to use to restrict distribution of your content by country:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>none</code>: No geo restriction is enabled, meaning access to content is not restricted by
         *        client geo location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>blacklist</code>: The <code>Location</code> elements specify the countries in which you do not
         *        want CloudFront to distribute your content.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>whitelist</code>: The <code>Location</code> elements specify the countries in which you want
         *        CloudFront to distribute your content.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeoRestrictionType
         */
        Builder restrictionType(GeoRestrictionType restrictionType);

        /**
         * <p>
         * When geo restriction is <code>enabled</code>, this is the number of countries in your <code>whitelist</code>
         * or <code>blacklist</code>. Otherwise, when it is not enabled, <code>Quantity</code> is <code>0</code>, and
         * you can omit <code>Items</code>.
         * </p>
         * 
         * @param quantity
         *        When geo restriction is <code>enabled</code>, this is the number of countries in your
         *        <code>whitelist</code> or <code>blacklist</code>. Otherwise, when it is not enabled,
         *        <code>Quantity</code> is <code>0</code>, and you can omit <code>Items</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * A complex type that contains a <code>Location</code> element for each country in which you want CloudFront
         * either to distribute your content (<code>whitelist</code>) or not distribute your content (
         * <code>blacklist</code>).
         * </p>
         * <p>
         * The <code>Location</code> element is a two-letter, uppercase country code for a country that you want to
         * include in your <code>blacklist</code> or <code>whitelist</code>. Include one <code>Location</code> element
         * for each country.
         * </p>
         * <p>
         * CloudFront and <code>MaxMind</code> both use <code>ISO 3166</code> country codes. For the current list of
         * countries and the corresponding codes, see <code>ISO 3166-1-alpha-2</code> code on the <i>International
         * Organization for Standardization</i> website. You can also refer to the country list in the CloudFront
         * console, which includes both country names and codes.
         * </p>
         * 
         * @param items
         *        A complex type that contains a <code>Location</code> element for each country in which you want
         *        CloudFront either to distribute your content (<code>whitelist</code>) or not distribute your content (
         *        <code>blacklist</code>).</p>
         *        <p>
         *        The <code>Location</code> element is a two-letter, uppercase country code for a country that you want
         *        to include in your <code>blacklist</code> or <code>whitelist</code>. Include one <code>Location</code>
         *        element for each country.
         *        </p>
         *        <p>
         *        CloudFront and <code>MaxMind</code> both use <code>ISO 3166</code> country codes. For the current list
         *        of countries and the corresponding codes, see <code>ISO 3166-1-alpha-2</code> code on the
         *        <i>International Organization for Standardization</i> website. You can also refer to the country list
         *        in the CloudFront console, which includes both country names and codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<String> items);

        /**
         * <p>
         * A complex type that contains a <code>Location</code> element for each country in which you want CloudFront
         * either to distribute your content (<code>whitelist</code>) or not distribute your content (
         * <code>blacklist</code>).
         * </p>
         * <p>
         * The <code>Location</code> element is a two-letter, uppercase country code for a country that you want to
         * include in your <code>blacklist</code> or <code>whitelist</code>. Include one <code>Location</code> element
         * for each country.
         * </p>
         * <p>
         * CloudFront and <code>MaxMind</code> both use <code>ISO 3166</code> country codes. For the current list of
         * countries and the corresponding codes, see <code>ISO 3166-1-alpha-2</code> code on the <i>International
         * Organization for Standardization</i> website. You can also refer to the country list in the CloudFront
         * console, which includes both country names and codes.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setItems(java.util.Collection)} or {@link #withItems(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param items
         *        A complex type that contains a <code>Location</code> element for each country in which you want
         *        CloudFront either to distribute your content (<code>whitelist</code>) or not distribute your content (
         *        <code>blacklist</code>).</p>
         *        <p>
         *        The <code>Location</code> element is a two-letter, uppercase country code for a country that you want
         *        to include in your <code>blacklist</code> or <code>whitelist</code>. Include one <code>Location</code>
         *        element for each country.
         *        </p>
         *        <p>
         *        CloudFront and <code>MaxMind</code> both use <code>ISO 3166</code> country codes. For the current list
         *        of countries and the corresponding codes, see <code>ISO 3166-1-alpha-2</code> code on the
         *        <i>International Organization for Standardization</i> website. You can also refer to the country list
         *        in the CloudFront console, which includes both country names and codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(String... items);
    }

    private static final class BuilderImpl implements Builder {
        private String restrictionType;

        private Integer quantity;

        private List<String> items = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(GeoRestriction model) {
            setRestrictionType(model.restrictionType);
            setQuantity(model.quantity);
            setItems(model.items);
        }

        public final String getRestrictionType() {
            return restrictionType;
        }

        @Override
        public final Builder restrictionType(String restrictionType) {
            this.restrictionType = restrictionType;
            return this;
        }

        @Override
        public final Builder restrictionType(GeoRestrictionType restrictionType) {
            this.restrictionType(restrictionType.toString());
            return this;
        }

        public final void setRestrictionType(String restrictionType) {
            this.restrictionType = restrictionType;
        }

        public final void setRestrictionType(GeoRestrictionType restrictionType) {
            this.restrictionType(restrictionType.toString());
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<String> getItems() {
            return items;
        }

        @Override
        public final Builder items(Collection<String> items) {
            this.items = LocationListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(String... items) {
            if (this.items == null) {
                this.items = new SdkInternalList<>(items.length);
            }
            for (String e : items) {
                this.items.add(e);
            }
            return this;
        }

        public final void setItems(Collection<String> items) {
            this.items = LocationListCopier.copy(items);
        }

        @SafeVarargs
        public final void setItems(String... items) {
            if (this.items == null) {
                this.items = new SdkInternalList<>(items.length);
            }
            for (String e : items) {
                this.items.add(e);
            }
        }

        @Override
        public GeoRestriction build() {
            return new GeoRestriction(this);
        }
    }
}
