/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateStreamingDistributionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateStreamingDistributionResponse.Builder, CreateStreamingDistributionResponse> {
    private final StreamingDistribution streamingDistribution;

    private final String location;

    private final String eTag;

    private CreateStreamingDistributionResponse(BuilderImpl builder) {
        this.streamingDistribution = builder.streamingDistribution;
        this.location = builder.location;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The streaming distribution's information.
     * </p>
     * 
     * @return The streaming distribution's information.
     */
    public StreamingDistribution streamingDistribution() {
        return streamingDistribution;
    }

    /**
     * <p>
     * The fully qualified URI of the new streaming distribution resource just created. For example:
     * <code>https://cloudfront.amazonaws.com/2010-11-01/streaming-distribution/EGTXBD79H29TRA8</code>.
     * </p>
     * 
     * @return The fully qualified URI of the new streaming distribution resource just created. For example:
     *         <code>https://cloudfront.amazonaws.com/2010-11-01/streaming-distribution/EGTXBD79H29TRA8</code>.
     */
    public String location() {
        return location;
    }

    /**
     * <p>
     * The current version of the streaming distribution created.
     * </p>
     * 
     * @return The current version of the streaming distribution created.
     */
    public String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamingDistribution() == null) ? 0 : streamingDistribution().hashCode());
        hashCode = 31 * hashCode + ((location() == null) ? 0 : location().hashCode());
        hashCode = 31 * hashCode + ((eTag() == null) ? 0 : eTag().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamingDistributionResponse)) {
            return false;
        }
        CreateStreamingDistributionResponse other = (CreateStreamingDistributionResponse) obj;
        if (other.streamingDistribution() == null ^ this.streamingDistribution() == null) {
            return false;
        }
        if (other.streamingDistribution() != null && !other.streamingDistribution().equals(this.streamingDistribution())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.eTag() == null ^ this.eTag() == null) {
            return false;
        }
        if (other.eTag() != null && !other.eTag().equals(this.eTag())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (streamingDistribution() != null) {
            sb.append("StreamingDistribution: ").append(streamingDistribution()).append(",");
        }
        if (location() != null) {
            sb.append("Location: ").append(location()).append(",");
        }
        if (eTag() != null) {
            sb.append("ETag: ").append(eTag()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateStreamingDistributionResponse> {
        /**
         * <p>
         * The streaming distribution's information.
         * </p>
         * 
         * @param streamingDistribution
         *        The streaming distribution's information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingDistribution(StreamingDistribution streamingDistribution);

        /**
         * <p>
         * The fully qualified URI of the new streaming distribution resource just created. For example:
         * <code>https://cloudfront.amazonaws.com/2010-11-01/streaming-distribution/EGTXBD79H29TRA8</code>.
         * </p>
         * 
         * @param location
         *        The fully qualified URI of the new streaming distribution resource just created. For example:
         *        <code>https://cloudfront.amazonaws.com/2010-11-01/streaming-distribution/EGTXBD79H29TRA8</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The current version of the streaming distribution created.
         * </p>
         * 
         * @param eTag
         *        The current version of the streaming distribution created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    private static final class BuilderImpl implements Builder {
        private StreamingDistribution streamingDistribution;

        private String location;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamingDistributionResponse model) {
            setStreamingDistribution(model.streamingDistribution);
            setLocation(model.location);
            setETag(model.eTag);
        }

        public final StreamingDistribution getStreamingDistribution() {
            return streamingDistribution;
        }

        @Override
        public final Builder streamingDistribution(StreamingDistribution streamingDistribution) {
            this.streamingDistribution = streamingDistribution;
            return this;
        }

        public final void setStreamingDistribution(StreamingDistribution streamingDistribution) {
            this.streamingDistribution = streamingDistribution;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public CreateStreamingDistributionResponse build() {
            return new CreateStreamingDistributionResponse(this);
        }
    }
}
