/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateInvalidationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateInvalidationResponse.Builder, CreateInvalidationResponse> {
    private final String location;

    private final Invalidation invalidation;

    private CreateInvalidationResponse(BuilderImpl builder) {
        this.location = builder.location;
        this.invalidation = builder.invalidation;
    }

    /**
     * <p>
     * The fully qualified URI of the distribution and invalidation batch request, including the
     * <code>Invalidation ID</code>.
     * </p>
     * 
     * @return The fully qualified URI of the distribution and invalidation batch request, including the
     *         <code>Invalidation ID</code>.
     */
    public String location() {
        return location;
    }

    /**
     * <p>
     * The invalidation's information.
     * </p>
     * 
     * @return The invalidation's information.
     */
    public Invalidation invalidation() {
        return invalidation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((location() == null) ? 0 : location().hashCode());
        hashCode = 31 * hashCode + ((invalidation() == null) ? 0 : invalidation().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInvalidationResponse)) {
            return false;
        }
        CreateInvalidationResponse other = (CreateInvalidationResponse) obj;
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.invalidation() == null ^ this.invalidation() == null) {
            return false;
        }
        if (other.invalidation() != null && !other.invalidation().equals(this.invalidation())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (location() != null) {
            sb.append("Location: ").append(location()).append(",");
        }
        if (invalidation() != null) {
            sb.append("Invalidation: ").append(invalidation()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateInvalidationResponse> {
        /**
         * <p>
         * The fully qualified URI of the distribution and invalidation batch request, including the
         * <code>Invalidation ID</code>.
         * </p>
         * 
         * @param location
         *        The fully qualified URI of the distribution and invalidation batch request, including the
         *        <code>Invalidation ID</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The invalidation's information.
         * </p>
         * 
         * @param invalidation
         *        The invalidation's information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidation(Invalidation invalidation);
    }

    private static final class BuilderImpl implements Builder {
        private String location;

        private Invalidation invalidation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInvalidationResponse model) {
            setLocation(model.location);
            setInvalidation(model.invalidation);
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final Invalidation getInvalidation() {
            return invalidation;
        }

        @Override
        public final Builder invalidation(Invalidation invalidation) {
            this.invalidation = invalidation;
            return this;
        }

        public final void setInvalidation(Invalidation invalidation) {
            this.invalidation = invalidation;
        }

        @Override
        public CreateInvalidationResponse build() {
            return new CreateInvalidationResponse(this);
        }
    }
}
