/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to create a new distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDistributionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateDistributionRequest.Builder, CreateDistributionRequest> {
    private final DistributionConfig distributionConfig;

    private CreateDistributionRequest(BuilderImpl builder) {
        this.distributionConfig = builder.distributionConfig;
    }

    /**
     * <p>
     * The distribution's configuration information.
     * </p>
     * 
     * @return The distribution's configuration information.
     */
    public DistributionConfig distributionConfig() {
        return distributionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((distributionConfig() == null) ? 0 : distributionConfig().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDistributionRequest)) {
            return false;
        }
        CreateDistributionRequest other = (CreateDistributionRequest) obj;
        if (other.distributionConfig() == null ^ this.distributionConfig() == null) {
            return false;
        }
        if (other.distributionConfig() != null && !other.distributionConfig().equals(this.distributionConfig())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (distributionConfig() != null) {
            sb.append("DistributionConfig: ").append(distributionConfig()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDistributionRequest> {
        /**
         * <p>
         * The distribution's configuration information.
         * </p>
         * 
         * @param distributionConfig
         *        The distribution's configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionConfig(DistributionConfig distributionConfig);
    }

    private static final class BuilderImpl implements Builder {
        private DistributionConfig distributionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDistributionRequest model) {
            setDistributionConfig(model.distributionConfig);
        }

        public final DistributionConfig getDistributionConfig() {
            return distributionConfig;
        }

        @Override
        public final Builder distributionConfig(DistributionConfig distributionConfig) {
            this.distributionConfig = distributionConfig;
            return this;
        }

        public final void setDistributionConfig(DistributionConfig distributionConfig) {
            this.distributionConfig = distributionConfig;
        }

        @Override
        public CreateDistributionRequest build() {
            return new CreateDistributionRequest(this);
        }
    }
}
