/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lists the origin access identities for CloudFront.Send a <code>GET</code> request to the
 * <code>/<i>CloudFront API version</i>/origin-access-identity/cloudfront</code> resource. The response includes a
 * <code>CloudFrontOriginAccessIdentityList</code> element with zero or more
 * <code>CloudFrontOriginAccessIdentitySummary</code> child elements. By default, your entire list of origin access
 * identities is returned in one single page. If the list is long, you can paginate it using the <code>MaxItems</code>
 * and <code>Marker</code> parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CloudFrontOriginAccessIdentityList implements
        ToCopyableBuilder<CloudFrontOriginAccessIdentityList.Builder, CloudFrontOriginAccessIdentityList> {
    private final String marker;

    private final String nextMarker;

    private final Integer maxItems;

    private final Boolean isTruncated;

    private final Integer quantity;

    private final List<CloudFrontOriginAccessIdentitySummary> items;

    private CloudFrontOriginAccessIdentityList(BuilderImpl builder) {
        this.marker = builder.marker;
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
        this.isTruncated = builder.isTruncated;
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * Use this when paginating results to indicate where to begin in your list of origin access identities. The results
     * include identities in the list that occur after the marker. To get the next page of results, set the
     * <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also
     * the ID of the last identity on that page).
     * </p>
     * 
     * @return Use this when paginating results to indicate where to begin in your list of origin access identities. The
     *         results include identities in the list that occur after the marker. To get the next page of results, set
     *         the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response
     *         (which is also the ID of the last identity on that page).
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value you can use for
     * the <code>Marker</code> request parameter to continue listing your origin access identities where they left off.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value you can
     *         use for the <code>Marker</code> request parameter to continue listing your origin access identities where
     *         they left off.
     */
    public String nextMarker() {
        return nextMarker;
    }

    /**
     * <p>
     * The maximum number of origin access identities you want in the response body.
     * </p>
     * 
     * @return The maximum number of origin access identities you want in the response body.
     */
    public Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * A flag that indicates whether more origin access identities remain to be listed. If your results were truncated,
     * you can make a follow-up pagination request using the <code>Marker</code> request parameter to retrieve more
     * items in the list.
     * </p>
     * 
     * @return A flag that indicates whether more origin access identities remain to be listed. If your results were
     *         truncated, you can make a follow-up pagination request using the <code>Marker</code> request parameter to
     *         retrieve more items in the list.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * The number of CloudFront origin access identities that were created by the current AWS account.
     * </p>
     * 
     * @return The number of CloudFront origin access identities that were created by the current AWS account.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * A complex type that contains one <code>CloudFrontOriginAccessIdentitySummary</code> element for each origin
     * access identity that was created by the current AWS account.
     * </p>
     * 
     * @return A complex type that contains one <code>CloudFrontOriginAccessIdentitySummary</code> element for each
     *         origin access identity that was created by the current AWS account.
     */
    public List<CloudFrontOriginAccessIdentitySummary> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((marker() == null) ? 0 : marker().hashCode());
        hashCode = 31 * hashCode + ((nextMarker() == null) ? 0 : nextMarker().hashCode());
        hashCode = 31 * hashCode + ((maxItems() == null) ? 0 : maxItems().hashCode());
        hashCode = 31 * hashCode + ((isTruncated() == null) ? 0 : isTruncated().hashCode());
        hashCode = 31 * hashCode + ((quantity() == null) ? 0 : quantity().hashCode());
        hashCode = 31 * hashCode + ((items() == null) ? 0 : items().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFrontOriginAccessIdentityList)) {
            return false;
        }
        CloudFrontOriginAccessIdentityList other = (CloudFrontOriginAccessIdentityList) obj;
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        if (other.items() != null && !other.items().equals(this.items())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (marker() != null) {
            sb.append("Marker: ").append(marker()).append(",");
        }
        if (nextMarker() != null) {
            sb.append("NextMarker: ").append(nextMarker()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        if (isTruncated() != null) {
            sb.append("IsTruncated: ").append(isTruncated()).append(",");
        }
        if (quantity() != null) {
            sb.append("Quantity: ").append(quantity()).append(",");
        }
        if (items() != null) {
            sb.append("Items: ").append(items()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CloudFrontOriginAccessIdentityList> {
        /**
         * <p>
         * Use this when paginating results to indicate where to begin in your list of origin access identities. The
         * results include identities in the list that occur after the marker. To get the next page of results, set the
         * <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is
         * also the ID of the last identity on that page).
         * </p>
         * 
         * @param marker
         *        Use this when paginating results to indicate where to begin in your list of origin access identities.
         *        The results include identities in the list that occur after the marker. To get the next page of
         *        results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current
         *        page's response (which is also the ID of the last identity on that page).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value you can use
         * for the <code>Marker</code> request parameter to continue listing your origin access identities where they
         * left off.
         * </p>
         * 
         * @param nextMarker
         *        If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value you
         *        can use for the <code>Marker</code> request parameter to continue listing your origin access
         *        identities where they left off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The maximum number of origin access identities you want in the response body.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of origin access identities you want in the response body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * A flag that indicates whether more origin access identities remain to be listed. If your results were
         * truncated, you can make a follow-up pagination request using the <code>Marker</code> request parameter to
         * retrieve more items in the list.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether more origin access identities remain to be listed. If your results were
         *        truncated, you can make a follow-up pagination request using the <code>Marker</code> request parameter
         *        to retrieve more items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * The number of CloudFront origin access identities that were created by the current AWS account.
         * </p>
         * 
         * @param quantity
         *        The number of CloudFront origin access identities that were created by the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * A complex type that contains one <code>CloudFrontOriginAccessIdentitySummary</code> element for each origin
         * access identity that was created by the current AWS account.
         * </p>
         * 
         * @param items
         *        A complex type that contains one <code>CloudFrontOriginAccessIdentitySummary</code> element for each
         *        origin access identity that was created by the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<CloudFrontOriginAccessIdentitySummary> items);

        /**
         * <p>
         * A complex type that contains one <code>CloudFrontOriginAccessIdentitySummary</code> element for each origin
         * access identity that was created by the current AWS account.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setItems(java.util.Collection)} or {@link #withItems(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param items
         *        A complex type that contains one <code>CloudFrontOriginAccessIdentitySummary</code> element for each
         *        origin access identity that was created by the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(CloudFrontOriginAccessIdentitySummary... items);
    }

    private static final class BuilderImpl implements Builder {
        private String marker;

        private String nextMarker;

        private Integer maxItems;

        private Boolean isTruncated;

        private Integer quantity;

        private List<CloudFrontOriginAccessIdentitySummary> items = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFrontOriginAccessIdentityList model) {
            setMarker(model.marker);
            setNextMarker(model.nextMarker);
            setMaxItems(model.maxItems);
            setIsTruncated(model.isTruncated);
            setQuantity(model.quantity);
            setItems(model.items);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<CloudFrontOriginAccessIdentitySummary> getItems() {
            return items;
        }

        @Override
        public final Builder items(Collection<CloudFrontOriginAccessIdentitySummary> items) {
            this.items = CloudFrontOriginAccessIdentitySummaryListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(CloudFrontOriginAccessIdentitySummary... items) {
            if (this.items == null) {
                this.items = new SdkInternalList<>(items.length);
            }
            for (CloudFrontOriginAccessIdentitySummary e : items) {
                this.items.add(e);
            }
            return this;
        }

        public final void setItems(Collection<CloudFrontOriginAccessIdentitySummary> items) {
            this.items = CloudFrontOriginAccessIdentitySummaryListCopier.copy(items);
        }

        @SafeVarargs
        public final void setItems(CloudFrontOriginAccessIdentitySummary... items) {
            if (this.items == null) {
                this.items = new SdkInternalList<>(items.length);
            }
            for (CloudFrontOriginAccessIdentitySummary e : items) {
                this.items.add(e);
            }
        }

        @Override
        public CloudFrontOriginAccessIdentityList build() {
            return new CloudFrontOriginAccessIdentityList(this);
        }
    }
}
