/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your
 * custom origin. There are three choices:
 * </p>
 * <ul>
 * <li>
 * <p>
 * CloudFront forwards only <code>GET</code> and <code>HEAD</code> requests.
 * </p>
 * </li>
 * <li>
 * <p>
 * CloudFront forwards only <code>GET</code>, <code>HEAD</code>, and <code>OPTIONS</code> requests.
 * </p>
 * </li>
 * <li>
 * <p>
 * CloudFront forwards <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code>, and <code>DELETE</code> requests.
 * </p>
 * </li>
 * </ul>
 * <p>
 * If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so
 * users can't perform operations that you don't want them to. For example, you might not want users to have permissions
 * to delete objects from your origin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AllowedMethods implements ToCopyableBuilder<AllowedMethods.Builder, AllowedMethods> {
    private final Integer quantity;

    private final List<String> items;

    private final CachedMethods cachedMethods;

    private AllowedMethods(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
        this.cachedMethods = builder.cachedMethods;
    }

    /**
     * <p>
     * The number of HTTP methods that you want CloudFront to forward to your origin. Valid values are 2 (for
     * <code>GET</code> and <code>HEAD</code> requests), 3 (for <code>GET</code>, <code>HEAD</code>, and
     * <code>OPTIONS</code> requests) and 7 (for <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code>, and
     * <code>DELETE</code> requests).
     * </p>
     * 
     * @return The number of HTTP methods that you want CloudFront to forward to your origin. Valid values are 2 (for
     *         <code>GET</code> and <code>HEAD</code> requests), 3 (for <code>GET</code>, <code>HEAD</code>, and
     *         <code>OPTIONS</code> requests) and 7 (for <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code>, and
     *         <code>DELETE</code> requests).
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * A complex type that contains the HTTP methods that you want CloudFront to process and forward to your origin.
     * </p>
     * 
     * @return A complex type that contains the HTTP methods that you want CloudFront to process and forward to your
     *         origin.
     * @see Method
     */
    public List<String> items() {
        return items;
    }

    /**
     *
     * @return
     */
    public CachedMethods cachedMethods() {
        return cachedMethods;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((quantity() == null) ? 0 : quantity().hashCode());
        hashCode = 31 * hashCode + ((items() == null) ? 0 : items().hashCode());
        hashCode = 31 * hashCode + ((cachedMethods() == null) ? 0 : cachedMethods().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllowedMethods)) {
            return false;
        }
        AllowedMethods other = (AllowedMethods) obj;
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        if (other.items() != null && !other.items().equals(this.items())) {
            return false;
        }
        if (other.cachedMethods() == null ^ this.cachedMethods() == null) {
            return false;
        }
        if (other.cachedMethods() != null && !other.cachedMethods().equals(this.cachedMethods())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (quantity() != null) {
            sb.append("Quantity: ").append(quantity()).append(",");
        }
        if (items() != null) {
            sb.append("Items: ").append(items()).append(",");
        }
        if (cachedMethods() != null) {
            sb.append("CachedMethods: ").append(cachedMethods()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AllowedMethods> {
        /**
         * <p>
         * The number of HTTP methods that you want CloudFront to forward to your origin. Valid values are 2 (for
         * <code>GET</code> and <code>HEAD</code> requests), 3 (for <code>GET</code>, <code>HEAD</code>, and
         * <code>OPTIONS</code> requests) and 7 (for <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code>, and
         * <code>DELETE</code> requests).
         * </p>
         * 
         * @param quantity
         *        The number of HTTP methods that you want CloudFront to forward to your origin. Valid values are 2 (for
         *        <code>GET</code> and <code>HEAD</code> requests), 3 (for <code>GET</code>, <code>HEAD</code>, and
         *        <code>OPTIONS</code> requests) and 7 (for <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code>, and
         *        <code>DELETE</code> requests).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * A complex type that contains the HTTP methods that you want CloudFront to process and forward to your origin.
         * </p>
         * 
         * @param items
         *        A complex type that contains the HTTP methods that you want CloudFront to process and forward to your
         *        origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Method
         */
        Builder items(Collection<String> items);

        /**
         * <p>
         * A complex type that contains the HTTP methods that you want CloudFront to process and forward to your origin.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setItems(java.util.Collection)} or {@link #withItems(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param items
         *        A complex type that contains the HTTP methods that you want CloudFront to process and forward to your
         *        origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Method
         */
        Builder items(String... items);

        /**
         * <p>
         * A complex type that contains the HTTP methods that you want CloudFront to process and forward to your origin.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setItems(java.util.Collection)} or {@link #withItems(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param items
         *        A complex type that contains the HTTP methods that you want CloudFront to process and forward to your
         *        origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Method
         */
        Builder items(Method... items);

        /**
         *
         * @param cachedMethods
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachedMethods(CachedMethods cachedMethods);
    }

    private static final class BuilderImpl implements Builder {
        private Integer quantity;

        private List<String> items = new SdkInternalList<>();

        private CachedMethods cachedMethods;

        private BuilderImpl() {
        }

        private BuilderImpl(AllowedMethods model) {
            setQuantity(model.quantity);
            setItems(model.items);
            setCachedMethods(model.cachedMethods);
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<String> getItems() {
            return items;
        }

        @Override
        public final Builder items(Collection<String> items) {
            this.items = MethodsListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(String... items) {
            if (this.items == null) {
                this.items = new SdkInternalList<>(items.length);
            }
            for (String e : items) {
                this.items.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Method... items) {
            if (this.items == null) {
                this.items = new SdkInternalList<String>(items.length);
            }
            for (Method ele : items) {
                this.items.add(ele.toString());
            }
            return this;
        }

        public final void setItems(Collection<String> items) {
            this.items = MethodsListCopier.copy(items);
        }

        @SafeVarargs
        public final void setItems(String... items) {
            if (this.items == null) {
                this.items = new SdkInternalList<>(items.length);
            }
            for (String e : items) {
                this.items.add(e);
            }
        }

        @SafeVarargs
        public final void setItems(Method... items) {
            if (this.items == null) {
                this.items = new SdkInternalList<String>(items.length);
            }
            for (Method ele : items) {
                this.items.add(ele.toString());
            }
        }

        public final CachedMethods getCachedMethods() {
            return cachedMethods;
        }

        @Override
        public final Builder cachedMethods(CachedMethods cachedMethods) {
            this.cachedMethods = cachedMethods;
            return this;
        }

        public final void setCachedMethods(CachedMethods cachedMethods) {
            this.cachedMethods = cachedMethods;
        }

        @Override
        public AllowedMethods build() {
            return new AllowedMethods(this);
        }
    }
}
