/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.AllowedValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParameterConstraints
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParameterConstraints> {
    private static final SdkField<List<String>> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ParameterConstraints.getter(ParameterConstraints::allowedValues)).setter(ParameterConstraints.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> allowedValues;

    private ParameterConstraints(BuilderImpl builder) {
        this.allowedValues = builder.allowedValues;
    }

    public List<String> allowedValues() {
        return this.allowedValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterConstraints)) {
            return false;
        }
        ParameterConstraints other = (ParameterConstraints)obj;
        return Objects.equals(this.allowedValues(), other.allowedValues());
    }

    public String toString() {
        return ToString.builder((String)"ParameterConstraints").add("AllowedValues", this.allowedValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterConstraints, T> g) {
        return obj -> g.apply((ParameterConstraints)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterConstraints model) {
            this.allowedValues(model.allowedValues);
        }

        public final Collection<String> getAllowedValues() {
            return this.allowedValues;
        }

        @Override
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(String ... allowedValues) {
            this.allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copy(allowedValues);
        }

        public ParameterConstraints build() {
            return new ParameterConstraints(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParameterConstraints> {
        public Builder allowedValues(Collection<String> var1);

        public Builder allowedValues(String ... var1);
    }
}

