/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.ResourcesToSkipCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContinueUpdateRollbackRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, ContinueUpdateRollbackRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContinueUpdateRollbackRequest.getter(ContinueUpdateRollbackRequest::stackName)).setter(ContinueUpdateRollbackRequest.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContinueUpdateRollbackRequest.getter(ContinueUpdateRollbackRequest::roleARN)).setter(ContinueUpdateRollbackRequest.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<List<String>> RESOURCES_TO_SKIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ContinueUpdateRollbackRequest.getter(ContinueUpdateRollbackRequest::resourcesToSkip)).setter(ContinueUpdateRollbackRequest.setter(Builder::resourcesToSkip)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesToSkip").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContinueUpdateRollbackRequest.getter(ContinueUpdateRollbackRequest::clientRequestToken)).setter(ContinueUpdateRollbackRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD, ROLE_ARN_FIELD, RESOURCES_TO_SKIP_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String stackName;
    private final String roleARN;
    private final List<String> resourcesToSkip;
    private final String clientRequestToken;

    private ContinueUpdateRollbackRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.roleARN = builder.roleARN;
        this.resourcesToSkip = builder.resourcesToSkip;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public String stackName() {
        return this.stackName;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public List<String> resourcesToSkip() {
        return this.resourcesToSkip;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesToSkip());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinueUpdateRollbackRequest)) {
            return false;
        }
        ContinueUpdateRollbackRequest other = (ContinueUpdateRollbackRequest)((Object)obj);
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.resourcesToSkip(), other.resourcesToSkip()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public String toString() {
        return ToString.builder((String)"ContinueUpdateRollbackRequest").add("StackName", (Object)this.stackName()).add("RoleARN", (Object)this.roleARN()).add("ResourcesToSkip", this.resourcesToSkip()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "ResourcesToSkip": {
                return Optional.ofNullable(clazz.cast(this.resourcesToSkip()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContinueUpdateRollbackRequest, T> g) {
        return obj -> g.apply((ContinueUpdateRollbackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String stackName;
        private String roleARN;
        private List<String> resourcesToSkip = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ContinueUpdateRollbackRequest model) {
            super(model);
            this.stackName(model.stackName);
            this.roleARN(model.roleARN);
            this.resourcesToSkip(model.resourcesToSkip);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Collection<String> getResourcesToSkip() {
            return this.resourcesToSkip;
        }

        @Override
        public final Builder resourcesToSkip(Collection<String> resourcesToSkip) {
            this.resourcesToSkip = ResourcesToSkipCopier.copy(resourcesToSkip);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesToSkip(String ... resourcesToSkip) {
            this.resourcesToSkip(Arrays.asList(resourcesToSkip));
            return this;
        }

        public final void setResourcesToSkip(Collection<String> resourcesToSkip) {
            this.resourcesToSkip = ResourcesToSkipCopier.copy(resourcesToSkip);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ContinueUpdateRollbackRequest build() {
            return new ContinueUpdateRollbackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ContinueUpdateRollbackRequest> {
        public Builder stackName(String var1);

        public Builder roleARN(String var1);

        public Builder resourcesToSkip(Collection<String> var1);

        public Builder resourcesToSkip(String ... var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

